/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl;

import com.google.appengine.api.datastore.DatastoreTimeoutException;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.Query;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatastoreTimeoutRetryProxy
implements InvocationHandler {
    Object wrapped;
    int retries;

    public static <T> T wrap(T impl, int retries) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Objectify.class, Query.class, QueryResultIterable.class, QueryResultIterator.class, Iterable.class, Iterator.class}, (InvocationHandler)new DatastoreTimeoutRetryProxy(impl, retries));
    }

    protected DatastoreTimeoutRetryProxy(Object wrapped, int retries) {
        this.wrapped = wrapped;
        this.retries = retries;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int tries = 0;
        while (true) {
            try {
                return method.invoke(this.wrapped, args);
            }
            catch (InvocationTargetException ex) {
                if (ex.getCause() instanceof DatastoreTimeoutException) {
                    if (tries == this.retries) {
                        throw ex.getCause();
                    }
                    ++tries;
                    continue;
                }
                throw ex.getCause();
            }
            break;
        }
    }
}

