/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.KeyFactory;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.annotation.Cached;
import com.googlecode.objectify.annotation.Parent;
import com.googlecode.objectify.impl.Transmog;
import com.googlecode.objectify.impl.TypeUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityMetadata<T> {
    protected ObjectifyFactory factory;
    protected Class<T> entityClass;
    protected Constructor<T> entityClassConstructor;
    protected String kind;
    protected Field idField;
    protected Field nameField;
    protected Field parentField;
    protected List<Method> prePersistMethods;
    protected List<Method> postLoadMethods;
    protected Transmog<T> transmog;
    protected Cached cached;

    public EntityMetadata(ObjectifyFactory fact, Class<T> clazz) {
        this.factory = fact;
        this.entityClass = clazz;
        this.entityClassConstructor = TypeUtils.getNoArgConstructor(clazz);
        this.kind = this.factory.getKind(clazz);
        this.cached = clazz.getAnnotation(Cached.class);
        this.processKeyFields(clazz);
        this.processLifecycleCallbacks(clazz);
        this.transmog = new Transmog<T>(fact, clazz);
        if (this.idField == null && this.nameField == null) {
            throw new IllegalStateException("There must be an @Id field (String, Long, or long) for " + this.entityClass.getName());
        }
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public String getKind() {
        return this.kind;
    }

    public Cached getCached() {
        return this.cached;
    }

    private void processKeyFields(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        this.processKeyFields(clazz.getSuperclass());
        for (Field field : clazz.getDeclaredFields()) {
            if (!TypeUtils.isSaveable(field)) continue;
            field.setAccessible(true);
            if (field.isAnnotationPresent(Id.class)) {
                if (this.idField != null || this.nameField != null) {
                    throw new IllegalStateException("Multiple @Id fields in the class hierarchy of " + this.entityClass.getName());
                }
                if (field.getType() == Long.class || field.getType() == Long.TYPE) {
                    this.idField = field;
                    continue;
                }
                if (field.getType() == String.class) {
                    this.nameField = field;
                    continue;
                }
                throw new IllegalStateException("Only fields of type Long, long, or String are allowed as @Id. Invalid on field " + field + " in " + clazz.getName());
            }
            if (!field.isAnnotationPresent(Parent.class)) continue;
            if (this.parentField != null) {
                throw new IllegalStateException("Multiple @Parent fields in the class hierarchy of " + this.entityClass.getName());
            }
            if (field.getType() != com.google.appengine.api.datastore.Key.class && field.getType() != Key.class) {
                throw new IllegalStateException("Only fields of type Key<?> or Key are allowed as @Parent. Illegal parent '" + field + "' in " + clazz.getName());
            }
            this.parentField = field;
        }
    }

    private void processLifecycleCallbacks(Class<?> clazz) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        this.processLifecycleCallbacks(clazz.getSuperclass());
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(PrePersist.class) && !method.isAnnotationPresent(PostLoad.class)) continue;
            method.setAccessible(true);
            Class<?>[] ptypes = method.getParameterTypes();
            if (ptypes.length > 1 || ptypes.length == 1 && !Entity.class.isAssignableFrom(ptypes[0])) {
                throw new IllegalStateException("@PrePersist and @PostLoad methods can have at most one parameter of type Entity");
            }
            if (method.isAnnotationPresent(PrePersist.class)) {
                if (this.prePersistMethods == null) {
                    this.prePersistMethods = new ArrayList<Method>();
                }
                this.prePersistMethods.add(method);
            }
            if (!method.isAnnotationPresent(PostLoad.class)) continue;
            if (this.postLoadMethods == null) {
                this.postLoadMethods = new ArrayList<Method>();
            }
            this.postLoadMethods.add(method);
        }
    }

    public T toObject(Entity ent) {
        T pojo = TypeUtils.newInstance(this.entityClassConstructor, new Object[0]);
        this.setKey(pojo, ent.getKey());
        this.transmog.load(ent, pojo);
        this.invokeLifecycleCallbacks(this.postLoadMethods, pojo, ent);
        return pojo;
    }

    public Entity toEntity(T pojo) {
        Entity ent = this.initEntity(pojo);
        this.invokeLifecycleCallbacks(this.prePersistMethods, pojo, ent);
        this.transmog.save(pojo, ent);
        return ent;
    }

    private void invokeLifecycleCallbacks(List<Method> callbacks, Object pojo, Entity ent) {
        try {
            if (callbacks != null) {
                for (Method method : callbacks) {
                    if (method.getParameterTypes().length == 0) {
                        method.invoke(pojo, new Object[0]);
                        continue;
                    }
                    method.invoke(pojo, ent);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    Entity initEntity(T obj) {
        try {
            com.google.appengine.api.datastore.Key parentKey = null;
            if (this.parentField != null && (parentKey = this.getRawKey(this.parentField, obj)) == null) {
                throw new IllegalStateException("Missing parent of " + obj);
            }
            if (this.idField != null) {
                Long id = (Long)this.idField.get(obj);
                if (id != null) {
                    if (parentKey != null) {
                        return new Entity(KeyFactory.createKey((com.google.appengine.api.datastore.Key)parentKey, (String)this.kind, (long)id));
                    }
                    return new Entity(KeyFactory.createKey((String)this.kind, (long)id));
                }
                if (parentKey != null) {
                    return new Entity(this.kind, parentKey);
                }
                return new Entity(this.kind);
            }
            String name = (String)this.nameField.get(obj);
            if (name == null) {
                throw new IllegalStateException("Tried to persist null String @Id for " + obj);
            }
            if (parentKey != null) {
                return new Entity(this.kind, name, parentKey);
            }
            return new Entity(this.kind, name);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void setKey(T obj, com.google.appengine.api.datastore.Key key) {
        if (!this.entityClass.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Trying to use metadata for " + this.entityClass.getName() + " to set key of " + obj.getClass().getName());
        }
        try {
            if (key.getName() != null) {
                if (this.nameField == null) {
                    throw new IllegalStateException("Loaded Entity has name but " + this.entityClass.getName() + " has no String @Id");
                }
                this.nameField.set(obj, key.getName());
            } else {
                if (this.idField == null) {
                    throw new IllegalStateException("Loaded Entity has numeric id but " + this.entityClass.getName() + " has no Long (or long) @Id");
                }
                this.idField.set(obj, key.getId());
            }
            com.google.appengine.api.datastore.Key parentKey = key.getParent();
            if (parentKey != null) {
                if (this.parentField == null) {
                    throw new IllegalStateException("Loaded Entity has parent but " + this.entityClass.getName() + " has no @Parent");
                }
                if (this.parentField.getType() == com.google.appengine.api.datastore.Key.class) {
                    this.parentField.set(obj, parentKey);
                } else {
                    this.parentField.set(obj, this.factory.rawKeyToTypedKey(parentKey));
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public com.google.appengine.api.datastore.Key getKey(Object obj) {
        if (!this.entityClass.isAssignableFrom(obj.getClass())) {
            throw new IllegalArgumentException("Trying to use metadata for " + this.entityClass.getName() + " to get key of " + obj.getClass().getName());
        }
        try {
            if (this.nameField != null) {
                String name = (String)this.nameField.get(obj);
                if (this.parentField != null) {
                    com.google.appengine.api.datastore.Key parent = this.getRawKey(this.parentField, obj);
                    return KeyFactory.createKey((com.google.appengine.api.datastore.Key)parent, (String)this.kind, (String)name);
                }
                return KeyFactory.createKey((String)this.kind, (String)name);
            }
            Long id = (Long)this.idField.get(obj);
            if (id == null) {
                throw new IllegalArgumentException("You cannot create a Key for an object with a null @Id. Object was " + obj);
            }
            if (this.parentField != null) {
                com.google.appengine.api.datastore.Key parent = this.getRawKey(this.parentField, obj);
                return KeyFactory.createKey((com.google.appengine.api.datastore.Key)parent, (String)this.kind, (long)id);
            }
            return KeyFactory.createKey((String)this.kind, (long)id);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private com.google.appengine.api.datastore.Key getRawKey(Field keyField, Object obj) throws IllegalAccessException {
        if (keyField.getType() == com.google.appengine.api.datastore.Key.class) {
            return (com.google.appengine.api.datastore.Key)keyField.get(obj);
        }
        return this.factory.typedKeyToRawKey((Key)keyField.get(obj));
    }

    public boolean isIdField(String propertyName) {
        return this.idField != null && this.idField.getName().equals(propertyName);
    }

    public boolean isNameField(String propertyName) {
        return this.nameField != null && this.nameField.getName().equals(propertyName);
    }

    public boolean hasParentField() {
        return this.parentField != null;
    }
}

