/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl;

import com.google.appengine.api.datastore.Entity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadContext {
    Object pojo;
    Entity entity;
    Set<String> processedEmbeddedMultivaluePaths;
    List<Runnable> doneHandlers;

    public Object getPojo() {
        return this.pojo;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public LoadContext(Object pojo, Entity entity) {
        this.pojo = pojo;
        this.entity = entity;
    }

    public Set<String> getProcessedEmbeddedMultivaluePaths() {
        if (this.processedEmbeddedMultivaluePaths == null) {
            return Collections.emptySet();
        }
        return this.processedEmbeddedMultivaluePaths;
    }

    public void addProcessedEmbeddedPath(String path) {
        if (this.processedEmbeddedMultivaluePaths == null) {
            this.processedEmbeddedMultivaluePaths = new HashSet<String>();
        }
        this.processedEmbeddedMultivaluePaths.add(path);
    }

    public void addDoneHandler(Runnable handler) {
        if (this.doneHandlers == null) {
            this.doneHandlers = new ArrayList<Runnable>();
        }
        this.doneHandlers.add(handler);
    }

    public void done() {
        if (this.doneHandlers != null) {
            for (Runnable handler : this.doneHandlers) {
                handler.run();
            }
        }
    }
}

