/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Transaction;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.Query;
import com.googlecode.objectify.impl.EntityMetadata;
import com.googlecode.objectify.impl.QueryImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectifyImpl
implements Objectify {
    protected ObjectifyFactory factory;
    protected DatastoreService ds;
    protected Transaction txn;

    public ObjectifyImpl(ObjectifyFactory fact, DatastoreService ds, Transaction txn) {
        this.factory = fact;
        this.ds = ds;
        this.txn = txn;
    }

    @Override
    public <T> Map<Key<T>, T> get(Iterable<? extends Key<? extends T>> keys) {
        ArrayList<com.google.appengine.api.datastore.Key> rawKeys = new ArrayList<com.google.appengine.api.datastore.Key>();
        for (Key<T> key : keys) {
            rawKeys.add(this.factory.typedKeyToRawKey(key));
        }
        Map entities = this.ds.get(this.txn, rawKeys);
        LinkedHashMap linkedHashMap = new LinkedHashMap(entities.size() * 2);
        for (com.google.appengine.api.datastore.Key rawKey : rawKeys) {
            Entity entity = (Entity)entities.get(rawKey);
            if (entity == null) continue;
            EntityMetadata metadata = this.factory.getMetadata(rawKey);
            Key obKey = this.factory.rawKeyToTypedKey(rawKey);
            linkedHashMap.put(obKey, metadata.toObject(entity));
        }
        return linkedHashMap;
    }

    @Override
    public <T> T get(Key<? extends T> key) throws EntityNotFoundException {
        Entity ent = this.ds.get(this.txn, this.factory.typedKeyToRawKey(key));
        return this.factory.getMetadata(key).toObject(ent);
    }

    @Override
    public <T> T get(Class<? extends T> clazz, long id) throws EntityNotFoundException {
        return this.get(new Key<T>(clazz, id));
    }

    @Override
    public <T> T get(Class<? extends T> clazz, String name) throws EntityNotFoundException {
        return this.get(new Key<T>(clazz, name));
    }

    @Override
    public <S, T> Map<S, T> get(Class<? extends T> clazz, Iterable<S> ids) {
        ArrayList<Key<? extends T>> keys = new ArrayList<Key<? extends T>>();
        for (S id : ids) {
            if (id instanceof Long) {
                keys.add(new Key<T>(clazz, (Long)id));
                continue;
            }
            if (id instanceof String) {
                keys.add(new Key<T>(clazz, (String)id));
                continue;
            }
            throw new IllegalArgumentException("Only Long or String is allowed, not " + id.getClass().getName() + " (" + id + ")");
        }
        Map<Key<T>, T> fetched = this.get(keys);
        LinkedHashMap<Object, T> result = new LinkedHashMap<Object, T>(fetched.size() * 2);
        for (Map.Entry<Key<T>, T> entry : fetched.entrySet()) {
            Object mapKey = entry.getKey().getName() != null ? entry.getKey().getName() : Long.valueOf(entry.getKey().getId());
            result.put(mapKey, entry.getValue());
        }
        return result;
    }

    @Override
    public <T> T find(Key<? extends T> key) {
        try {
            return this.get(key);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public <T> T find(Class<? extends T> clazz, long id) {
        try {
            return this.get(clazz, id);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public <T> T find(Class<? extends T> clazz, String name) {
        try {
            return this.get(clazz, name);
        }
        catch (EntityNotFoundException e) {
            return null;
        }
    }

    @Override
    public <T> Key<T> put(T obj) {
        EntityMetadata<T> metadata = this.factory.getMetadataForEntity(obj);
        Entity ent = metadata.toEntity(obj);
        com.google.appengine.api.datastore.Key rawKey = this.ds.put(this.txn, ent);
        metadata.setKey(obj, rawKey);
        return this.factory.rawKeyToTypedKey(rawKey);
    }

    @Override
    public <T> Map<Key<T>, T> put(Iterable<? extends T> objs) {
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        for (T obj : objs) {
            EntityMetadata<T> metadata = this.factory.getMetadataForEntity(obj);
            entityList.add(metadata.toEntity(obj));
        }
        List rawKeys = this.ds.put(this.txn, entityList);
        LinkedHashMap result = new LinkedHashMap(rawKeys.size() * 2);
        Iterator keysIt = rawKeys.iterator();
        for (T obj : objs) {
            com.google.appengine.api.datastore.Key k = (com.google.appengine.api.datastore.Key)keysIt.next();
            EntityMetadata<T> metadata = this.factory.getMetadataForEntity(obj);
            metadata.setKey(obj, k);
            Key obKey = this.factory.rawKeyToTypedKey(k);
            result.put(obKey, obj);
        }
        return result;
    }

    @Override
    public void delete(Object keyOrEntity) {
        this.ds.delete(this.txn, new com.google.appengine.api.datastore.Key[]{this.factory.getRawKey(keyOrEntity)});
    }

    @Override
    public <T> void delete(Class<T> clazz, long id) {
        this.delete(new Key<T>(clazz, id));
    }

    @Override
    public <T> void delete(Class<T> clazz, String name) {
        this.delete(new Key<T>(clazz, name));
    }

    @Override
    public void delete(Iterable<?> keysOrEntities) {
        ArrayList<com.google.appengine.api.datastore.Key> keys = new ArrayList<com.google.appengine.api.datastore.Key>();
        for (Object obj : keysOrEntities) {
            keys.add(this.factory.getRawKey(obj));
        }
        this.ds.delete(this.txn, keys);
    }

    @Override
    public <T> Query<T> query() {
        QueryImpl query = new QueryImpl(this.factory, this);
        return this.factory.maybeWrap(query);
    }

    @Override
    public <T> Query<T> query(Class<T> clazz) {
        QueryImpl<T> query = new QueryImpl<T>(this.factory, this, clazz);
        return this.factory.maybeWrap(query);
    }

    @Override
    public Transaction getTxn() {
        return this.txn;
    }

    @Override
    public DatastoreService getDatastore() {
        return this.ds;
    }

    @Override
    public ObjectifyFactory getFactory() {
        return this.factory;
    }
}

