/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.Query;
import com.googlecode.objectify.impl.EntityMetadata;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl<T>
implements Query<T> {
    ObjectifyFactory factory;
    Objectify ofy;
    Class<T> classRestriction;
    com.google.appengine.api.datastore.Query actual;
    int limit;
    int offset;
    Cursor cursor;

    public QueryImpl(ObjectifyFactory fact, Objectify objectify) {
        this.factory = fact;
        this.ofy = objectify;
        this.actual = new com.google.appengine.api.datastore.Query();
    }

    public QueryImpl(ObjectifyFactory fact, Objectify objectify, Class<T> clazz) {
        this.factory = fact;
        this.ofy = objectify;
        this.actual = new com.google.appengine.api.datastore.Query(this.factory.getKind(clazz));
        this.classRestriction = clazz;
    }

    protected com.google.appengine.api.datastore.Query getActual() {
        return this.actual;
    }

    @Override
    public Query<T> filter(String condition, Object value) {
        EntityMetadata<T> meta;
        Query.FilterOperator op;
        String[] parts = condition.trim().split(" ");
        if (parts.length < 1 || parts.length > 2) {
            throw new IllegalArgumentException("'" + condition + "' is not a legal filter condition");
        }
        String prop = parts[0].trim();
        Query.FilterOperator filterOperator = op = parts.length == 2 ? this.translate(parts[1]) : Query.FilterOperator.EQUAL;
        if (this.classRestriction != null && ((meta = this.factory.getMetadata(this.classRestriction)).isIdField(prop) || meta.isNameField(prop))) {
            if (meta.hasParentField()) {
                throw new IllegalStateException("Cannot (yet) filter by @Id fields on entities which have @Parent fields. Tried '" + prop + "' on " + this.classRestriction.getName() + ".");
            }
            value = meta.isIdField(prop) ? KeyFactory.createKey((String)meta.getKind(), (long)((Number)value).longValue()) : KeyFactory.createKey((String)meta.getKind(), (String)value.toString());
            prop = "__key__";
        }
        value = this.factory.makeFilterable(value);
        this.actual.addFilter(prop, op, value);
        return this;
    }

    protected Query.FilterOperator translate(String operator) {
        if ((operator = operator.trim()).equals("=") || operator.equals("==")) {
            return Query.FilterOperator.EQUAL;
        }
        if (operator.equals(">")) {
            return Query.FilterOperator.GREATER_THAN;
        }
        if (operator.equals(">=")) {
            return Query.FilterOperator.GREATER_THAN_OR_EQUAL;
        }
        if (operator.equals("<")) {
            return Query.FilterOperator.LESS_THAN;
        }
        if (operator.equals("<=")) {
            return Query.FilterOperator.LESS_THAN_OR_EQUAL;
        }
        if (operator.equals("!=") || operator.equals("<>")) {
            return Query.FilterOperator.NOT_EQUAL;
        }
        if (operator.toLowerCase().equals("in")) {
            return Query.FilterOperator.IN;
        }
        throw new IllegalArgumentException("Unknown operator '" + operator + "'");
    }

    @Override
    public Query<T> order(String condition) {
        EntityMetadata<T> meta;
        condition = condition.trim();
        Query.SortDirection dir = Query.SortDirection.ASCENDING;
        if (condition.startsWith("-")) {
            dir = Query.SortDirection.DESCENDING;
            condition = condition.substring(1).trim();
        }
        if (this.classRestriction != null && ((meta = this.factory.getMetadata(this.classRestriction)).isIdField(condition) || meta.isNameField(condition))) {
            condition = "__key__";
        }
        this.actual.addSort(condition, dir);
        return this;
    }

    @Override
    public Query<T> ancestor(Object keyOrEntity) {
        this.actual.setAncestor(this.factory.getRawKey(keyOrEntity));
        return this;
    }

    @Override
    public Query<T> limit(int value) {
        this.limit = value;
        return this;
    }

    @Override
    public Query<T> offset(int value) {
        this.offset = value;
        return this;
    }

    @Override
    public Query<T> cursor(Cursor value) {
        this.cursor = value;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getName());
        bld.append("{kind=");
        bld.append(this.actual.getKind());
        bld.append(",ancestor=");
        if (this.actual.getAncestor() != null) {
            bld.append(KeyFactory.keyToString((com.google.appengine.api.datastore.Key)this.actual.getAncestor()));
        }
        Query.FilterPredicate[] filters = this.actual.getFilterPredicates().toArray(new Query.FilterPredicate[this.actual.getFilterPredicates().size()]);
        Arrays.sort(filters, new Comparator<Query.FilterPredicate>(){

            @Override
            public int compare(Query.FilterPredicate o1, Query.FilterPredicate o2) {
                int result = o1.getPropertyName().compareTo(o2.getPropertyName());
                if (result != 0) {
                    return result;
                }
                result = o1.getOperator().compareTo((Enum)o2.getOperator());
                if (result != 0) {
                    return result;
                }
                if (o1.getValue() == null) {
                    return o2.getValue() == null ? 0 : -1;
                }
                if (o2.getValue() == null) {
                    return 1;
                }
                return o1.getValue().toString().compareTo(o2.getValue().toString());
            }
        });
        for (Query.FilterPredicate filter : filters) {
            bld.append(",filter=");
            bld.append(filter.getPropertyName());
            bld.append(filter.getOperator().name());
            bld.append(filter.getValue());
        }
        Query.SortPredicate[] sorts = this.actual.getSortPredicates().toArray(new Query.SortPredicate[this.actual.getSortPredicates().size()]);
        Arrays.sort(sorts, new Comparator<Query.SortPredicate>(){

            @Override
            public int compare(Query.SortPredicate o1, Query.SortPredicate o2) {
                int result = o1.getPropertyName().compareTo(o2.getPropertyName());
                if (result != 0) {
                    return result;
                }
                return o1.getDirection().compareTo((Enum)o2.getDirection());
            }
        });
        for (Query.SortPredicate sort : this.actual.getSortPredicates()) {
            bld.append(",sort=");
            bld.append(sort.getPropertyName());
            bld.append(sort.getDirection().name());
        }
        if (this.limit > 0) {
            bld.append(",limit=").append(this.limit);
        }
        if (this.offset > 0) {
            bld.append(",offset=").append(this.offset);
        }
        if (this.cursor != null) {
            bld.append(",cursor=").append(this.cursor.toWebSafeString());
        }
        bld.append('}');
        return bld.toString();
    }

    public QueryResultIterator<T> iterator() {
        FetchOptions opts = this.fetchOptions();
        if (opts == null) {
            return new ToObjectIterator((QueryResultIterator<Entity>)this.prepare().asQueryResultIterator(), false);
        }
        return new ToObjectIterator((QueryResultIterator<Entity>)this.prepare().asQueryResultIterator(opts), false);
    }

    @Override
    public T get() {
        Iterator it;
        FetchOptions opts = FetchOptions.Builder.withLimit((int)1);
        if (this.offset > 0) {
            opts = opts.offset(this.offset);
        }
        if (this.cursor != null) {
            opts = opts.cursor(this.cursor);
        }
        if ((it = this.prepare().asIterator(opts)).hasNext()) {
            Entity ent = (Entity)it.next();
            EntityMetadata metadata = this.factory.getMetadata(ent.getKey());
            return metadata.toObject(ent);
        }
        return null;
    }

    @Override
    public Key<T> getKey() {
        Iterator it;
        FetchOptions opts = FetchOptions.Builder.withLimit((int)1);
        if (this.offset > 0) {
            opts = opts.offset(this.offset);
        }
        if ((it = this.prepareKeysOnly().asIterator(opts)).hasNext()) {
            Entity ent = (Entity)it.next();
            return this.factory.rawKeyToTypedKey(ent.getKey());
        }
        return null;
    }

    @Override
    public int countAll() {
        return this.prepare().countEntities();
    }

    @Override
    public QueryResultIterable<T> fetch() {
        FetchOptions opts = this.fetchOptions();
        if (opts == null) {
            return this;
        }
        return new ToObjectIterable((QueryResultIterable<Entity>)this.prepare().asQueryResultIterable(opts), false);
    }

    @Override
    public QueryResultIterable<Key<T>> fetchKeys() {
        FetchOptions opts = this.fetchOptions();
        if (opts == null) {
            return new ToObjectIterable<Key<T>>((QueryResultIterable<Entity>)this.prepareKeysOnly().asQueryResultIterable(), true);
        }
        return new ToObjectIterable<Key<T>>((QueryResultIterable<Entity>)this.prepareKeysOnly().asQueryResultIterable(opts), true);
    }

    @Override
    public <V> Set<Key<V>> fetchParentKeys() {
        LinkedHashSet<Key<V>> parentKeys = new LinkedHashSet<Key<V>>();
        for (Key key : this.fetchKeys()) {
            if (key.getParent() == null) {
                throw new IllegalStateException("Tried to fetch parent from a key that has no parent: " + key);
            }
            parentKeys.add(key.getParent());
        }
        return parentKeys;
    }

    @Override
    public <V> Map<Key<V>, V> fetchParents() {
        Set<Key<V>> parentKeys = this.fetchParentKeys();
        return this.ofy.get(parentKeys);
    }

    private PreparedQuery prepare() {
        return this.ofy.getDatastore().prepare(this.ofy.getTxn(), this.actual);
    }

    private PreparedQuery prepareKeysOnly() {
        com.google.appengine.api.datastore.Query cloned = this.cloneRawQuery(this.actual);
        cloned.setKeysOnly();
        return this.ofy.getDatastore().prepare(this.ofy.getTxn(), cloned);
    }

    private FetchOptions fetchOptions() {
        if (this.cursor != null) {
            FetchOptions opts = FetchOptions.Builder.withCursor((Cursor)this.cursor);
            if (this.limit != 0) {
                opts = opts.limit(this.limit);
            }
            if (this.offset != 0) {
                opts = opts.offset(this.offset);
            }
            return opts;
        }
        if (this.limit != 0) {
            FetchOptions opts = FetchOptions.Builder.withLimit((int)this.limit);
            if (this.offset != 0) {
                opts = opts.offset(this.offset);
            }
            return opts;
        }
        if (this.offset != 0) {
            FetchOptions opts = FetchOptions.Builder.withOffset((int)this.offset);
            return opts;
        }
        return null;
    }

    protected com.google.appengine.api.datastore.Query cloneRawQuery(com.google.appengine.api.datastore.Query orig) {
        com.google.appengine.api.datastore.Query copy = new com.google.appengine.api.datastore.Query(orig.getKind(), orig.getAncestor());
        for (Query.FilterPredicate filter : orig.getFilterPredicates()) {
            copy.addFilter(filter.getPropertyName(), filter.getOperator(), filter.getValue());
        }
        for (Query.SortPredicate sort : orig.getSortPredicates()) {
            copy.addSort(sort.getPropertyName(), sort.getDirection());
        }
        if (orig.isKeysOnly()) {
            copy.setKeysOnly();
        }
        return copy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToObjectIterator<S>
    implements QueryResultIterator<S> {
        QueryResultIterator<Entity> source;
        boolean keysOnly;

        public ToObjectIterator(QueryResultIterator<Entity> source, boolean keysOnly) {
            this.source = QueryImpl.this.factory.maybeWrap(source);
            this.keysOnly = keysOnly;
        }

        public boolean hasNext() {
            return this.source.hasNext();
        }

        public S next() {
            Entity nextEntity = (Entity)this.source.next();
            if (this.keysOnly) {
                return (S)QueryImpl.this.factory.rawKeyToTypedKey(nextEntity.getKey());
            }
            EntityMetadata meta = QueryImpl.this.factory.getMetadata(nextEntity.getKey());
            return (S)meta.toObject(nextEntity);
        }

        public void remove() {
            this.source.remove();
        }

        public Cursor getCursor() {
            return this.source.getCursor();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ToObjectIterable<S>
    implements QueryResultIterable<S> {
        QueryResultIterable<Entity> source;
        boolean keysOnly;

        public ToObjectIterable(QueryResultIterable<Entity> source, boolean keysOnly) {
            this.source = QueryImpl.this.factory.maybeWrap(source);
            this.keysOnly = keysOnly;
        }

        public QueryResultIterator<S> iterator() {
            return new ToObjectIterator((QueryResultIterator<Entity>)this.source.iterator(), this.keysOnly);
        }
    }
}

