/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl;

import com.google.appengine.api.datastore.Entity;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.impl.FieldWrapper;
import com.googlecode.objectify.impl.LoadContext;
import com.googlecode.objectify.impl.MethodWrapper;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.load.EmbeddedArraySetter;
import com.googlecode.objectify.impl.load.EmbeddedClassSetter;
import com.googlecode.objectify.impl.load.EmbeddedCollectionSetter;
import com.googlecode.objectify.impl.load.EmbeddedMultivalueSetter;
import com.googlecode.objectify.impl.load.EmbeddedNullIndexSetter;
import com.googlecode.objectify.impl.load.LeafSetter;
import com.googlecode.objectify.impl.load.RootSetter;
import com.googlecode.objectify.impl.load.Setter;
import com.googlecode.objectify.impl.save.ClassSaver;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transmog<T> {
    ObjectifyFactory factory;
    Class<T> clazz;
    Map<String, Setter> rootSetters = new HashMap<String, Setter>();
    ClassSaver rootSaver;

    public Transmog(ObjectifyFactory fact, Class<T> clazz) {
        this.factory = fact;
        this.clazz = clazz;
        new Visitor().visitClass(clazz);
        this.rootSaver = new ClassSaver(fact, clazz);
    }

    public void load(Entity fromEntity, T toPojo) {
        LoadContext context = new LoadContext(toPojo, fromEntity);
        for (Map.Entry property : fromEntity.getProperties().entrySet()) {
            Setter setter = this.rootSetters.get(property.getKey());
            if (setter == null) continue;
            setter.set(toPojo, property.getValue(), context);
        }
        context.done();
    }

    public void save(T fromPojo, Entity toEntity) {
        this.rootSaver.save(fromPojo, toEntity, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Visitor {
        Setter setterChain;
        String prefix;
        boolean embedded;
        Set<String> fieldPathsUsed;
        Set<String> methodPathsUsed;

        public Visitor() {
            this.setterChain = new RootSetter();
            this.fieldPathsUsed = new HashSet<String>();
            this.methodPathsUsed = new HashSet<String>();
        }

        public Visitor(Setter setterChain, String prefix, Set<String> fieldPathsUsed, Set<String> methodPathsUsed) {
            this.setterChain = setterChain;
            this.prefix = prefix;
            this.embedded = true;
            this.fieldPathsUsed = fieldPathsUsed;
            this.methodPathsUsed = methodPathsUsed;
        }

        public void visitClass(Class<?> clazz) {
            List<TypeUtils.FieldMetadata> fields = TypeUtils.getPesistentFields(clazz);
            for (TypeUtils.FieldMetadata meta : fields) {
                this.visitField(meta.field, meta.names);
            }
            List<TypeUtils.MethodMetadata> methods = TypeUtils.getAlsoLoadMethods(clazz);
            for (TypeUtils.MethodMetadata meta : methods) {
                this.visitMethod(meta.method, meta.names);
            }
        }

        void visitMethod(Method method, Collection<String> names) {
            List<String> paths = this.namesToPaths(names);
            for (String path : paths) {
                List<String> collisions = this.makeCollisions(paths, path);
                LeafSetter setter = new LeafSetter(Transmog.this.factory, new MethodWrapper(method), collisions);
                this.addRootSetter(path, setter, true);
            }
        }

        void visitField(Field field, Collection<String> names) {
            List<String> paths = this.namesToPaths(names);
            if (TypeUtils.isEmbedded(field)) {
                if (field.getType().isArray()) {
                    Class<?> visitType = field.getType().getComponentType();
                    for (String path : paths) {
                        List<String> collisions = this.makeCollisions(paths, path);
                        EmbeddedArraySetter setter = new EmbeddedArraySetter(field, path, collisions);
                        this.addNullIndexSetter(setter, path, collisions);
                        Visitor visitor = new Visitor(this.setterChain.extend(setter), path, this.fieldPathsUsed, this.methodPathsUsed);
                        visitor.visitClass(visitType);
                    }
                } else if (Collection.class.isAssignableFrom(field.getType())) {
                    Class<?> visitType = TypeUtils.getComponentType(field.getType(), field.getGenericType());
                    for (String path : paths) {
                        List<String> collisions = this.makeCollisions(paths, path);
                        EmbeddedCollectionSetter setter = new EmbeddedCollectionSetter(field, path, collisions);
                        this.addNullIndexSetter(setter, path, collisions);
                        Visitor visitor = new Visitor(this.setterChain.extend(setter), path, this.fieldPathsUsed, this.methodPathsUsed);
                        visitor.visitClass(visitType);
                    }
                } else {
                    Class<?> visitType = field.getType();
                    for (String path : paths) {
                        List<String> collisions = this.makeCollisions(paths, path);
                        EmbeddedClassSetter setter = new EmbeddedClassSetter(field, collisions);
                        Visitor visitor = new Visitor(this.setterChain.extend(setter), path, this.fieldPathsUsed, this.methodPathsUsed);
                        visitor.visitClass(visitType);
                    }
                }
            } else {
                for (String path : paths) {
                    List<String> collisions = this.makeCollisions(paths, path);
                    LeafSetter setter = new LeafSetter(Transmog.this.factory, new FieldWrapper(field), collisions);
                    this.addRootSetter(path, setter, false);
                }
            }
        }

        private List<String> namesToPaths(Collection<String> names) {
            ArrayList<String> paths = new ArrayList<String>();
            for (String name : names) {
                paths.add(TypeUtils.extendPropertyPath(this.prefix, name));
            }
            return paths;
        }

        private List<String> makeCollisions(Collection<String> paths, String forPath) {
            if (paths.size() > 1) {
                ArrayList<String> collisions = new ArrayList<String>(paths.size() - 1);
                for (String path : paths) {
                    if (path.equals(forPath)) continue;
                    collisions.add(path);
                }
                return collisions;
            }
            return null;
        }

        void addNullIndexSetter(EmbeddedMultivalueSetter setter, String path, Collection<String> collisionPaths) {
            EmbeddedNullIndexSetter nes = new EmbeddedNullIndexSetter(setter, path, collisionPaths);
            this.addRootSetter(TypeUtils.getNullIndexPath(path), nes, false);
        }

        void addRootSetter(String fullPath, Setter setter, boolean method) {
            if (method) {
                if (this.methodPathsUsed.contains(fullPath)) {
                    throw new IllegalStateException("Attempting to create multiple associations on " + Transmog.this.clazz + " for " + fullPath);
                }
                this.methodPathsUsed.add(fullPath);
            } else {
                if (this.fieldPathsUsed.contains(fullPath) || this.methodPathsUsed.contains(fullPath)) {
                    throw new IllegalStateException("Attempting to create multiple associations on " + Transmog.this.clazz + " for " + fullPath);
                }
                this.fieldPathsUsed.add(fullPath);
            }
            Setter chain = this.setterChain.extend(setter).getNext();
            Transmog.this.rootSetters.put(fullPath, chain);
        }
    }
}

