/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl;

import com.google.appengine.api.datastore.Entity;
import com.googlecode.objectify.annotation.AlsoLoad;
import com.googlecode.objectify.annotation.OldName;
import com.googlecode.objectify.annotation.Parent;
import com.googlecode.objectify.annotation.Serialized;
import com.googlecode.objectify.impl.Wrapper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    static final int NOT_SAVED_MODIFIERS = 24;
    static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER = new HashMap();

    public static <T> Constructor<T> getNoArgConstructor(Class<T> clazz) {
        try {
            Constructor<T> ctor = clazz.getDeclaredConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("There must be a no-arg constructor for " + clazz.getName(), e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... args) {
        try {
            Constructor<T> ctor = clazz.getDeclaredConstructor(args);
            ctor.setAccessible(true);
            return ctor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(clazz.getName() + " has no constructor with args " + Arrays.toString(args), e);
        }
    }

    public static boolean isSaveable(Field field) {
        return !field.isAnnotationPresent(Transient.class) && (field.getModifiers() & 0x18) == 0;
    }

    public static Class<?> getComponentType(Class<?> type, Type genericType) {
        if (type.isArray()) {
            return type.getComponentType();
        }
        if (Collection.class.isAssignableFrom(type)) {
            while (genericType instanceof Class) {
                genericType = ((Class)genericType).getGenericSuperclass();
            }
            if (genericType instanceof ParameterizedType) {
                Type actualTypeArgument = ((ParameterizedType)genericType).getActualTypeArguments()[0];
                if (actualTypeArgument instanceof Class) {
                    return (Class)actualTypeArgument;
                }
                if (actualTypeArgument instanceof ParameterizedType) {
                    return (Class)((ParameterizedType)actualTypeArgument).getRawType();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    public static String extendPropertyPath(String prefix, String name) {
        if (prefix == null || prefix.length() == 0) {
            return name;
        }
        return prefix + '.' + name;
    }

    public static Collection<Object> prepareCollection(Object onPojo, Wrapper collectionField, int size) {
        assert (Collection.class.isAssignableFrom(collectionField.getType()));
        AbstractCollection coll = (TreeSet<Object>)collectionField.get(onPojo);
        if (coll != null) {
            return coll;
        }
        if (!collectionField.getType().isInterface()) {
            coll = (Collection)TypeUtils.newInstance(collectionField.getType());
        } else if (SortedSet.class.isAssignableFrom(collectionField.getType())) {
            coll = new TreeSet<Object>();
        } else if (Set.class.isAssignableFrom(collectionField.getType())) {
            coll = new HashSet((int)((double)size * 1.5));
        } else if (List.class.isAssignableFrom(collectionField.getType()) || collectionField.getType().isAssignableFrom(ArrayList.class)) {
            coll = new ArrayList(size);
        }
        collectionField.set(onPojo, coll);
        return coll;
    }

    public static void setNullIndexes(Entity entity, String pathBase, Collection<Integer> value) {
        String path = TypeUtils.getNullIndexPath(pathBase);
        entity.setUnindexedProperty(path, value);
    }

    public static Set<Integer> getNullIndexes(Entity entity, String pathBase) {
        String path = TypeUtils.getNullIndexPath(pathBase);
        Collection indexes = (Collection)entity.getProperty(path);
        if (indexes == null) {
            return null;
        }
        HashSet<Integer> result = new HashSet<Integer>();
        for (Number index : indexes) {
            result.add(index.intValue());
        }
        return result;
    }

    public static String getNullIndexPath(String pathBase) {
        return pathBase + "^null";
    }

    public static boolean isArrayOrCollection(Class<?> clazz) {
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isEmbedded(Field field) {
        return field.isAnnotationPresent(Embedded.class);
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Constructor<T> ctor, Object ... params) {
        try {
            return ctor.newInstance(params);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object field_get(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void field_set(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<FieldMetadata> getPesistentFields(Class<?> clazz) {
        ArrayList<FieldMetadata> goodFields = new ArrayList<FieldMetadata>();
        TypeUtils.getPersistentFields(clazz, goodFields);
        return goodFields;
    }

    private static void getPersistentFields(Class<?> clazz, List<FieldMetadata> goodFields) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        TypeUtils.getPersistentFields(clazz.getSuperclass(), goodFields);
        for (Field field : clazz.getDeclaredFields()) {
            OldName oldName;
            if (!TypeUtils.isSaveable(field) || field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(Parent.class)) continue;
            if (field.isAnnotationPresent(Embedded.class) && field.isAnnotationPresent(Serialized.class)) {
                throw new IllegalStateException("Cannot have @Embedded and @Serialized on the same field! Check " + field);
            }
            FieldMetadata metadata = new FieldMetadata(field);
            metadata.names.add(field.getName());
            AlsoLoad alsoLoad = field.getAnnotation(AlsoLoad.class);
            if (alsoLoad != null) {
                if (alsoLoad.value() == null || alsoLoad.value().length == 0) {
                    throw new IllegalStateException("Illegal value '" + Arrays.toString(alsoLoad.value()) + "' in @AlsoLoad for " + field);
                }
                for (String value : alsoLoad.value()) {
                    if (value == null || value.trim().length() == 0) {
                        throw new IllegalStateException("Illegal value '" + value + "' in @AlsoLoad for " + field);
                    }
                    metadata.names.add(value);
                }
            }
            if ((oldName = field.getAnnotation(OldName.class)) != null) {
                if (oldName.value() == null || oldName.value().trim().length() == 0) {
                    throw new IllegalStateException("Illegal value '" + oldName.value() + "' in @OldName for " + field);
                }
                metadata.names.add(oldName.value());
            }
            field.setAccessible(true);
            goodFields.add(metadata);
        }
    }

    public static List<MethodMetadata> getAlsoLoadMethods(Class<?> clazz) {
        ArrayList<MethodMetadata> goodMethods = new ArrayList<MethodMetadata>();
        TypeUtils.getAlsoLoadMethods(clazz, goodMethods);
        return goodMethods;
    }

    private static void getAlsoLoadMethods(Class<?> clazz, List<MethodMetadata> goodMethods) {
        if (clazz == null || clazz == Object.class) {
            return;
        }
        TypeUtils.getAlsoLoadMethods(clazz.getSuperclass(), goodMethods);
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Embedded.class)) {
                throw new IllegalStateException("@Embedded is not a legal annotation for methods");
            }
            MethodMetadata metadata = new MethodMetadata(method);
            Annotation[][] arr$ = method.getParameterAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Annotation[] paramAnnotations;
                for (Annotation ann : paramAnnotations = arr$[i$]) {
                    if (!(ann instanceof OldName) && !(ann instanceof AlsoLoad)) continue;
                    if (method.getParameterTypes().length != 1) {
                        throw new IllegalStateException("@AlsoLoad methods must have a single parameter. Can't use " + method);
                    }
                    for (Annotation maybeEmbedded : paramAnnotations) {
                        if (!(maybeEmbedded instanceof Embedded)) continue;
                        throw new IllegalStateException("@Embedded cannot be used on @AlsoLoad methods. The offender is " + method);
                    }
                    method.setAccessible(true);
                    if (ann instanceof AlsoLoad) {
                        AlsoLoad alsoLoad = (AlsoLoad)ann;
                        if (alsoLoad.value() == null || alsoLoad.value().length == 0) {
                            throw new IllegalStateException("@AlsoLoad must have a value on " + method);
                        }
                        for (String name : alsoLoad.value()) {
                            if (name == null || name.trim().length() == 0) {
                                throw new IllegalStateException("Illegal value '" + name + "' in @AlsoLoad for " + method);
                            }
                            metadata.names.add(name);
                        }
                        continue;
                    }
                    if (!(ann instanceof OldName)) continue;
                    OldName oldName = (OldName)ann;
                    if (oldName.value() == null || oldName.value().trim().length() == 0) {
                        throw new IllegalStateException("@OldName must have a value on " + method);
                    }
                    metadata.names.add(oldName.value());
                }
            }
            goodMethods.add(metadata);
        }
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = TypeUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        while (!TypeUtils.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = TypeUtils.climbTypeHierarchy(type, baseClass);
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = TypeUtils.climbTypeHierarchy(rawType, baseClass);
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(TypeUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static Type climbTypeHierarchy(Class<?> here, Class<?> parentClass) {
        Type superType = here.getGenericSuperclass();
        Class<?> superClass = TypeUtils.getClass(superType);
        if (parentClass.isAssignableFrom(superClass)) {
            return superType;
        }
        Type[] interfaceTypes = here.getGenericInterfaces();
        for (int i = 0; i < interfaceTypes.length; ++i) {
            if (!parentClass.isAssignableFrom(TypeUtils.getClass(interfaceTypes[i]))) continue;
            return interfaceTypes[i];
        }
        return null;
    }

    public static boolean isAssignableFrom(Class<?> to, Class<?> from) {
        Class<?> notPrimitiveTo = to.isPrimitive() ? PRIMITIVE_TO_WRAPPER.get(to) : to;
        Class<?> notPrimitiveFrom = from.isPrimitive() ? PRIMITIVE_TO_WRAPPER.get(from) : from;
        return notPrimitiveTo.isAssignableFrom(notPrimitiveFrom);
    }

    static {
        PRIMITIVE_TO_WRAPPER.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPER.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPER.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPER.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPER.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPER.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPER.put(Double.TYPE, Double.class);
    }

    public static class MethodMetadata {
        public Set<String> names = new HashSet<String>();
        public Method method;

        public MethodMetadata(Method meth) {
            this.method = meth;
        }
    }

    public static class FieldMetadata {
        public Set<String> names = new HashSet<String>();
        public Field field;

        public FieldMetadata(Field f) {
            this.field = f;
        }
    }
}

