/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.load;

import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.load.EmbeddedMultivalueSetter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedArraySetter
extends EmbeddedMultivalueSetter {
    Class<?> componentType;
    Constructor<?> componentTypeCtor;

    public EmbeddedArraySetter(Field field, String path, Collection<String> collisionPaths) {
        super(field, path, collisionPaths);
        assert (field.getType().isArray());
        this.componentType = this.field.getType().getComponentType();
        this.componentTypeCtor = TypeUtils.getNoArgConstructor(this.componentType);
    }

    @Override
    protected Constructor<?> getComponentConstructor() {
        return this.componentTypeCtor;
    }

    @Override
    protected Collection<Object> getOrCreateCollection(Object onPojo, int size) {
        Object embeddedArray = this.field.get(onPojo);
        if (embeddedArray == null) {
            embeddedArray = Array.newInstance(this.componentType, size);
            this.field.set(onPojo, embeddedArray);
            return new EmptyArrayListWrapper((Object[])embeddedArray);
        }
        return Arrays.asList((Object[])embeddedArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EmptyArrayListWrapper
    extends AbstractList<Object> {
        int size;
        Object[] array;

        public EmptyArrayListWrapper(Object[] array) {
            this.array = array;
        }

        @Override
        public Object get(int index) {
            return this.array[index];
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public boolean add(Object element) {
            this.array[this.size++] = element;
            return true;
        }
    }
}

