/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.load;

import com.googlecode.objectify.impl.LoadContext;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.load.CollisionDetectingSetter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedClassSetter
extends CollisionDetectingSetter {
    Field field;
    Constructor<?> ctor;

    public EmbeddedClassSetter(Field field, Collection<String> collisionPaths) {
        super(collisionPaths);
        this.field = field;
        this.ctor = TypeUtils.getNoArgConstructor(field.getType());
    }

    @Override
    protected void safeSet(Object obj, Object value, LoadContext context) {
        Object embedded = TypeUtils.field_get(this.field, obj);
        if (embedded == null) {
            embedded = TypeUtils.newInstance(this.ctor, new Object[0]);
            TypeUtils.field_set(this.field, obj, embedded);
        }
        this.next.set(embedded, value, context);
    }
}

