/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.load;

import com.googlecode.objectify.impl.FieldWrapper;
import com.googlecode.objectify.impl.LoadContext;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.load.CollisionDetectingSetter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedMultivalueSetter
extends CollisionDetectingSetter {
    FieldWrapper field;
    String path;

    public EmbeddedMultivalueSetter(Field field, String path, Collection<String> collisionPaths) {
        super(collisionPaths);
        assert (TypeUtils.isEmbedded(field));
        assert (TypeUtils.isArrayOrCollection(field.getType()));
        this.field = new FieldWrapper(field);
        this.path = path;
    }

    protected abstract Constructor<?> getComponentConstructor();

    protected abstract Collection<Object> getOrCreateCollection(Object var1, int var2);

    @Override
    protected void safeSet(Object toPojo, Object value, LoadContext context) {
        Collection<Object> embeddedMultivalue;
        if (!(value instanceof Collection)) {
            throw new IllegalStateException("Tried to load a non-collection type into embedded collection " + this.field);
        }
        Collection datastoreCollection = (Collection)value;
        Set<Integer> nullIndexes = TypeUtils.getNullIndexes(context.getEntity(), this.path);
        int collectionSize = datastoreCollection.size();
        if (nullIndexes != null) {
            collectionSize += nullIndexes.size();
        }
        if ((embeddedMultivalue = this.getOrCreateCollection(toPojo, collectionSize)).isEmpty()) {
            for (int i = 0; i < collectionSize; ++i) {
                if (nullIndexes != null && nullIndexes.contains(i)) {
                    embeddedMultivalue.add(null);
                    continue;
                }
                Object embedded = TypeUtils.newInstance(this.getComponentConstructor(), new Object[0]);
                embeddedMultivalue.add(embedded);
            }
        }
        Iterator datastoreIterator = datastoreCollection.iterator();
        for (Object embedded : embeddedMultivalue) {
            if (embedded == null) continue;
            Object datastoreValue = datastoreIterator.next();
            this.next.set(embedded, datastoreValue, context);
        }
        context.addProcessedEmbeddedPath(this.path);
    }
}

