/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.load;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Text;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.impl.LoadContext;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.Wrapper;
import com.googlecode.objectify.impl.load.CollisionDetectingSetter;
import com.googlecode.objectify.impl.load.Setter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafSetter
extends CollisionDetectingSetter {
    ObjectifyFactory factory;
    Wrapper field;
    boolean serialized;

    public LeafSetter(ObjectifyFactory fact, Wrapper field, Collection<String> collisionPaths) {
        super(collisionPaths);
        this.factory = fact;
        this.field = field;
        this.serialized = field.isSerialized();
        this.next = !this.serialized && field.getType().isArray() ? new ForArray() : (!this.serialized && Collection.class.isAssignableFrom(field.getType()) ? new ForCollection() : new ForBasic());
    }

    @Override
    protected void safeSet(Object obj, Object value, LoadContext context) {
        this.next.set(obj, value, context);
    }

    Object importBasic(Object fromValue, Class<?> toType) {
        if (fromValue == null) {
            return null;
        }
        if (this.serialized) {
            if (!(fromValue instanceof Blob)) {
                throw new IllegalStateException("Tried to deserialize non-Blob " + fromValue + " for field " + this.field);
            }
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(((Blob)fromValue).getBytes());
                ObjectInputStream ois = new ObjectInputStream(bais);
                return ois.readObject();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            catch (ClassNotFoundException ex) {
                throw new IllegalStateException("Unable to deserialize " + fromValue + " on field " + this.field + ": " + ex);
            }
        }
        if (toType.isAssignableFrom(fromValue.getClass())) {
            return fromValue;
        }
        if (toType == String.class) {
            if (fromValue instanceof Text) {
                return ((Text)fromValue).getValue();
            }
            return fromValue.toString();
        }
        if (Enum.class.isAssignableFrom(toType)) {
            return Enum.valueOf(toType, fromValue.toString());
        }
        if (toType == Boolean.TYPE && fromValue instanceof Boolean) {
            return fromValue;
        }
        if (fromValue instanceof Number) {
            return this.coerceNumber((Number)fromValue, toType);
        }
        if (Key.class.isAssignableFrom(toType) && fromValue instanceof com.google.appengine.api.datastore.Key) {
            return this.factory.rawKeyToTypedKey((com.google.appengine.api.datastore.Key)fromValue);
        }
        throw new IllegalArgumentException("Don't know how to convert " + fromValue.getClass() + " to " + toType);
    }

    Object coerceNumber(Number value, Class<?> type) {
        if (type == Byte.class || type == Byte.TYPE) {
            return value.byteValue();
        }
        if (type == Short.class || type == Short.TYPE) {
            return value.shortValue();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return value.intValue();
        }
        if (type == Long.class || type == Long.TYPE) {
            return value.longValue();
        }
        if (type == Float.class || type == Float.TYPE) {
            return Float.valueOf(value.floatValue());
        }
        if (type == Double.class || type == Double.TYPE) {
            return value.doubleValue();
        }
        if (type == String.class) {
            return value.toString();
        }
        throw new IllegalArgumentException("Don't know how to convert " + value.getClass() + " to " + type);
    }

    @Override
    public final Setter extend(Setter tail) {
        throw new UnsupportedOperationException("Objectify bug - cannot extend Leaf setters");
    }

    class ForCollection
    extends Setter {
        Class<?> componentType;

        ForCollection() {
            this.componentType = TypeUtils.getComponentType(LeafSetter.this.field.getType(), LeafSetter.this.field.getGenericType());
        }

        public void set(Object toPojo, Object value, LoadContext context) {
            if (value == null) {
                LeafSetter.this.field.set(toPojo, null);
            } else {
                if (!(value instanceof Collection)) {
                    throw new IllegalStateException("Cannot load non-collection value '" + value + "' into " + LeafSetter.this.field);
                }
                Collection datastoreCollection = (Collection)value;
                Collection<Object> target = TypeUtils.prepareCollection(toPojo, LeafSetter.this.field, datastoreCollection.size());
                for (Object datastoreValue : datastoreCollection) {
                    target.add(LeafSetter.this.importBasic(datastoreValue, this.componentType));
                }
            }
        }
    }

    class ForArray
    extends Setter {
        Class<?> componentType;

        ForArray() {
            this.componentType = LeafSetter.this.field.getType().getComponentType();
        }

        public void set(Object toPojo, Object value, LoadContext context) {
            if (value == null) {
                LeafSetter.this.field.set(toPojo, null);
            } else {
                if (!(value instanceof Collection)) {
                    throw new IllegalStateException("Cannot load non-collection value '" + value + "' into " + LeafSetter.this.field);
                }
                Collection datastoreCollection = (Collection)value;
                Object array = Array.newInstance(this.componentType, datastoreCollection.size());
                int index = 0;
                for (Object componentValue : datastoreCollection) {
                    componentValue = LeafSetter.this.importBasic(componentValue, this.componentType);
                    Array.set(array, index++, componentValue);
                }
                LeafSetter.this.field.set(toPojo, array);
            }
        }
    }

    class ForBasic
    extends Setter {
        ForBasic() {
        }

        public void set(Object toPojo, Object value, LoadContext context) {
            LeafSetter.this.field.set(toPojo, LeafSetter.this.importBasic(value, LeafSetter.this.field.getType()));
        }
    }
}

