/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.save;

import com.google.appengine.api.datastore.Entity;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.annotation.Indexed;
import com.googlecode.objectify.annotation.Unindexed;
import com.googlecode.objectify.condition.Always;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.save.EmbeddedArrayFieldSaver;
import com.googlecode.objectify.impl.save.EmbeddedClassFieldSaver;
import com.googlecode.objectify.impl.save.EmbeddedCollectionFieldSaver;
import com.googlecode.objectify.impl.save.FieldSaver;
import com.googlecode.objectify.impl.save.LeafFieldSaver;
import com.googlecode.objectify.impl.save.Saver;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSaver
implements Saver {
    List<Saver> fieldSavers = new ArrayList<Saver>();
    Boolean indexed;

    public ClassSaver(ObjectifyFactory factory, Class<?> rootClazz) {
        this(factory, null, rootClazz, false, false);
    }

    public ClassSaver(ObjectifyFactory factory, String pathPrefix, Class<?> clazz, boolean ignoreIndexingAnnotations, boolean collectionize) {
        Indexed indexedAnn = clazz.getAnnotation(Indexed.class);
        Unindexed unindexedAnn = clazz.getAnnotation(Unindexed.class);
        if (indexedAnn != null && unindexedAnn != null) {
            throw new IllegalStateException("Cannot have @Indexed and @Unindexed on the same class: " + clazz.getName());
        }
        if (indexedAnn != null && (indexedAnn.value().length != 1 || indexedAnn.value()[0] != Always.class) || unindexedAnn != null && (unindexedAnn.value().length != 1 || unindexedAnn.value()[0] != Always.class)) {
            throw new IllegalStateException("Class-level @Indexed and @Unindexed annotations cannot have If conditions: " + clazz.getName());
        }
        if (!ignoreIndexingAnnotations) {
            if (indexedAnn != null) {
                this.indexed = true;
            } else if (unindexedAnn != null) {
                this.indexed = false;
            }
        }
        List<TypeUtils.FieldMetadata> fields = TypeUtils.getPesistentFields(clazz);
        for (TypeUtils.FieldMetadata metadata : fields) {
            FieldSaver saver;
            Field field = metadata.field;
            if (TypeUtils.isEmbedded(field)) {
                if (field.getType().isArray()) {
                    saver = new EmbeddedArrayFieldSaver(factory, pathPrefix, clazz, field, collectionize);
                    this.fieldSavers.add(saver);
                    continue;
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    saver = new EmbeddedCollectionFieldSaver(factory, pathPrefix, clazz, field, collectionize);
                    this.fieldSavers.add(saver);
                    continue;
                }
                saver = new EmbeddedClassFieldSaver(factory, pathPrefix, clazz, field, collectionize);
                this.fieldSavers.add(saver);
                continue;
            }
            saver = new LeafFieldSaver(factory, pathPrefix, clazz, field, collectionize);
            this.fieldSavers.add(saver);
        }
    }

    @Override
    public void save(Object pojo, Entity entity, boolean index) {
        if (this.indexed != null) {
            index = this.indexed;
        }
        for (Saver fieldSaver : this.fieldSavers) {
            fieldSaver.save(pojo, entity, index);
        }
    }
}

