/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.save;

import com.google.appengine.api.datastore.Entity;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.annotation.Indexed;
import com.googlecode.objectify.annotation.Unindexed;
import com.googlecode.objectify.impl.save.ClassSaver;
import com.googlecode.objectify.impl.save.FieldSaver;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmbeddedClassFieldSaver
extends FieldSaver {
    ClassSaver classSaver;

    public EmbeddedClassFieldSaver(ObjectifyFactory fact, String pathPrefix, Class<?> examinedClass, Field field, boolean collectionize) {
        super(pathPrefix, examinedClass, field, collectionize);
        boolean ignoreClassIndexingAnnotations = this.field.isAnnotationPresent(Indexed.class) || this.field.isAnnotationPresent(Unindexed.class);
        this.classSaver = new ClassSaver(fact, this.path, field.getType(), ignoreClassIndexingAnnotations, collectionize);
    }

    @Override
    public void saveValue(Object value, Entity entity, boolean index) {
        if (value == null) {
            this.setEntityProperty(entity, null, index);
        } else {
            this.classSaver.save(value, entity, index);
        }
    }
}

