/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.save;

import com.google.appengine.api.datastore.Entity;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.annotation.Indexed;
import com.googlecode.objectify.annotation.Unindexed;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.save.ClassSaver;
import com.googlecode.objectify.impl.save.FieldSaver;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmbeddedMultivalueFieldSaver
extends FieldSaver {
    ClassSaver classSaver;

    public EmbeddedMultivalueFieldSaver(ObjectifyFactory fact, String pathPrefix, Class<?> examinedClass, Field field, boolean collectionize) {
        super(pathPrefix, examinedClass, field, collectionize);
        if (collectionize) {
            throw new IllegalStateException("You cannot nest multiple @Embedded arrays or collections. A second was found at " + field);
        }
        boolean ignoreClassIndexingAnnotations = this.field.isAnnotationPresent(Indexed.class) || this.field.isAnnotationPresent(Unindexed.class);
        this.classSaver = new ClassSaver(fact, this.path, this.getComponentType(), ignoreClassIndexingAnnotations, true);
    }

    protected abstract Class<?> getComponentType();

    protected abstract Collection<Object> asCollection(Object var1);

    @Override
    public final void saveValue(Object value, Entity entity, boolean index) {
        Collection<Object> pojos;
        Object arrayOrCollection = value;
        if (arrayOrCollection != null && !(pojos = this.asCollection(arrayOrCollection)).isEmpty()) {
            ArrayList<Integer> nullIndexes = new ArrayList<Integer>();
            int which = 0;
            for (Object embeddedPojo : pojos) {
                if (embeddedPojo == null) {
                    nullIndexes.add(which);
                } else {
                    this.classSaver.save(embeddedPojo, entity, index);
                }
                ++which;
            }
            if (!nullIndexes.isEmpty()) {
                TypeUtils.setNullIndexes(entity, this.path, nullIndexes);
            }
        }
    }
}

