/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.save;

import com.google.appengine.api.datastore.Entity;
import com.googlecode.objectify.annotation.Indexed;
import com.googlecode.objectify.annotation.NotSaved;
import com.googlecode.objectify.annotation.Unindexed;
import com.googlecode.objectify.condition.Always;
import com.googlecode.objectify.condition.If;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.save.Saver;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldSaver
implements Saver {
    String path;
    Field field;
    If<?, ?>[] indexConditions;
    If<?, ?>[] unindexConditions;
    If<?, ?>[] notSavedConditions;

    public FieldSaver(String pathPrefix, Class<?> examinedClass, Field field, boolean collectionize) {
        NotSaved notSaved;
        this.field = field;
        this.path = TypeUtils.extendPropertyPath(pathPrefix, field.getName());
        Indexed indexedAnn = field.getAnnotation(Indexed.class);
        Unindexed unindexedAnn = field.getAnnotation(Unindexed.class);
        if (indexedAnn != null && unindexedAnn != null) {
            throw new IllegalStateException("Cannot have @Indexed and @Unindexed on the same field: " + field);
        }
        if (indexedAnn != null) {
            this.indexConditions = this.generateIfConditions(indexedAnn.value(), examinedClass);
        }
        if (unindexedAnn != null) {
            this.unindexConditions = this.generateIfConditions(unindexedAnn.value(), examinedClass);
        }
        if ((notSaved = field.getAnnotation(NotSaved.class)) != null) {
            if (collectionize && (notSaved.value().length != 1 || notSaved.value()[0] != Always.class)) {
                throw new IllegalStateException("You cannot use @NotSaved with a condition within @Embedded collections; check the field " + this.field);
            }
            this.notSavedConditions = this.generateIfConditions(notSaved.value(), examinedClass);
        }
    }

    private If<?, ?>[] generateIfConditions(Class<? extends If<?, ?>>[] ifClasses, Class<?> examinedClass) {
        If[] result = new If[ifClasses.length];
        for (int i = 0; i < ifClasses.length; ++i) {
            Class<If<?, ?>> ifClass = ifClasses[i];
            result[i] = this.createIf(ifClass, examinedClass);
            List<Class<?>> typeArguments = TypeUtils.getTypeArguments(If.class, ifClass);
            if (!TypeUtils.isAssignableFrom(typeArguments.get(0), this.field.getType())) {
                throw new IllegalStateException("Cannot use If class " + ifClass.getName() + " on " + this.field + " because you cannot assign " + this.field.getType().getName() + " to " + typeArguments.get(0).getName());
            }
            if (TypeUtils.isAssignableFrom(typeArguments.get(1), examinedClass)) continue;
            throw new IllegalStateException("Cannot use If class " + ifClass.getName() + " on " + this.field + " because the containing class " + examinedClass.getName() + " is not compatible with " + typeArguments.get(1).getName());
        }
        return result;
    }

    private If<?, ?> createIf(Class<? extends If<?, ?>> ifClass, Class<?> examinedClass) {
        try {
            Constructor<? extends If<?, ?>> ctor = TypeUtils.getConstructor(ifClass, Class.class, Field.class);
            return TypeUtils.newInstance(ctor, examinedClass, this.field);
        }
        catch (IllegalStateException ex) {
            try {
                Constructor<? extends If<?, ?>> ctor = TypeUtils.getNoArgConstructor(ifClass);
                return TypeUtils.newInstance(ctor, new Object[0]);
            }
            catch (IllegalStateException ex2) {
                throw new IllegalStateException("The If<?> class " + ifClass.getName() + " must have a no-arg constructor or a constructor that takes one argument of type Field.");
            }
        }
    }

    @Override
    public final void save(Object pojo, Entity entity, boolean index) {
        int i;
        Object value = TypeUtils.field_get(this.field, pojo);
        if (this.notSavedConditions != null) {
            for (i = 0; i < this.notSavedConditions.length; ++i) {
                if (!this.notSavedConditions[i].matches(value, pojo)) continue;
                return;
            }
        }
        if (this.indexConditions != null && !index) {
            for (i = 0; i < this.indexConditions.length; ++i) {
                if (!this.indexConditions[i].matches(value, pojo)) continue;
                index = true;
            }
        }
        if (this.unindexConditions != null && index) {
            for (i = 0; i < this.unindexConditions.length; ++i) {
                if (!this.unindexConditions[i].matches(value, pojo)) continue;
                index = false;
            }
        }
        this.saveValue(value, entity, index);
    }

    protected abstract void saveValue(Object var1, Entity var2, boolean var3);

    protected void setEntityProperty(Entity entity, Object value, boolean index) {
        if (index) {
            entity.setProperty(this.path, value);
        } else {
            entity.setUnindexedProperty(this.path, value);
        }
    }
}

