/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.objectify.impl.save;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Text;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.annotation.Serialized;
import com.googlecode.objectify.impl.TypeUtils;
import com.googlecode.objectify.impl.save.FieldSaver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafFieldSaver
extends FieldSaver {
    ObjectifyFactory factory;
    boolean collectionize;
    boolean serialize;
    boolean ignoreIfNull;

    public LeafFieldSaver(ObjectifyFactory fact, String pathPrefix, Class<?> examinedClass, Field field, boolean collectionize) {
        super(pathPrefix, examinedClass, field, collectionize);
        this.factory = fact;
        this.collectionize = collectionize;
        this.serialize = field.isAnnotationPresent(Serialized.class);
        if (this.collectionize && !this.serialize && TypeUtils.isArrayOrCollection(field.getType())) {
            throw new IllegalStateException("Cannot place array or collection properties inside @Embedded arrays or collections. The offending field is " + field);
        }
        if (!this.serialize && TypeUtils.isArrayOrCollection(field.getType())) {
            this.ignoreIfNull = true;
        }
    }

    @Override
    public void saveValue(Object value, Entity entity, boolean index) {
        if ((value = this.prepareForSave(value)) == null && this.ignoreIfNull) {
            return;
        }
        if (this.collectionize) {
            ArrayList<Object> savedCollection = (ArrayList<Object>)entity.getProperty(this.path);
            if (savedCollection == null) {
                savedCollection = new ArrayList<Object>();
                this.setEntityProperty(entity, savedCollection, index);
            }
            savedCollection.add(value);
        } else if (!(value instanceof Collection) || !((Collection)value).isEmpty()) {
            this.setEntityProperty(entity, value, index);
        }
    }

    protected Object prepareForSave(Object value) {
        if (value == null) {
            return null;
        }
        if (this.serialize) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(value);
                return new Blob(baos.toByteArray());
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (value instanceof String) {
            if (((String)value).length() > 500) {
                if (this.collectionize) {
                    throw new IllegalStateException("Objectify cannot autoconvert Strings greater than 500 characters to Text within @Embedded collections.  You must use Text for the field type instead.  This is what you tried to save into " + this.field + ": " + value);
                }
                return new Text((String)value);
            }
        } else {
            if (value instanceof Enum) {
                return value.toString();
            }
            if (value.getClass().isArray()) {
                if (value.getClass().getComponentType() == Byte.TYPE) {
                    return new Blob((byte[])value);
                }
                int length = Array.getLength(value);
                ArrayList<Object> list = new ArrayList<Object>(length);
                for (int i = 0; i < length; ++i) {
                    list.add(this.prepareForSave(Array.get(value, i)));
                }
                return list;
            }
            if (value instanceof Collection) {
                ArrayList<Object> list = new ArrayList<Object>(((Collection)value).size());
                for (Object obj : (Collection)value) {
                    list.add(this.prepareForSave(obj));
                }
                return list;
            }
            if (value instanceof Key) {
                return this.factory.typedKeyToRawKey((Key)value);
            }
        }
        return value;
    }
}

