/*
 * $Id$
 */

package com.googlecode.objectify.helper;

import java.util.Map;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Transaction;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.ObjectifyFactory;
import com.googlecode.objectify.Query;


/**
 * <p>Simple wrapper/decorator for an Objectify interface.</p>
 * 
 * @author Jeff Schnitzer
 */
public class ObjectifyWrapper implements Objectify
{
	/** */
	private Objectify base;
	
	/** Wraps the  */
	public ObjectifyWrapper(Objectify ofy)
	{
		this.base = ofy;
	}

	public <T> Map<Key<T>, T> get(Iterable<? extends Key<? extends T>> keys)
	{
		return this.base.get(keys);
	}
	
	public <T> T get(Key<? extends T> key) throws EntityNotFoundException
	{
		return this.base.get(key);
	}
	
	public <T> T get(Class<? extends T> clazz, long id) throws EntityNotFoundException
	{
		return this.base.get(clazz, id);
	}
	
	public <T> T get(Class<? extends T> clazz, String name) throws EntityNotFoundException
	{
		return this.base.get(clazz, name);
	}
	
	public <S, T> Map<S, T> get(Class<? extends T> clazz, Iterable<S> idsOrNames)
	{
		return this.base.get(clazz, idsOrNames);
	}
	
	public <T> T find(Key<? extends T> key)
	{
		return this.base.find(key);
	}
	
	public <T> T find(Class<? extends T> clazz, long id)
	{
		return this.base.find(clazz, id);
	}
	
	public <T> T find(Class<? extends T> clazz, String name)
	{
		return this.base.find(clazz, name);
	}

	public <T> Key<T> put(T obj)
	{
		return this.base.put(obj);
	}
	
	public <T> Map<Key<T>, T> put(Iterable<? extends T> objs)
	{
		return this.base.put(objs);
	}
	
	public void delete(Object keyOrEntity)
	{
		this.base.delete(keyOrEntity);
	}

	public void delete(Iterable<?> keysOrEntities)
	{
		this.base.delete(keysOrEntities);
	}

	public <T> void delete(Class<T> clazz, long id)
	{
		this.base.delete(clazz, id);
	}
	
	public <T> void delete(Class<T> clazz, String name)
	{
		this.base.delete(clazz, name);
	}

	public <T> Query<T> query()
	{
		return this.base.query();
	}
	
	public <T> Query<T> query(Class<T> clazz)
	{
		return this.base.query(clazz);
	}
	
	public Transaction getTxn()
	{
		return this.base.getTxn();
	}

	public DatastoreService getDatastore()
	{
		return this.base.getDatastore();
	}

	public ObjectifyFactory getFactory()
	{
		return this.base.getFactory();
	}
}