package com.googlecode.objectify.helper;

import java.util.Map;
import java.util.Set;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.QueryResultIterable;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Query;

/**
 * Simple wrapper/decorator for a Query.
 *
 * @author Jeff Schnitzer <jeff@infohazard.org>
 */
public class QueryWrapper<T> implements Query<T>
{
	/** */
	Query<T> base;
	
	/** */
	public QueryWrapper(Query<T> base) 
	{
		this.base = base;
	}
	
	
	public Query<T> filter(String condition, Object value)
	{
		return this.base.filter(condition, value);
	}
	
	
	public Query<T> order(String condition)
	{
		return this.base.order(condition);
	}
	
	
	public Query<T> ancestor(Object keyOrEntity)
	{
		return this.base.ancestor(keyOrEntity);
	}
	
	
	public Query<T> limit(int value)
	{
		return this.base.limit(value);
	}
	
	
	public Query<T> offset(int value)
	{
		return this.base.offset(value);
	}

	
	public Query<T> cursor(Cursor value)
	{
		return this.base.cursor(value);
	}

	
	public String toString()
	{
		return this.base.toString();
	}

	
	public QueryResultIterator<T> iterator()
	{
		return this.base.iterator();
	}

	
	public T get()
	{
		return this.base.get();
	}

	
	public Key<T> getKey()
	{
		return this.base.getKey();
	}

	
	public int countAll()
	{
		return this.base.countAll();
	}

	
	public QueryResultIterable<T> fetch()
	{
		return this.base.fetch();
	}

	
	public QueryResultIterable<Key<T>> fetchKeys()
	{
		return this.base.fetchKeys();
	}

	
	public <V> Set<Key<V>> fetchParentKeys()
	{
		return this.base.fetchParentKeys();
	}

	
	public <V> Map<Key<V>, V> fetchParents()
	{
		return this.base.fetchParents();
	}
}
