/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.handler.OServerHandler;
import java.util.List;

public class OServerHandlerHelper {
    public static void invokeHandlerCallbackOnClientConnection(OClientConnection connection) {
        List<OServerHandler> handlers = OServerMain.server().getHandlers();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onClientConnection(connection);
            }
        }
    }

    public static void invokeHandlerCallbackOnClientDisconnection(OClientConnection connection) {
        List<OServerHandler> handlers = OServerMain.server().getHandlers();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onClientDisconnection(connection);
            }
        }
    }

    public static void invokeHandlerCallbackOnBeforeClientRequest(OClientConnection connection, byte iRequestType) {
        List<OServerHandler> handlers = OServerMain.server().getHandlers();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onBeforeClientRequest(connection, iRequestType);
            }
        }
    }

    public static void invokeHandlerCallbackOnAfterClientRequest(OClientConnection connection, byte iRequestType) {
        List<OServerHandler> handlers = OServerMain.server().getHandlers();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onAfterClientRequest(connection, iRequestType);
            }
        }
    }

    public static void invokeHandlerCallbackOnClientError(OClientConnection connection, Throwable iThrowable) {
        List<OServerHandler> handlers = OServerMain.server().getHandlers();
        if (handlers != null) {
            for (OServerHandler handler : handlers) {
                handler.onClientError(connection, iThrowable);
            }
        }
    }
}

