/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;

public class ODistributedServerDiscoveryListener
extends OSoftThread {
    private final byte[] recvBuffer = new byte[50000];
    private DatagramPacket dgram;
    private ODistributedServerManager serverNode;
    private OServerNetworkListener binaryNetworkListener;
    private MulticastSocket socket;

    public ODistributedServerDiscoveryListener(ODistributedServerManager iManager, OServerNetworkListener iNetworkListener) {
        super(Orient.getThreadGroup(), "IO-Cluster-DiscoveryListener");
        this.serverNode = iManager;
        this.binaryNetworkListener = iNetworkListener;
        OLogManager.instance().info((Object)this, "Listening for distributed nodes on IP multicast " + iManager.networkMulticastAddress + ":" + iManager.networkMulticastPort, new Object[0]);
        this.dgram = new DatagramPacket(this.recvBuffer, this.recvBuffer.length);
        try {
            this.socket = new MulticastSocket(iManager.networkMulticastPort);
            this.socket.joinGroup(iManager.networkMulticastAddress);
        }
        catch (IOException e) {
            throw new OIOException("Can't startup the Discovery Listener service to catch distributed server nodes, probably the IP MULTICAST is disabled in current network configuration: " + e.getMessage());
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        try {
            this.dgram.setLength(this.recvBuffer.length);
            this.socket.receive(this.dgram);
            OLogManager.instance().debug((Object)this, "Received multicast packet %d bytes from %s:%d", new Object[]{this.dgram.getLength(), this.dgram.getAddress(), this.dgram.getPort()});
            byte[] buffer = new byte[this.dgram.getLength()];
            System.arraycopy(this.dgram.getData(), 0, buffer, 0, buffer.length);
            try {
                String packet = new String(OSecurityManager.instance().decrypt(this.serverNode.securityAlgorithm, this.serverNode.securityKey, buffer));
                String[] parts = packet.trim().split("\\|");
                int i = 0;
                if (!parts[i].startsWith("OrientDB v.")) {
                    return;
                }
                if (Integer.parseInt(parts[++i]) != 0) {
                    OLogManager.instance().debug((Object)this, "Received bad multicast packet with version %s not equals to the current %d", new Object[]{parts[i], 0});
                    return;
                }
                if (!parts[++i].equals(this.serverNode.name)) {
                    OLogManager.instance().debug((Object)this, "Received bad multicast packet with cluster name %s not equals to the current %s", new Object[]{parts[i], this.serverNode.name});
                    return;
                }
                String configuredServerAddress = parts[++i];
                String sourceServerAddress = this.dgram.getAddress().getHostAddress();
                int serverPort = Integer.parseInt(parts[++i]);
                if (configuredServerAddress.equals(this.binaryNetworkListener.getInboundAddr().getHostName()) && serverPort == this.binaryNetworkListener.getInboundAddr().getPort()) {
                    return;
                }
                this.serverNode.joinNode(new String[]{sourceServerAddress, configuredServerAddress}, serverPort);
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Received wrong packet from multicast IP", (Throwable)e, new Object[0]);
            }
        }
        catch (Throwable t) {
            OLogManager.instance().error((Object)this, "Error on executing request", t, new Object[0]);
        }
    }
}

