/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.thread.OPollerThread;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.TimerTask;

public class ODistributedServerDiscoverySignaler
extends OPollerThread {
    private byte[] discoveryPacket;
    private DatagramPacket dgram;
    private DatagramSocket socket;
    private ODistributedServerManager manager;
    private boolean forceLeadership;
    private TimerTask runningTask;

    public ODistributedServerDiscoverySignaler(ODistributedServerManager iManager, OServerNetworkListener iNetworkListener, boolean iForceLeadership) {
        super((long)(iManager.networkMulticastHeartbeat * 1000), Orient.getThreadGroup(), "IO-Cluster-DiscoverySignaler");
        this.manager = iManager;
        this.forceLeadership = iForceLeadership;
        String buffer = "OrientDB v.1.0rc5|0|" + this.manager.name + "|" + iNetworkListener.getInboundAddr().getHostName() + "|" + iNetworkListener.getInboundAddr().getPort();
        this.discoveryPacket = OSecurityManager.instance().encrypt(this.manager.securityAlgorithm, this.manager.securityKey, buffer.getBytes());
        if (this.forceLeadership) {
            this.startTimeoutPresenceTask();
        }
        this.start();
    }

    private void startTimeoutPresenceTask() {
        this.runningTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    if (ODistributedServerDiscoverySignaler.this.running && !ODistributedServerDiscoverySignaler.this.manager.isLeaderConnected()) {
                        ODistributedServerDiscoverySignaler.this.manager.becameLeader(ODistributedServerDiscoverySignaler.this.forceLeadership);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Orient.getTimer().schedule(this.runningTask, this.manager.networkTimeoutLeader);
    }

    public void startup() {
        try {
            this.dgram = new DatagramPacket(this.discoveryPacket, this.discoveryPacket.length, this.manager.networkMulticastAddress, this.manager.networkMulticastPort);
            this.socket = new DatagramSocket();
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Can't startup distributed server discovery signaler", (Throwable)e, new Object[0]);
        }
        super.startup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        OLogManager.instance().debug((Object)this, "Sending node presence signal over the network against IP Multicast %s:%d...", new Object[]{this.dgram.getAddress(), this.dgram.getPort()});
        try {
            this.socket.send(this.dgram);
        }
        catch (Throwable t) {
            this.shutdown();
            OLogManager.instance().error((Object)this, "Error on sending signal for distributed server presence, probably the IP MULTICAST is disabled in current network configuration: %s", new Object[]{t.getMessage()});
        }
    }

    public void shutdown() {
        if (this.runningTask != null) {
            this.runningTask.cancel();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.socket = null;
        this.dgram = null;
        super.shutdown();
    }
}

