/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.common.concur.resource.OSharedResourceExternal;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.handler.OServerHandlerAbstract;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerDiscoveryListener;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerDiscoverySignaler;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerLeaderChecker;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerNodeChecker;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerNodeRemote;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerRecordHook;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.distributed.ODistributedRequesterThreadLocal;
import com.orientechnologies.orient.server.network.protocol.distributed.ONetworkProtocolDistributed;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import javax.crypto.SecretKey;

public class ODistributedServerManager
extends OServerHandlerAbstract {
    protected OServer server;
    protected String name;
    protected String id;
    protected SecretKey securityKey;
    protected String securityAlgorithm;
    protected InetAddress networkMulticastAddress;
    protected int networkMulticastPort;
    protected int networkMulticastHeartbeat;
    protected int networkTimeoutLeader;
    protected int networkTimeoutNode;
    private int networkHeartbeatDelay;
    protected int serverUpdateDelay;
    protected int serverOutSynchMaxBuffers;
    protected boolean serverElectedForLeadership;
    private volatile ODistributedServerDiscoverySignaler discoverySignaler;
    private volatile ODistributedServerDiscoveryListener discoveryListener;
    private volatile ODistributedServerLeaderChecker leaderCheckerTask;
    private ODistributedServerRecordHook trigger;
    private final OSharedResourceExternal lock = new OSharedResourceExternal();
    private final HashMap<String, ODistributedServerNodeRemote> nodes = new LinkedHashMap<String, ODistributedServerNodeRemote>();
    static final String CHECKSUM = "ChEcKsUm1976";
    static final String PACKET_HEADER = "OrientDB v.";
    static final int PROTOCOL_VERSION = 0;
    private OServerNetworkListener distributedNetworkListener;
    private ONetworkProtocolDistributed leaderConnection;
    private final long startupDate = System.currentTimeMillis();
    public long lastHeartBeat;
    private Map<String, ODocument> clusterDbConfigurations = new HashMap<String, ODocument>();
    private volatile STATUS status = STATUS.ONLINE;
    private boolean leader = false;

    @Override
    public void startup() {
        this.trigger = new ODistributedServerRecordHook(this);
        this.discoverySignaler = new ODistributedServerDiscoverySignaler(this, this.distributedNetworkListener, this.serverElectedForLeadership);
    }

    @Override
    public void shutdown() {
        if (this.discoverySignaler != null) {
            this.discoverySignaler.sendShutdown();
        }
        if (this.discoveryListener != null) {
            this.discoveryListener.sendShutdown();
        }
    }

    public void receivedLeaderConnection(ONetworkProtocolDistributed iNetworkProtocolDistributed) {
        OLogManager.instance().info((Object)this, "Joined the cluster '" + this.name + "'", new Object[0]);
        this.leader = false;
        if (this.discoveryListener != null) {
            this.discoveryListener.sendShutdown();
            this.discoveryListener = null;
            OLogManager.instance().info((Object)this, "Turned off listener of remote nodes", new Object[0]);
        }
        this.leaderConnection = iNetworkProtocolDistributed;
        this.leaderCheckerTask = new ODistributedServerLeaderChecker(this);
        Orient.getTimer().schedule((TimerTask)this.leaderCheckerTask, this.networkHeartbeatDelay, (long)(this.networkHeartbeatDelay / 2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void joinNode(String[] iServerAddresses, int iServerPort) {
        lastException = null;
        for (String serverAddress : iServerAddresses) {
            block11: {
                block10: {
                    key = ODistributedServerManager.getNodeName(serverAddress, iServerPort);
                    this.lock.acquireExclusiveLock();
                    if (!this.nodes.containsKey(key)) break block10;
                    node = this.nodes.get(key);
                    ** if (node.getStatus() == ODistributedServerNodeRemote.STATUS.UNREACHABLE || node.getStatus() == ODistributedServerNodeRemote.STATUS.DISCONNECTED || !node.checkConnection()) goto lbl11
lbl-1000:
                    // 1 sources

                    {
                        this.lock.releaseExclusiveLock();
                        return;
                    }
lbl11:
                    // 1 sources

                    ** GOTO lbl16
                }
                node = new ODistributedServerNodeRemote(this, serverAddress, iServerPort);
lbl16:
                // 3 sources

                if (node.connect(this.networkTimeoutNode, this.name, this.securityKey)) break block11;
                this.lock.releaseExclusiveLock();
                return;
            }
            try {
                this.nodes.put(key, node);
                node.startSynchronization();
                return;
            }
            catch (Throwable var11_11) {
                throw var11_11;
            }
            finally {
                this.lock.releaseExclusiveLock();
            }
            {
                catch (Exception e) {
                    lastException = e;
                }
            }
        }
        OLogManager.instance().error((Object)this, "Can't connect to distributed server node using addresses %s:%d and %s:%d", lastException, new Object[]{iServerAddresses[0], iServerPort, iServerAddresses[1], iServerPort});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleNodeFailure(ODistributedServerNodeRemote node) {
        node.disconnect();
        OLogManager.instance().warn((Object)this, "Remote server node %s:%d seems down, retrying to connect...", new Object[]{node.networkAddress, node.networkPort});
        try {
            if (node.connect(this.networkTimeoutNode, this.name, this.securityKey)) return;
        }
        catch (IOException e) {
            OLogManager.instance().debug((Object)this, "Remote server node %s:%d is down, set it as DISCONNECTED and start to buffer changes", new Object[]{node.networkAddress, node.networkPort});
            node.setAsTemporaryDisconnected(this.serverOutSynchMaxBuffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void becameLeader(boolean iForce) {
        this.lock.acquireExclusiveLock();
        try {
            if (this.leader) {
                return;
            }
            this.leader = true;
            for (Map.Entry<String, ODistributedServerNodeRemote> node : this.nodes.entrySet()) {
                node.getValue().disconnect();
            }
            this.nodes.clear();
            this.leaderConnection = null;
            OLogManager.instance().warn((Object)this, "Current node is the new cluster Leader of distributed nodes", new Object[0]);
            if (this.leaderCheckerTask != null) {
                this.leaderCheckerTask.cancel();
            }
            this.discoveryListener = new ODistributedServerDiscoveryListener(this, this.distributedNetworkListener);
            Orient.getTimer().schedule((TimerTask)new ODistributedServerNodeChecker(this), this.networkHeartbeatDelay, (long)this.networkHeartbeatDelay);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abandonLeadership() {
        this.lock.acquireExclusiveLock();
        try {
            if (!this.leader) {
                return;
            }
            this.leader = false;
            for (Map.Entry<String, ODistributedServerNodeRemote> node : this.nodes.entrySet()) {
                node.getValue().disconnect();
            }
            this.nodes.clear();
            if (this.discoveryListener != null) {
                this.discoveryListener.sendShutdown();
                this.discoveryListener = null;
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void onAfterClientRequest(OClientConnection iConnection, byte iRequestType) {
        if (iRequestType == 3) {
            try {
                ODocument clusterConfig = this.getClusterConfiguration(iConnection.database.getName());
                byte[] serializedDocument = clusterConfig != null ? clusterConfig.toStream() : null;
                ((OChannelBinary)iConnection.protocol.getChannel()).writeBytes(serializedDocument);
            }
            catch (IOException e) {
                throw new OIOException("Error on marshalling of cluster configuration", (Throwable)e);
            }
        }
    }

    @Override
    public void onClientError(OClientConnection iConnection, Throwable iThrowable) {
    }

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        this.server = iServer;
        try {
            this.name = "unknown";
            this.securityKey = null;
            this.networkMulticastAddress = InetAddress.getByName("235.1.1.1");
            this.networkMulticastPort = 2424;
            this.networkMulticastHeartbeat = 5000;
            this.networkTimeoutLeader = 3000;
            this.networkTimeoutNode = 5000;
            this.networkHeartbeatDelay = 5000;
            this.securityAlgorithm = "Blowfish";
            this.serverUpdateDelay = 0;
            this.serverOutSynchMaxBuffers = 300;
            this.serverElectedForLeadership = true;
            byte[] tempSecurityKey = null;
            if (iParams != null) {
                for (OServerParameterConfiguration param : iParams) {
                    if ("name".equalsIgnoreCase(param.name)) {
                        this.name = param.value;
                        continue;
                    }
                    if ("security.algorithm".equalsIgnoreCase(param.name)) {
                        this.securityAlgorithm = param.value;
                        continue;
                    }
                    if ("security.key".equalsIgnoreCase(param.name)) {
                        tempSecurityKey = OBase64Utils.decode(param.value);
                        continue;
                    }
                    if ("network.multicast.address".equalsIgnoreCase(param.name)) {
                        this.networkMulticastAddress = InetAddress.getByName(param.value);
                        continue;
                    }
                    if ("network.multicast.port".equalsIgnoreCase(param.name)) {
                        this.networkMulticastPort = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("network.multicast.heartbeat".equalsIgnoreCase(param.name)) {
                        this.networkMulticastHeartbeat = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("network.timeout.leader".equalsIgnoreCase(param.name)) {
                        this.networkTimeoutLeader = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("network.timeout.connection".equalsIgnoreCase(param.name)) {
                        this.networkTimeoutNode = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("network.heartbeat.delay".equalsIgnoreCase(param.name)) {
                        this.networkHeartbeatDelay = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("server.update.delay".equalsIgnoreCase(param.name)) {
                        this.serverUpdateDelay = Integer.parseInt(param.value);
                        continue;
                    }
                    if ("server.outsynch.maxbuffers".equalsIgnoreCase(param.name)) {
                        this.serverOutSynchMaxBuffers = Integer.parseInt(param.value);
                        continue;
                    }
                    if (!"server.electedForLeadership".equalsIgnoreCase(param.name)) continue;
                    this.serverElectedForLeadership = Boolean.parseBoolean(param.value);
                }
            }
            if (tempSecurityKey == null) {
                OLogManager.instance().info((Object)this, "Generating Server security key and save it in configuration...", new Object[0]);
                this.securityKey = OSecurityManager.instance().generateKey(this.securityAlgorithm, 96);
                for (OServerHandlerConfiguration handler : iServer.getConfiguration().handlers) {
                    if (!handler.clazz.equals(this.getClass().getName())) continue;
                    handler.parameters = new OServerParameterConfiguration[iParams.length + 1];
                    for (int i = 0; i < iParams.length; ++i) {
                        handler.parameters[i] = iParams[i];
                    }
                    handler.parameters[iParams.length] = new OServerParameterConfiguration("security.key", OBase64Utils.encodeBytes(this.securityKey.getEncoded()));
                }
                iServer.saveConfiguration();
            } else {
                this.securityKey = OSecurityManager.instance().createKey(this.securityAlgorithm, tempSecurityKey);
            }
            this.distributedNetworkListener = this.server.getListenerByProtocol(ONetworkProtocolDistributed.class);
            if (this.distributedNetworkListener == null) {
                OLogManager.instance().error((Object)this, "Can't find a configured network listener with 'distributed' protocol. Can't start distributed node", null, OConfigurationException.class, new Object[0]);
            }
            this.id = this.distributedNetworkListener.getInboundAddr().getHostName() + ":" + this.distributedNetworkListener.getInboundAddr().getPort();
        }
        catch (Exception e) {
            throw new OConfigurationException("Can't configure OrientDB Server as Cluster Node", e);
        }
    }

    public ODistributedServerNodeRemote getNode(String iNodeName) {
        this.lock.acquireSharedLock();
        try {
            ODistributedServerNodeRemote node = this.nodes.get(ODistributedServerManager.resolveNetworkHost(iNodeName));
            if (node != null) {
                ODistributedServerNodeRemote oDistributedServerNodeRemote = node;
                return oDistributedServerNodeRemote;
            }
            throw new IllegalArgumentException("Node '" + iNodeName + "' is not configured on server: " + this.getId());
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ODistributedServerNodeRemote> getNodeList() {
        this.lock.acquireSharedLock();
        try {
            if (this.nodes.isEmpty()) {
                List<ODistributedServerNodeRemote> list = null;
                return list;
            }
            ArrayList<ODistributedServerNodeRemote> arrayList = new ArrayList<ODistributedServerNodeRemote>(this.nodes.values());
            return arrayList;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(ODistributedServerNodeRemote iNode) {
        this.lock.acquireExclusiveLock();
        try {
            OLogManager.instance().warn((Object)this, "Removed server node %s:%d from distributed cluster", new Object[]{iNode.networkAddress, iNode.networkPort});
            this.nodes.remove(iNode.toString());
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public int getServerUpdateDelay() {
        return this.serverUpdateDelay;
    }

    public boolean isLeader() {
        return this.leader;
    }

    public String getName() {
        return this.name;
    }

    public boolean isCurrentNodeTheClusterOwner(String iDatabaseName, String iClusterName) {
        ODocument servers = this.getServersForCluster(iDatabaseName, iClusterName);
        if (servers == null) {
            return true;
        }
        if (((Boolean)ODistributedRequesterThreadLocal.INSTANCE.get()).booleanValue()) {
            return true;
        }
        return servers.field("owner").equals(this.getId());
    }

    public ODocument getServersForCluster(String iDatabaseName, String iClusterName) {
        ODocument database = this.clusterDbConfigurations.get(iDatabaseName);
        if (database == null) {
            return null;
        }
        ODocument clusters = (ODocument)database.field("clusters");
        return (ODocument)(clusters.containsField(iClusterName) ? clusters.field(iClusterName) : clusters.field("*"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distributeRequest(OTransactionRecordEntry iTransactionEntry) throws IOException {
        HashMap<ODistributedServerNodeRemote, ODistributedServerNodeRemote.SYNCH_TYPE> nodeList;
        this.lock.acquireSharedLock();
        try {
            if (this.nodes.isEmpty()) {
                return;
            }
            ODocument servers = this.getServersForCluster(iTransactionEntry.getRecord().getDatabase().getName(), iTransactionEntry.clusterName);
            if (servers == null) {
                return;
            }
            nodeList = new HashMap<ODistributedServerNodeRemote, ODistributedServerNodeRemote.SYNCH_TYPE>();
            if (servers.field("synch") != null) {
                for (String s : (Collection)servers.field("synch")) {
                    nodeList.put(this.nodes.get(s), ODistributedServerNodeRemote.SYNCH_TYPE.SYNCHRONOUS);
                }
            }
            if (servers.field("asynch") != null) {
                for (String s : (Collection)servers.field("asynch")) {
                    nodeList.put(this.nodes.get(s), ODistributedServerNodeRemote.SYNCH_TYPE.ASYNCHRONOUS);
                }
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        for (Map.Entry entry : nodeList.entrySet()) {
            ((ODistributedServerNodeRemote)entry.getKey()).sendRequest(iTransactionEntry, (ODistributedServerNodeRemote.SYNCH_TYPE)((Object)entry.getValue()));
        }
    }

    public int getNetworkHeartbeatDelay() {
        return this.networkHeartbeatDelay;
    }

    public long getLastHeartBeat() {
        return this.lastHeartBeat;
    }

    public void updateHeartBeatTime() {
        this.lastHeartBeat = System.currentTimeMillis();
    }

    public ODocument getClusterConfiguration(String iDatabaseName) {
        return this.clusterDbConfigurations.get(iDatabaseName);
    }

    public void setClusterConfiguration(String iDatabaseName, ODocument iConfiguration) {
        this.clusterDbConfigurations.put(iDatabaseName, iConfiguration);
    }

    public String getId() {
        return this.id;
    }

    private static String getNodeName(String iServerAddress, int iServerPort) {
        return iServerAddress + ":" + iServerPort;
    }

    public ODocument addServerInConfiguration(String iDatabaseName, String iAddress, boolean iSynchronous) throws UnknownHostException {
        StringBuilder cfg = new StringBuilder();
        iAddress = ODistributedServerManager.resolveNetworkHost(iAddress);
        cfg.append("{ \"*\" : { ");
        cfg.append("\"owner\" : \"");
        cfg.append(this.getId());
        cfg.append("\", ");
        cfg.append(iSynchronous ? "\"synch\"" : "\"asynch\"");
        cfg.append(" : [ \"");
        cfg.append(iAddress);
        cfg.append("\" ] } }");
        return this.addServerInConfiguration(iDatabaseName, iAddress, cfg.toString());
    }

    public ODocument addServerInConfiguration(String iDatabaseName, String iAddress, String iServerClusterConfiguration) throws UnknownHostException {
        ODocument allClusters;
        ODocument clusters;
        ODocument dbConfiguration = this.clusterDbConfigurations.get(iDatabaseName);
        if (dbConfiguration == null) {
            dbConfiguration = new ODocument();
            this.clusterDbConfigurations.put(iDatabaseName, dbConfiguration);
        }
        if ((clusters = (ODocument)dbConfiguration.field("clusters")) == null) {
            clusters = new ODocument().addOwner(dbConfiguration);
            dbConfiguration.field("clusters", clusters);
        }
        if ((allClusters = (ODocument)clusters.field("*")) == null) {
            allClusters = new ODocument().addOwner(clusters);
            clusters.field("*", allClusters);
        }
        ODocument cfgDoc = (ODocument)new ODocument().fromJSON(iServerClusterConfiguration);
        for (String fieldName : cfgDoc.fieldNames()) {
            Object fieldValue = cfgDoc.field(fieldName);
            ODocument clusterConfig = (ODocument)clusters.field(fieldName);
            if (clusterConfig == null) {
                clusterConfig = (ODocument)fieldValue;
                continue;
            }
            if (fieldValue instanceof ODocument) {
                clusterConfig.merge((ODocument)cfgDoc.field(fieldName), true, true);
                continue;
            }
            clusterConfig.merge((Map)cfgDoc.field(fieldName), true, true);
        }
        OLogManager.instance().warn((Object)this, "Updated server node configuration: %s", new Object[]{dbConfiguration.toJSON("")});
        this.broadcastClusterConfiguration(iDatabaseName);
        return dbConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcastClusterConfiguration(String iDatabaseName) {
        for (ODistributedServerNodeRemote node : this.getNodeList()) {
            if (node.getStatus() != ODistributedServerNodeRemote.STATUS.CONNECTED) continue;
            node.sendConfiguration(iDatabaseName);
        }
        for (OClientConnection c : OClientConnectionManager.instance().getConnections()) {
            if (!(c.protocol.getChannel() instanceof OChannelBinary)) continue;
            OChannelBinary ch = (OChannelBinary)c.protocol.getChannel();
            OLogManager.instance().info((Object)this, "Sending distributed configuration for database '%s' to the connected client %s...", new Object[]{iDatabaseName, ch.socket.getRemoteSocketAddress()});
            try {
                ch.acquireExclusiveLock();
                try {
                    ch.writeByte((byte)3);
                    ch.writeInt(Integer.MIN_VALUE);
                    ch.writeByte((byte)100);
                    ch.writeBytes(this.clusterDbConfigurations.get(iDatabaseName).toStream());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    ch.releaseExclusiveLock();
                }
            }
            catch (InterruptedException e1) {
                OLogManager.instance().warn((Object)this, "[broadcastClusterConfiguration] Timeout on sending configuration to remote node %s", new Object[]{ch.socket.getRemoteSocketAddress()});
            }
        }
    }

    public boolean isLeaderConnected() {
        return this.leaderConnection != null;
    }

    public String getSecurityAlgorithm() {
        return this.securityAlgorithm;
    }

    public byte[] getSecurityKey() {
        return this.securityKey.getEncoded();
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setStatus(STATUS iOnline) {
        this.status = iOnline;
    }

    public static String resolveNetworkHost(String iAddress) {
        String[] parts = iAddress.split(":");
        if (parts.length == 2) {
            try {
                InetAddress address = InetAddress.getByName(parts[0]);
                if (address != null) {
                    return address.getHostAddress() + ":" + parts[1];
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return iAddress;
    }

    public long getRunningSince() {
        return System.currentTimeMillis() - this.startupDate;
    }

    public static enum STATUS {
        ONLINE,
        SYNCHRONIZING;

    }
}

