/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryOutputStream;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.server.handler.distributed.ODistributedException;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.handler.distributed.ODistributedSynchronizationException;
import com.orientechnologies.orient.server.handler.distributed.OServerNodeDatabaseEntry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.SecretKey;

public class ODistributedServerNodeRemote
implements OCommandOutputListener {
    private String id;
    public String networkAddress;
    public int networkPort;
    public Date joinedOn;
    private ODistributedServerManager manager;
    private OChannelBinaryClient channel;
    private OContextConfiguration configuration;
    private volatile STATUS status = STATUS.DISCONNECTED;
    private List<OTransactionRecordEntry> bufferedChanges = new ArrayList<OTransactionRecordEntry>();
    private int clientTxId;
    private long lastHeartBeat = 0L;
    private static AtomicInteger serialClientId = new AtomicInteger(-1);
    private final ExecutorService asynchExecutor;
    private Map<String, OServerNodeDatabaseEntry> databases = new HashMap<String, OServerNodeDatabaseEntry>();

    public ODistributedServerNodeRemote(ODistributedServerManager iNode, String iServerAddress, int iServerPort) {
        this.manager = iNode;
        this.networkAddress = iServerAddress;
        this.networkPort = iServerPort;
        this.joinedOn = new Date();
        this.configuration = new OContextConfiguration();
        this.id = this.networkAddress + ":" + this.networkPort;
        this.status = STATUS.CONNECTING;
        this.asynchExecutor = Executors.newSingleThreadExecutor();
    }

    public boolean connect(int iTimeout, String iClusterName, SecretKey iSecurityKey) throws IOException {
        boolean connected;
        this.configuration.setValue(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT, (Object)iTimeout);
        this.channel = new OChannelBinaryClient(this.networkAddress, this.networkPort, this.configuration);
        OChannelBinaryProtocol.checkProtocolVersion(this.channel);
        OLogManager.instance().warn((Object)this, "Joining the server node %s:%d to the cluster...", new Object[]{this.networkAddress, this.networkPort});
        this.clientTxId = serialClientId.decrementAndGet();
        this.channel.writeByte((byte)81);
        this.channel.writeInt(this.clientTxId);
        this.channel.writeString(iClusterName);
        this.channel.writeBytes(iSecurityKey.getEncoded());
        this.channel.writeLong(this.manager.getRunningSince());
        this.channel.flush();
        this.channel.readStatus();
        boolean bl = connected = this.channel.readByte() == 1;
        if (!connected) {
            OLogManager.instance().warn((Object)this, "Remote server node %s:%d has refused the connection because it's the new Leader", new Object[]{this.networkAddress, this.networkPort});
            this.manager.abandonLeadership();
            return false;
        }
        ArrayList<OServerNodeDatabaseEntry> servers = new ArrayList<OServerNodeDatabaseEntry>(this.databases.values());
        for (OServerNodeDatabaseEntry entry : servers) {
            try {
                this.channel.writeByte((byte)83);
                this.channel.writeInt(this.clientTxId);
                this.channel.writeString(entry.databaseName);
                this.channel.writeString(entry.userName);
                this.channel.writeString(entry.userPassword);
                this.channel.flush();
                this.channel.readStatus();
                entry.sessionId = this.channel.readInt();
                long version = this.channel.readLong();
                if (version != entry.version) {
                    OLogManager.instance().warn((Object)this, "Remote database '" + entry.databaseName + "' has different version than Leader node (" + entry.version + ") and remote (" + version + "). Removing database from shared list.", new Object[0]);
                    this.databases.remove(entry.databaseName);
                    continue;
                }
                this.sendConfiguration(entry.databaseName);
            }
            catch (Exception e) {
                this.databases.remove(entry.databaseName);
                OLogManager.instance().warn((Object)this, "Database '" + entry.databaseName + "' is not present on remote server. Removing database from shared list.", new Object[0]);
            }
        }
        if (this.status == STATUS.CONNECTING) {
            OLogManager.instance().info((Object)this, "Server node %s:%d has joined the cluster", new Object[]{this.networkAddress, this.networkPort});
        } else {
            OLogManager.instance().info((Object)this, "Server node %s:%d has re-joined the cluster after %d secs", new Object[]{this.networkAddress, this.networkPort, (System.currentTimeMillis() - this.lastHeartBeat) / 1000L});
        }
        this.lastHeartBeat = System.currentTimeMillis();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(final OTransactionRecordEntry iRequest, final SYNCH_TYPE iRequestType) throws IOException {
        block28: {
            block27: {
                if (this.status != STATUS.UNREACHABLE) break block27;
                this.bufferChange(iRequest);
                break block28;
            }
            final OServerNodeDatabaseEntry databaseEntry = this.databases.get(iRequest.getRecord().getDatabase().getName());
            if (databaseEntry == null) {
                return;
            }
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "-> Sending request to remote server %s in %s mode...", new Object[]{this, iRequestType});
            }
            final ORecordInternal<?> record = iRequest.getRecord();
            this.status = STATUS.SYNCHRONIZING;
            try {
                switch (iRequest.status) {
                    case 3: {
                        this.channel.beginRequest();
                        try {
                            this.channel.writeByte((byte)31);
                            this.channel.writeInt(databaseEntry.sessionId);
                            this.channel.writeShort((short)record.getIdentity().getClusterId());
                            this.channel.writeBytes(record.toStream());
                            this.channel.writeByte(record.getRecordType());
                        }
                        finally {
                            this.channel.endRequest();
                        }
                        Callable<Object> response = new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                ODistributedServerNodeRemote.this.beginResponse(databaseEntry.sessionId);
                                try {
                                    ++databaseEntry.version;
                                    long clusterPosition = ODistributedServerNodeRemote.this.channel.readLong();
                                    if (clusterPosition != record.getIdentity().getClusterPosition()) {
                                        ODistributedServerNodeRemote.this.handleError(iRequest, iRequestType, (Exception)((Object)new ODistributedException("Error on distributed insert for database '" + record.getDatabase().getName() + "': the recordId received from the remote server node '" + ODistributedServerNodeRemote.this.getName() + "' is different from the current one. Master=" + record.getIdentity() + ", " + ODistributedServerNodeRemote.this.getName() + "=#" + record.getIdentity().getClusterId() + ":" + clusterPosition + ". Unsharing the database against the remote server node...")));
                                    }
                                }
                                finally {
                                    ODistributedServerNodeRemote.this.endResponse();
                                }
                                return null;
                            }
                        };
                        if (iRequestType == SYNCH_TYPE.ASYNCHRONOUS) {
                            this.asynchExecutor.submit(new FutureTask<Object>(response));
                            break;
                        }
                        try {
                            response.call();
                        }
                        catch (Exception e) {}
                        break;
                    }
                    case 1: {
                        this.channel.beginRequest();
                        try {
                            this.channel.writeByte((byte)32);
                            this.channel.writeInt(databaseEntry.sessionId);
                            this.channel.writeShort((short)record.getIdentity().getClusterId());
                            this.channel.writeLong(record.getIdentity().getClusterPosition());
                            this.channel.writeBytes(record.toStream());
                            this.channel.writeInt(record.getVersion());
                            this.channel.writeByte(record.getRecordType());
                        }
                        finally {
                            this.channel.endRequest();
                        }
                        Callable<Object> response = new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                ODistributedServerNodeRemote.this.beginResponse(databaseEntry.sessionId);
                                try {
                                    ++databaseEntry.version;
                                    int n = ODistributedServerNodeRemote.this.channel.readInt();
                                }
                                finally {
                                    ODistributedServerNodeRemote.this.endResponse();
                                }
                                return null;
                            }
                        };
                        if (iRequestType == SYNCH_TYPE.ASYNCHRONOUS) {
                            this.asynchExecutor.submit(new FutureTask<Object>(response));
                            break;
                        }
                        try {
                            response.call();
                        }
                        catch (Exception e) {}
                        break;
                    }
                    case 2: {
                        this.channel.beginRequest();
                        try {
                            this.channel.writeByte((byte)33);
                            this.channel.writeInt(databaseEntry.sessionId);
                            this.channel.writeShort((short)record.getIdentity().getClusterId());
                            this.channel.writeLong(record.getIdentity().getClusterPosition());
                            this.channel.writeInt(record.getVersion());
                        }
                        finally {
                            this.channel.endRequest();
                        }
                        Callable<Object> response = new Callable<Object>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Object call() throws Exception {
                                try {
                                    ODistributedServerNodeRemote.this.beginResponse(databaseEntry.sessionId);
                                    ++databaseEntry.version;
                                    ODistributedServerNodeRemote.this.channel.readByte();
                                }
                                finally {
                                    ODistributedServerNodeRemote.this.endResponse();
                                }
                                return null;
                            }
                        };
                        if (iRequestType == SYNCH_TYPE.ASYNCHRONOUS) {
                            this.asynchExecutor.submit(new FutureTask<Object>(response));
                            break;
                        }
                        try {
                            response.call();
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                this.status = STATUS.CONNECTED;
            }
            catch (IOException e) {
                this.handleError(iRequest, iRequestType, e);
            }
        }
    }

    protected void handleError(OTransactionRecordEntry iRequest, SYNCH_TYPE iRequestType, Exception iException) throws IOException {
        this.manager.handleNodeFailure(this);
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            this.channel = null;
        }
        if (iRequestType == SYNCH_TYPE.SYNCHRONOUS) {
            if (iException instanceof IOException) {
                throw (IOException)iException;
            }
            throw new IOException("Timeout on get lock against channel", iException);
        }
        this.bufferChange(iRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void bufferChange(OTransactionRecordEntry iRequest) {
        List<OTransactionRecordEntry> list = this.bufferedChanges;
        synchronized (list) {
            block8: {
                block9: {
                    if (this.bufferedChanges.size() > this.manager.serverOutSynchMaxBuffers) {
                        this.manager.removeNode(this);
                        this.bufferedChanges.clear();
                        this.databases.clear();
                    } else {
                        for (int i = 0; i < this.bufferedChanges.size(); ++i) {
                            OTransactionRecordEntry entry = this.bufferedChanges.get(i);
                            if (!entry.getRecord().getIdentity().equals(iRequest.getRecord().getIdentity())) continue;
                            this.bufferedChanges.set(i, iRequest);
                            break block8;
                        }
                        this.bufferedChanges.add(iRequest);
                        OLogManager.instance().info((Object)this, "Can't reach the remote node '%s', buffering change %d/%d for the record %s", new Object[]{this.id, this.bufferedChanges.size(), this.manager.serverOutSynchMaxBuffers, iRequest.getRecord().getIdentity()});
                    }
                    break block9;
                    catch (Throwable throwable) {
                        OLogManager.instance().info((Object)this, "Can't reach the remote node '%s', buffering change %d/%d for the record %s", new Object[]{this.id, this.bufferedChanges.size(), this.manager.serverOutSynchMaxBuffers, iRequest.getRecord().getIdentity()});
                        throw throwable;
                    }
                }
                return;
            }
            OLogManager.instance().info((Object)this, "Can't reach the remote node '%s', buffering change %d/%d for the record %s", new Object[]{this.id, this.bufferedChanges.size(), this.manager.serverOutSynchMaxBuffers, iRequest.getRecord().getIdentity()});
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendConfiguration(String iDatabaseName) {
        OServerNodeDatabaseEntry dbEntry = this.databases.get(iDatabaseName);
        if (dbEntry == null) {
            return;
        }
        OLogManager.instance().info((Object)this, "Sending distributed configuration for database '%s' to server node %s:%d...", new Object[]{iDatabaseName, this.networkAddress, this.networkPort});
        try {
            try {
                this.channel.beginRequest();
                this.channel.writeByte((byte)84);
                this.channel.writeInt(dbEntry.sessionId);
                this.channel.writeBytes(this.manager.getClusterConfiguration(iDatabaseName).toStream());
            }
            finally {
                this.channel.endRequest();
            }
            try {
                this.beginResponse(dbEntry.sessionId);
            }
            finally {
                this.endResponse();
            }
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Error on sending configuration to server node", new Object[]{this.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendHeartBeat(int iNetworkTimeout) throws InterruptedException {
        if (this.channel == null) {
            return false;
        }
        this.configuration.setValue(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT, (Object)iNetworkTimeout);
        OLogManager.instance().debug((Object)this, "Sending keepalive message to distributed server node %s:%d...", new Object[]{this.networkAddress, this.networkPort});
        try {
            this.channel.beginRequest();
            try {
                this.channel.writeByte((byte)80);
                this.channel.writeInt(this.clientTxId);
            }
            finally {
                this.channel.endRequest();
            }
            try {
                this.channel.beginResponse(this.clientTxId);
            }
            finally {
                this.channel.endResponse();
            }
            this.lastHeartBeat = System.currentTimeMillis();
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on sending heartbeat to server node", (Throwable)e, new Object[]{this.toString()});
            return false;
        }
        return true;
    }

    public void setAsTemporaryDisconnected(int iServerOutSynchMaxBuffers) {
        if (this.status != STATUS.UNREACHABLE) {
            this.status = STATUS.UNREACHABLE;
        }
    }

    public void startSynchronization() throws InterruptedException, IOException {
        if (this.status != STATUS.CONNECTED) {
            this.synchronizeDelta();
            this.status = STATUS.CONNECTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shareDatabase(ODatabaseRecord iDatabase, String iRemoteServerName, String iDbUser, String iDbPasswd, String iEngineName, boolean iSynchronousMode) throws IOException, InterruptedException {
        if (this.status != STATUS.CONNECTED) {
            throw new ODistributedSynchronizationException("Can't share database '" + iDatabase.getName() + "' on remote server node '" + iRemoteServerName + "' because is disconnected");
        }
        String dbName = iDatabase.getName();
        this.channel.beginRequest();
        try {
            this.status = STATUS.SYNCHRONIZING;
            OLogManager.instance().info((Object)this, "Sharing database '" + dbName + "' to remote server " + iRemoteServerName + "...", new Object[0]);
            this.channel.writeByte((byte)86);
            this.channel.writeInt(this.clientTxId);
            this.channel.writeString(dbName);
            this.channel.writeString(iDbUser);
            this.channel.writeString(iDbPasswd);
            this.channel.writeString(iEngineName);
        }
        finally {
            this.channel.endRequest();
        }
        OLogManager.instance().info((Object)this, "Exporting database '%s' via streaming to remote server node: %s...", new Object[]{iDatabase.getName(), iRemoteServerName});
        new ODatabaseExport(iDatabase, new OChannelBinaryOutputStream(this.channel), (OCommandOutputListener)this).exportDatabase();
        OLogManager.instance().info((Object)this, "Database exported correctly", new Object[0]);
        OServerNodeDatabaseEntry databaseEntry = new OServerNodeDatabaseEntry();
        databaseEntry.databaseName = dbName;
        databaseEntry.userName = iDbUser;
        databaseEntry.userPassword = iDbPasswd;
        this.channel.beginResponse(this.clientTxId);
        try {
            databaseEntry.sessionId = this.channel.readInt();
            databaseEntry.version = this.channel.readLong();
            this.databases.put(dbName, databaseEntry);
        }
        finally {
            this.channel.endResponse();
        }
        this.status = STATUS.CONNECTED;
    }

    @Override
    public void onMessage(String iText) {
    }

    public String toString() {
        return this.id;
    }

    public STATUS getStatus() {
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizeDelta() throws IOException {
        List<OTransactionRecordEntry> list = this.bufferedChanges;
        synchronized (list) {
            if (this.bufferedChanges.isEmpty()) {
                return;
            }
            OLogManager.instance().info((Object)this, "Started realignment of remote node '%s' after a reconnection. Found %d updates", new Object[]{this.id, this.bufferedChanges.size()});
            this.status = STATUS.SYNCHRONIZING;
            long time = System.currentTimeMillis();
            for (OTransactionRecordEntry entry : this.bufferedChanges) {
                this.sendRequest(entry, SYNCH_TYPE.SYNCHRONOUS);
            }
            this.bufferedChanges.clear();
            OLogManager.instance().info((Object)this, "Realignment of remote node '%s' completed in %d ms", new Object[]{this.id, System.currentTimeMillis() - time});
            this.status = STATUS.CONNECTED;
        }
    }

    public void beginResponse(int iSessionId) throws IOException {
        this.channel.beginResponse(iSessionId);
    }

    public void beginResponse() throws IOException {
        if (this.channel != null) {
            this.channel.beginResponse(this.clientTxId);
        }
    }

    public void endResponse() {
        if (this.channel != null) {
            this.channel.endResponse();
        }
    }

    public String getName() {
        return this.networkAddress + ":" + this.networkPort;
    }

    public boolean checkConnection() {
        boolean connected = false;
        if (this.channel != null && this.channel.socket != null) {
            try {
                connected = this.channel.socket.isConnected();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!connected) {
            this.status = STATUS.DISCONNECTED;
        }
        return connected;
    }

    public void disconnect() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channel = null;
    }

    public static enum SYNCH_TYPE {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }

    public static enum STATUS {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        UNREACHABLE,
        SYNCHRONIZING;

    }
}

