/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.binary;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.memory.OStorageMemory;
import com.orientechnologies.orient.enterprise.channel.OChannel;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryServer;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OClientConnectionManager;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.handler.OServerHandlerHelper;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocol;
import com.orientechnologies.orient.server.tx.OTransactionOptimisticProxy;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ONetworkProtocolBinary
extends ONetworkProtocol {
    protected OClientConnection connection;
    protected OChannelBinaryServer channel;
    protected OUser account;
    protected String user;
    protected String passwd;
    protected int lastRequestType;
    protected int lastClientTxId;
    private OServerUserConfiguration serverUser;
    private boolean firstConnection = true;

    public ONetworkProtocolBinary() {
        super(Orient.getThreadGroup(), "IO-Binary");
    }

    public ONetworkProtocolBinary(String iThreadName) {
        super(Orient.getThreadGroup(), iThreadName);
    }

    @Override
    public void config(OServer iServer, Socket iSocket, OClientConnection iConnection, OContextConfiguration iConfig) throws IOException {
        this.server = iServer;
        this.channel = new OChannelBinaryServer(iSocket, iConfig);
        this.connection = iConnection;
        this.channel.writeShort((short)5);
        this.channel.flush();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        this.lastRequestType = -1;
        this.data.commandInfo = "Listening";
        this.data.commandDetail = "-";
        this.lastClientTxId = 0;
        try {
            this.lastRequestType = this.channel.readByte();
            this.lastClientTxId = this.channel.readInt();
            if (this.lastClientTxId > -1) {
                this.connection = OClientConnectionManager.instance().getConnection(this.lastClientTxId);
            } else if (this.firstConnection) {
                this.firstConnection = false;
            } else {
                if (this.connection == null) {
                    this.sendShutdown();
                    return;
                }
                this.connection = OClientConnectionManager.instance().connect(this.connection.protocol.getChannel().socket, this);
            }
            if (this.connection != null) {
                ODatabaseRecordThreadLocal.INSTANCE.set(this.connection.database);
            }
            ++this.data.totalRequests;
            this.data.lastCommandReceived = System.currentTimeMillis();
            OServerHandlerHelper.invokeHandlerCallbackOnBeforeClientRequest(this.connection, (byte)this.lastRequestType);
            this.parseCommand();
            OServerHandlerHelper.invokeHandlerCallbackOnAfterClientRequest(this.connection, (byte)this.lastRequestType);
        }
        catch (EOFException e) {
            this.handleConnectionError(e);
            this.sendShutdown();
        }
        catch (SocketException e) {
            this.handleConnectionError(e);
            this.sendShutdown();
        }
        catch (OException e) {
            this.sendError(this.lastClientTxId, e);
        }
        catch (RuntimeException e) {
            this.sendError(this.lastClientTxId, e);
        }
        catch (Throwable t) {
            OLogManager.instance().error((Object)this, "Error on executing request", t, new Object[0]);
            this.sendError(this.lastClientTxId, t);
        }
        finally {
            try {
                this.channel.flush();
            }
            catch (Throwable t) {
                OLogManager.instance().debug((Object)this, "Error on send data over the network", t, new Object[0]);
            }
            ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
            this.data.lastCommandExecutionTime = System.currentTimeMillis() - this.data.lastCommandReceived;
            this.data.totalCommandExecutionTime += this.data.lastCommandExecutionTime;
            this.data.lastCommandInfo = this.data.commandInfo;
            this.data.lastCommandDetail = this.data.commandDetail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void parseCommand() throws IOException, InterruptedException {
        switch (this.lastRequestType) {
            case 1: {
                this.data.commandInfo = "Shutdowning";
                OLogManager.instance().info((Object)this, "Received shutdown command from the remote client %s:%d", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
                this.user = this.channel.readString();
                this.passwd = this.channel.readString();
                if (!OServerMain.server().authenticate(this.user, this.passwd, "shutdown")) {
                    OLogManager.instance().error((Object)this, "Authentication error of remote client %s:%d: shutdown is aborted.", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
                    this.sendError(this.lastClientTxId, (Throwable)((Object)new OSecurityAccessException("Invalid user/password to shutdown the server")));
                    return;
                }
                OLogManager.instance().info((Object)this, "Remote client %s:%d authenticated. Starting shutdown of server...", new Object[]{this.channel.socket.getInetAddress(), this.channel.socket.getPort()});
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
                this.channel.flush();
                this.channel.close();
                OServerMain.server().shutdown();
                System.exit(0);
                return;
            }
            case 2: {
                this.data.commandInfo = "Connect";
                this.serverLogin(this.channel.readString(), this.channel.readString());
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeInt(this.connection.id);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 3: {
                this.data.commandInfo = "Open database";
                String dbURL = this.channel.readString();
                this.user = this.channel.readString();
                this.passwd = this.channel.readString();
                this.openDatabase(dbURL, this.user, this.passwd);
                if (!(this.connection.database.getStorage() instanceof OStorageEmbedded) && !this.loadUserFromSchema(this.user, this.passwd)) {
                    this.sendError(this.lastClientTxId, (Throwable)((Object)new OSecurityAccessException(this.connection.database.getName(), "User or password not valid for database: '" + this.connection.database.getName() + "'")));
                    return;
                }
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeInt(this.connection.id);
                    this.sendDatabaseInformation();
                    if (!((Object)((Object)this)).getClass().equals(ONetworkProtocolBinary.class)) return;
                    this.channel.writeBytes(null);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 73: {
                this.data.commandInfo = "Reload database information";
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.sendDatabaseInformation();
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 4: {
                this.data.commandInfo = "Create database";
                String dbName = this.channel.readString();
                String storageMode = this.channel.readString();
                this.checkServerAccess("database.create");
                this.connection.database = this.getDatabaseInstance(dbName, storageMode);
                this.createDatabase(this.connection.database, null, null);
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 5: {
                this.data.commandInfo = "Close Database";
                if (this.connection != null) {
                    this.connection.close();
                    OClientConnectionManager.instance().disconnect(this.connection.id);
                }
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 6: {
                this.data.commandInfo = "Exists database";
                String dbName = this.channel.readString();
                this.checkServerAccess("database.exists");
                this.connection.database = this.getDatabaseInstance(dbName, "local");
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeByte((byte)(this.connection.database.exists() ? 1 : 0));
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 7: {
                this.data.commandInfo = "Delete database";
                String dbName = this.channel.readString();
                this.checkServerAccess("database.delete");
                this.connection.database = this.getDatabaseInstance(dbName, "local");
                OLogManager.instance().info((Object)this, "Dropped database '%s", new Object[]{this.connection.database.getURL()});
                this.connection.database.delete();
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 8: {
                this.data.commandInfo = "Database size";
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeLong(this.connection.database.getStorage().getSize());
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 9: {
                this.data.commandInfo = "Database count records";
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeLong(this.connection.database.getStorage().countRecords());
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 12: {
                this.data.commandInfo = "Count cluster elements";
                int[] clusterIds = new int[this.channel.readShort()];
                for (int i = 0; i < clusterIds.length; ++i) {
                    clusterIds[i] = this.channel.readShort();
                }
                long count = this.connection.database.countClusterElements(clusterIds);
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeLong(count);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 13: {
                this.data.commandInfo = "Get the begin/end range of data in cluster";
                long[] pos = this.connection.database.getStorage().getClusterDataRange(this.channel.readShort());
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeLong(pos[0]);
                    this.channel.writeLong(pos[1]);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 10: {
                int num;
                this.data.commandInfo = "Add cluster";
                String type = this.channel.readString();
                String name = this.channel.readString();
                OStorage.CLUSTER_TYPE t = OStorage.CLUSTER_TYPE.valueOf(type);
                switch (t) {
                    case PHYSICAL: {
                        num = this.connection.database.addPhysicalCluster(name, this.channel.readString(), this.channel.readInt());
                        break;
                    }
                    case MEMORY: {
                        num = this.connection.database.getStorage().addCluster(name, t, new Object[0]);
                        break;
                    }
                    case LOGICAL: {
                        num = this.connection.database.addLogicalCluster(name, this.channel.readInt());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Cluster type " + type + " is not supported");
                    }
                }
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeShort((short)num);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 11: {
                this.data.commandInfo = "Remove cluster";
                short id = this.channel.readShort();
                boolean result = this.connection.database.dropCluster(this.connection.database.getClusterNameById(id));
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeByte((byte)(result ? 1 : 0));
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 30: {
                this.data.commandInfo = "Load record";
                ORecordId rid = this.channel.readRID();
                String fetchPlanString = this.channel.readString();
                if (rid.clusterId == 0 && rid.clusterPosition == 0L) {
                    OFetchHelper.checkFetchPlanValid(fetchPlanString);
                    this.channel.acquireExclusiveLock();
                    try {
                        this.sendOk(this.lastClientTxId);
                        this.channel.writeByte((byte)1);
                        this.channel.writeBytes(this.connection.database.getStorage().getConfiguration().toStream());
                        this.channel.writeInt(0);
                        this.channel.writeByte((byte)98);
                    }
                    finally {
                        this.channel.releaseExclusiveLock();
                    }
                }
                Object record = this.connection.database.load(rid, fetchPlanString);
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    if (record != null) {
                        this.channel.writeByte((byte)1);
                        this.channel.writeBytes(record.toStream());
                        this.channel.writeInt(record.getVersion());
                        this.channel.writeByte(record.getRecordType());
                        if (fetchPlanString.length() > 0 && record instanceof ODocument) {
                            Map<String, Integer> fetchPlan = OFetchHelper.buildFetchPlan(fetchPlanString);
                            final HashSet recordsToSend = new HashSet();
                            OFetchHelper.fetch((ODocument)record, record, fetchPlan, null, 0, -1, new OFetchListener(){

                                @Override
                                public int size() {
                                    return recordsToSend.size();
                                }

                                @Override
                                public Object fetchLinked(ODocument iRoot, Object iUserObject, String iFieldName, Object iLinked) {
                                    if (iLinked instanceof ODocument) {
                                        if (((ODocument)iLinked).getIdentity().isValid()) {
                                            return recordsToSend.add((ODocument)iLinked) ? iLinked : null;
                                        }
                                        return null;
                                    }
                                    if (iLinked instanceof Collection) {
                                        return recordsToSend.addAll((Collection)iLinked) ? iLinked : null;
                                    }
                                    if (iLinked instanceof Map) {
                                        return recordsToSend.addAll(((Map)iLinked).values()) ? iLinked : null;
                                    }
                                    throw new IllegalArgumentException("Unrecognized type while fetching records: " + iLinked);
                                }
                            });
                            for (ODocument doc : recordsToSend) {
                                if (!doc.getIdentity().isValid()) continue;
                                this.channel.writeByte((byte)2);
                                this.writeIdentifiable(doc);
                            }
                        }
                    }
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
                this.channel.writeByte((byte)0);
                return;
            }
            case 31: {
                this.data.commandInfo = "Create record";
                ORecordId rid = new ORecordId(this.channel.readShort(), -1L);
                byte[] buffer = this.channel.readBytes();
                byte recordType = this.channel.readByte();
                ORecordInternal<?> record = Orient.instance().getRecordFactoryManager().newInstance(this.connection.database, recordType);
                record.fill(this.connection.database, rid, 0, buffer, true);
                this.connection.database.save((ORecordInternal)record);
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeLong(record.getIdentity().getClusterPosition());
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 32: {
                Object currentRecord;
                this.data.commandInfo = "Update record";
                ORecordId rid = this.channel.readRID();
                byte[] buffer = this.channel.readBytes();
                int version = this.channel.readInt();
                byte recordType = this.channel.readByte();
                ORecordInternal<?> newRecord = Orient.instance().getRecordFactoryManager().newInstance(this.connection.database, recordType);
                newRecord.fill(this.connection.database, rid, version, buffer, true);
                if (((OSchemaProxy)this.connection.database.getMetadata().getSchema()).getIdentity().equals(rid)) {
                    throw new OSecurityAccessException("Can't update internal record " + rid);
                }
                if (newRecord instanceof ODocument) {
                    currentRecord = this.connection.database.load(rid);
                    if (currentRecord == null) {
                        throw new ORecordNotFoundException(rid.toString());
                    }
                    ODocument doc = (ODocument)currentRecord;
                    doc.merge((ODocument)newRecord, false, false);
                } else {
                    currentRecord = newRecord;
                }
                currentRecord.setVersion(version);
                this.connection.database.save((ORecordInternal)currentRecord);
                if (currentRecord.getIdentity().toString().equals(this.connection.database.getStorage().getConfiguration().indexMgrRecordId)) {
                    this.connection.database.getMetadata().getIndexManager().reload();
                }
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeInt(currentRecord.getVersion());
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 33: {
                this.data.commandInfo = "Delete record";
                Object record = this.connection.database.load(this.channel.readRID());
                record.setVersion(this.channel.readInt());
                record.delete();
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeByte((byte)1);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 40: {
                this.data.commandInfo = "Count cluster records";
                String clusterName = this.channel.readString();
                long size = this.connection.database.countClusterElements(clusterName);
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeLong(size);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 41: {
                this.data.commandInfo = "Execute remote command";
                boolean asynch = this.channel.readByte() == 97;
                OCommandRequestText command = (OCommandRequestText)OStreamSerializerAnyStreamable.INSTANCE.fromStream(this.connection.database, this.channel.readBytes());
                OQuery query = (OQuery)((Object)(command instanceof OQuery ? command : null));
                this.data.commandDetail = command.getText();
                this.channel.acquireExclusiveLock();
                try {
                    if (asynch) {
                        final StringBuilder empty = new StringBuilder();
                        final HashSet recordsToSend = new HashSet();
                        final int txId = this.lastClientTxId;
                        final Map<String, Integer> fetchPlan = query != null ? OFetchHelper.buildFetchPlan(query.getFetchPlan()) : null;
                        command.setResultListener(new OCommandResultListener(){

                            @Override
                            public boolean result(Object iRecord) {
                                if (empty.length() == 0) {
                                    try {
                                        ONetworkProtocolBinary.this.sendOk(txId);
                                        empty.append("-");
                                    }
                                    catch (IOException e1) {
                                        // empty catch block
                                    }
                                }
                                try {
                                    ONetworkProtocolBinary.this.channel.writeByte((byte)1);
                                    ONetworkProtocolBinary.this.writeIdentifiable((ORecordInternal)iRecord);
                                    if (fetchPlan != null && iRecord instanceof ODocument) {
                                        OFetchHelper.fetch((ODocument)iRecord, iRecord, fetchPlan, null, 0, -1, new OFetchListener(){

                                            @Override
                                            public int size() {
                                                return recordsToSend.size();
                                            }

                                            @Override
                                            public Object fetchLinked(ODocument iRoot, Object iUserObject, String iFieldName, Object iLinked) {
                                                if (iLinked instanceof ODocument) {
                                                    return recordsToSend.add((ODocument)iLinked) ? iLinked : null;
                                                }
                                                if (iLinked instanceof Collection) {
                                                    return recordsToSend.addAll((Collection)iLinked) ? iLinked : null;
                                                }
                                                if (iLinked instanceof Map) {
                                                    return recordsToSend.addAll(((Map)iLinked).values()) ? iLinked : null;
                                                }
                                                throw new IllegalArgumentException("Unrecognized type while fetching records: " + iLinked);
                                            }
                                        });
                                    }
                                }
                                catch (IOException e) {
                                    return false;
                                }
                                return true;
                            }
                        });
                        ((OCommandRequestInternal)this.connection.database.command(command)).execute(new Object[0]);
                        if (empty.length() == 0) {
                            try {
                                this.sendOk(this.lastClientTxId);
                            }
                            catch (IOException e1) {
                                // empty catch block
                            }
                        }
                        Iterator i$ = recordsToSend.iterator();
                        while (true) {
                            if (!i$.hasNext()) {
                                this.channel.writeByte((byte)0);
                                return;
                            }
                            ODocument doc = (ODocument)i$.next();
                            this.channel.writeByte((byte)2);
                            this.writeIdentifiable(doc);
                        }
                    }
                    Object result = ((OCommandRequestInternal)this.connection.database.command(command)).execute(new Object[0]);
                    this.sendOk(this.lastClientTxId);
                    if (result == null) {
                        this.channel.writeByte((byte)110);
                        return;
                    }
                    if (result instanceof OIdentifiable) {
                        this.channel.writeByte((byte)114);
                        this.writeIdentifiable((OIdentifiable)result);
                        return;
                    }
                    if (result instanceof Collection) {
                        this.channel.writeByte((byte)108);
                        Collection list = (Collection)result;
                        this.channel.writeInt(list.size());
                        Iterator i$ = list.iterator();
                        while (i$.hasNext()) {
                            OIdentifiable o = (OIdentifiable)i$.next();
                            this.writeIdentifiable(o);
                        }
                        return;
                    }
                    this.channel.writeByte((byte)97);
                    StringBuilder value = new StringBuilder();
                    ORecordSerializerStringAbstract.fieldTypeToString(value, this.connection.database, OType.getTypeByClass(result.getClass()), result);
                    this.channel.writeString(value.toString());
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 60: {
                this.data.commandInfo = "Transaction commit";
                OTransactionOptimisticProxy tx = new OTransactionOptimisticProxy((ODatabaseRecordTx)this.connection.database.getUnderlying(), this.channel);
                this.connection.database.begin(tx);
                try {
                    this.connection.database.commit();
                    this.channel.acquireExclusiveLock();
                    try {
                        this.sendOk(this.lastClientTxId);
                        this.channel.writeInt(tx.getCreatedRecords().size());
                        for (Map.Entry<ORecordId, ORecord<?>> entry : tx.getCreatedRecords().entrySet()) {
                            this.channel.writeRID(entry.getKey());
                            this.channel.writeRID(entry.getValue().getIdentity());
                            if (entry.getValue().getVersion() <= 0) continue;
                            tx.getUpdatedRecords().put((ORecordId)entry.getValue().getIdentity(), entry.getValue());
                        }
                        this.channel.writeInt(tx.getUpdatedRecords().size());
                        Iterator<Map.Entry<ORecordId, ORecord<?>>> i$ = tx.getUpdatedRecords().entrySet().iterator();
                        while (i$.hasNext()) {
                            Map.Entry<ORecordId, ORecord<?>> entry;
                            entry = i$.next();
                            this.channel.writeRID(entry.getKey());
                            this.channel.writeInt(entry.getValue().getVersion());
                        }
                        return;
                    }
                    finally {
                        this.channel.releaseExclusiveLock();
                    }
                }
                catch (Exception e) {
                    this.connection.database.rollback();
                    this.sendError(this.lastClientTxId, e);
                    return;
                }
            }
            case 70: {
                this.data.commandInfo = "Get config";
                this.checkServerAccess("server.config.get");
                String key = this.channel.readString();
                OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(key);
                String cfgValue = cfg != null ? cfg.getValueAsString() : "";
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeString(cfgValue);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 71: {
                this.data.commandInfo = "Get config";
                this.checkServerAccess("server.config.set");
                String key = this.channel.readString();
                String value = this.channel.readString();
                OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(key);
                if (cfg != null) {
                    cfg.setValue(value);
                }
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 72: {
                this.data.commandInfo = "List config";
                this.checkServerAccess("server.config.get");
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeShort((short)OGlobalConfiguration.values().length);
                    OGlobalConfiguration[] arr$ = OGlobalConfiguration.values();
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (i$ < len$) {
                        OGlobalConfiguration cfg = arr$[i$];
                        this.channel.writeString(cfg.getKey());
                        this.channel.writeString(cfg.getValueAsString() != null ? cfg.getValueAsString() : "");
                        ++i$;
                    }
                    return;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
        }
        this.data.commandInfo = "Command not supported";
        OLogManager.instance().error((Object)this, "Request not supported. Code: " + this.lastRequestType, new Object[0]);
        this.channel.clearInput();
        this.sendError(this.lastClientTxId, (Throwable)((Object)new ONetworkProtocolException("Request not supported. Code: " + this.lastRequestType)));
    }

    private void sendDatabaseInformation() throws IOException {
        this.channel.writeInt(this.connection.database.getClusterNames().size());
        for (OCluster oCluster : this.connection.database.getStorage().getClusterInstances()) {
            if (oCluster == null) continue;
            this.channel.writeString(oCluster.getName());
            this.channel.writeInt(oCluster.getId());
            this.channel.writeString(oCluster.getType());
        }
    }

    public void startup() {
        OServerHandlerHelper.invokeHandlerCallbackOnClientConnection(this.connection);
    }

    public void shutdown() {
        this.sendShutdown();
        this.channel.close();
        if (this.connection == null) {
            return;
        }
        OServerHandlerHelper.invokeHandlerCallbackOnClientDisconnection(this.connection);
        if (this.connection.database != null) {
            this.connection.database.close();
        }
        OClientConnectionManager.instance().disconnect(this.connection.id);
    }

    @Override
    public OChannel getChannel() {
        return this.channel;
    }

    protected void sendOk(int iClientTxId) throws IOException {
        this.channel.writeByte((byte)0);
        this.channel.writeInt(iClientTxId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendError(int iClientTxId, Throwable t) throws IOException, InterruptedException {
        this.channel.acquireExclusiveLock();
        try {
            this.channel.writeByte((byte)1);
            this.channel.writeInt(iClientTxId);
            for (Throwable current = t instanceof OLockException && t.getCause() instanceof ODatabaseException ? t.getCause() : t; current != null; current = current.getCause()) {
                this.channel.writeByte((byte)1);
                this.channel.writeString(current.getClass().getName());
                this.channel.writeString(current != null ? current.getMessage() : null);
            }
            this.channel.writeByte((byte)0);
            this.channel.clearInput();
        }
        finally {
            this.channel.releaseExclusiveLock();
        }
    }

    private void serverLogin(String iUser, String iPassword) {
        if (!OServerMain.server().authenticate(iUser, iPassword, "connect")) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance. Get the user/password from the config/orientdb-server-config.xml file");
        }
        this.serverUser = OServerMain.server().getUser(iUser);
    }

    protected void checkServerAccess(String iResource) {
        if (this.serverUser == null) {
            throw new OSecurityAccessException("Server user not authenticated.");
        }
        if (!OServerMain.server().authenticate(this.serverUser.name, null, iResource)) {
            throw new OSecurityAccessException("User '" + this.serverUser.name + "' can't access to the resource [" + iResource + "]. Use another server user or change permission in the file config/orientdb-server-config.xml");
        }
    }

    private boolean loadUserFromSchema(String iUserName, String iUserPassword) {
        this.account = this.connection.database.getMetadata().getSecurity().authenticate(iUserName, iUserPassword);
        return true;
    }

    public void writeIdentifiable(OIdentifiable o) throws IOException {
        if (o == null) {
            this.channel.writeShort((short)-2);
        } else if (o instanceof ORecordId) {
            this.channel.writeShort((short)-3);
            this.channel.writeRID((ORID)o);
        } else {
            this.writeRecord((ORecordInternal)o);
        }
    }

    private void writeRecord(ORecordInternal<?> iRecord) throws IOException {
        this.channel.writeShort((short)0);
        this.channel.writeByte(iRecord.getRecordType());
        this.channel.writeRID(iRecord.getIdentity());
        this.channel.writeInt(iRecord.getVersion());
        try {
            byte[] stream = iRecord.toStream();
            int realLength = stream.length;
            for (int i = stream.length - 1; i > -1 && stream[i] == 32; --i) {
                --realLength;
            }
            this.channel.writeBytes(stream, realLength);
        }
        catch (Exception e) {
            this.channel.writeBytes(null);
            OLogManager.instance().error((Object)this, "Error on unmarshalling record #" + iRecord.getIdentity().toString(), OSerializationException.class);
        }
    }

    protected ODatabaseDocumentTx openDatabase(String iDbUrl, String iUser, String iPassword) throws InterruptedException {
        String path = OServerMain.server().getStoragePath(iDbUrl);
        this.connection.database = new ODatabaseDocumentTx(path);
        if (this.connection.database.isClosed()) {
            if (this.connection.database.getStorage() instanceof OStorageMemory) {
                this.connection.database.create();
            } else {
                this.connection.database.open(iUser, iPassword);
            }
        }
        this.connection.rawDatabase = (ODatabaseRaw)((ODatabaseComplex)this.connection.database.getUnderlying()).getUnderlying();
        return this.connection.database;
    }

    protected void createDatabase(ODatabaseDocumentTx iDatabase, String dbUser, String dbPasswd) {
        if (iDatabase.exists()) {
            throw new ODatabaseException("Database '" + iDatabase.getURL() + "' already exists");
        }
        for (OStorage stg : Orient.instance().getStorages()) {
            if (!stg.getName().equalsIgnoreCase(iDatabase.getName()) || !stg.exists()) continue;
            throw new ODatabaseException("Database '" + iDatabase.getURL() + "' already exists: " + stg);
        }
        iDatabase.create();
        if (dbUser != null) {
            OUser oUser = iDatabase.getMetadata().getSecurity().getUser(dbUser);
            if (oUser == null) {
                iDatabase.getMetadata().getSecurity().createUser(dbUser, dbPasswd, new String[]{"admin"});
            } else {
                oUser.setPassword(dbPasswd);
                oUser.save();
            }
        }
        OLogManager.instance().info((Object)this, "Created database '%s' of type '%s'", new Object[]{iDatabase.getURL(), iDatabase.getStorage() instanceof OStorageLocal ? "local" : "memory"});
        if (iDatabase.getStorage() instanceof OStorageLocal) {
            iDatabase.close();
        }
        this.connection.rawDatabase = (ODatabaseRaw)((ODatabaseComplex)iDatabase.getUnderlying()).getUnderlying();
    }

    protected ODatabaseDocumentTx getDatabaseInstance(String iDbName, String iStorageMode) {
        String path;
        OStorage stg = Orient.instance().getStorage(iDbName);
        if (stg != null) {
            path = stg.getURL();
        } else if (iStorageMode.equals("local")) {
            path = iStorageMode + ":${ORIENTDB_HOME}/databases/" + iDbName;
        } else if (iStorageMode.equals("memory")) {
            path = iStorageMode + ":" + iDbName;
        } else {
            throw new IllegalArgumentException("Can't create database: storage mode '" + iStorageMode + "' is not supported.");
        }
        return new ODatabaseDocumentTx(path);
    }

    private void handleConnectionError(Throwable e) {
        OServerHandlerHelper.invokeHandlerCallbackOnClientError(this.connection, e);
    }
}

