/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.distributed;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryInputStream;
import com.orientechnologies.orient.server.OServerMain;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.handler.distributed.ODistributedServerNodeRemote;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import com.orientechnologies.orient.server.network.protocol.distributed.ODistributedRequesterThreadLocal;
import java.io.IOException;
import java.util.Arrays;

public class ONetworkProtocolDistributed
extends ONetworkProtocolBinary
implements OCommandOutputListener {
    private ODistributedServerManager manager = OServerMain.server().getHandler(ODistributedServerManager.class);

    public ONetworkProtocolDistributed() {
        super("Distributed-DB");
        if (this.manager == null) {
            throw new OConfigurationException("Can't find a ODistributedServerDiscoveryManager instance registered as handler. Check the server configuration in the handlers section.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void parseCommand() throws IOException, InterruptedException {
        switch (this.lastRequestType) {
            case 80: {
                this.checkConnected();
                this.data.commandInfo = "Keep-alive";
                this.manager.updateHeartBeatTime();
                this.sendOk(this.lastClientTxId);
                break;
            }
            case 81: {
                this.data.commandInfo = "Cluster connection";
                String clusterName = this.channel.readString();
                byte[] encodedSecurityKey = this.channel.readBytes();
                long runningSince = this.channel.readLong();
                if (!clusterName.equals(this.manager.getName()) || !Arrays.equals(encodedSecurityKey, this.manager.getSecurityKey())) {
                    throw new OSecurityException("Invalid combination of cluster name and key received");
                }
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    if (this.manager.isLeader()) {
                        OLogManager.instance().warn((Object)this, "Received remote connection from the leader node %s, but current node is leader itself: split network problem?", new Object[]{this.channel.socket.getRemoteSocketAddress()});
                        if (runningSince > this.manager.getRunningSince()) {
                            OLogManager.instance().warn((Object)this, "Current node becames Non-Leader since the other node is running since longer time", new Object[0]);
                            this.manager.receivedLeaderConnection(this);
                            this.channel.writeByte((byte)1);
                            break;
                        }
                        OLogManager.instance().warn((Object)this, "Current node remains Leader since it's running since longer time", new Object[0]);
                        this.channel.writeByte((byte)0);
                        break;
                    }
                    this.manager.receivedLeaderConnection(this);
                    this.channel.writeByte((byte)1);
                    break;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 83: {
                this.checkConnected();
                this.data.commandInfo = "Open database connection";
                String dbUrl = this.channel.readString();
                this.openDatabase(dbUrl, this.channel.readString(), this.channel.readString());
                ODistributedRequesterThreadLocal.INSTANCE.set(true);
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    this.channel.writeInt(this.connection.id);
                    this.channel.writeLong(this.connection.database.getStorage().getVersion());
                    break;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            case 85: {
                this.data.commandInfo = "Share the database to a remote server";
                String dbUrl = this.channel.readString();
                String dbUser = this.channel.readString();
                String dbPassword = this.channel.readString();
                String remoteServerName = this.channel.readString();
                boolean synchronousMode = this.channel.readByte() == 1;
                this.checkServerAccess("database.share");
                this.openDatabase(dbUrl, dbUser, dbPassword);
                String engineName = this.connection.database.getStorage() instanceof OStorageLocal ? "local" : "memory";
                ODistributedServerNodeRemote remoteServerNode = this.manager.getNode(remoteServerName);
                remoteServerNode.shareDatabase(this.connection.database, remoteServerName, dbUser, dbPassword, engineName, synchronousMode);
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
                this.manager.addServerInConfiguration(dbUrl, remoteServerName, synchronousMode);
                break;
            }
            case 86: {
                this.checkConnected();
                this.data.commandInfo = "Received a shared database from a remote server to install";
                String dbName = this.channel.readString();
                String dbUser = this.channel.readString();
                String dbPasswd = this.channel.readString();
                String engineName = this.channel.readString();
                ODistributedRequesterThreadLocal.INSTANCE.set(true);
                this.manager.setStatus(ODistributedServerManager.STATUS.SYNCHRONIZING);
                try {
                    OLogManager.instance().info((Object)this, "Received database '%s' to share on local server node", new Object[]{dbName});
                    this.connection.database = this.getDatabaseInstance(dbName, engineName);
                    if (this.connection.database.exists()) {
                        OLogManager.instance().info((Object)this, "Deleting existent database '%s'", new Object[]{this.connection.database.getName()});
                        this.connection.database.delete();
                    }
                    this.createDatabase(this.connection.database, dbUser, dbPasswd);
                    if (this.connection.database.isClosed()) {
                        this.connection.database.open(dbUser, dbPasswd);
                    }
                    OLogManager.instance().info((Object)this, "Importing database '%s' via streaming from remote server node...", new Object[]{dbName});
                    this.channel.acquireExclusiveLock();
                    try {
                        new ODatabaseImport((ODatabaseDocument)this.connection.database, new OChannelBinaryInputStream(this.channel), (OCommandOutputListener)this).importDatabase();
                        OLogManager.instance().info((Object)this, "Database imported correctly", new Object[]{dbName});
                        this.sendOk(this.lastClientTxId);
                        this.channel.writeInt(this.connection.id);
                        this.channel.writeLong(this.connection.database.getStorage().getVersion());
                        break;
                    }
                    finally {
                        this.channel.releaseExclusiveLock();
                    }
                }
                finally {
                    this.manager.updateHeartBeatTime();
                    this.manager.setStatus(ODistributedServerManager.STATUS.ONLINE);
                }
            }
            case 84: {
                this.checkConnected();
                this.data.commandInfo = "Update db configuration from server node leader";
                ODocument config = new ODocument().fromStream(this.channel.readBytes());
                this.manager.setClusterConfiguration(this.connection.database.getName(), config);
                OLogManager.instance().warn((Object)this, "Changed distributed server configuration:\n%s", new Object[]{config.toJSON("")});
                this.channel.acquireExclusiveLock();
                try {
                    this.sendOk(this.lastClientTxId);
                    break;
                }
                finally {
                    this.channel.releaseExclusiveLock();
                }
            }
            default: {
                super.parseCommand();
                return;
            }
        }
        try {
            this.channel.flush();
        }
        catch (Throwable t) {
            OLogManager.instance().debug((Object)this, "Error on send data over the network", t, new Object[0]);
        }
    }

    @Override
    public void onMessage(String iText) {
    }

    protected void checkConnected() {
        if (!this.manager.isLeaderConnected()) {
            throw new OSecurityException("Invalid request from a non-connected node");
        }
    }
}

