/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.server.db.OSharedDocumentDatabase;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;
import java.util.Collection;

public class OServerCommandGetIndex
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"GET|index/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: index/<database>/<index-name>/<key>");
        iRequest.data.commandInfo = "Index get";
        ODatabaseDocumentTx db = null;
        try {
            db = this.getProfiledDatabaseInstance(iRequest);
            OIndex<?> index = db.getMetadata().getIndexManager().getIndex(urlParts[2]);
            if (index == null) {
                throw new IllegalArgumentException("Index name '" + urlParts[2] + "' not found");
            }
            Object content = index.get(urlParts[3]);
            if (content == null) {
                this.sendTextContent(iRequest, 404, "Not Found", null, "text/plain", null);
            } else {
                StringBuilder buffer = new StringBuilder();
                buffer.append('[');
                if (content instanceof Collection) {
                    Collection collection = (Collection)content;
                    for (OIdentifiable item : collection) {
                        buffer.append(item.getRecord().toJSON());
                    }
                } else {
                    buffer.append(((OIdentifiable)content).getRecord().toJSON());
                }
                buffer.append(']');
                this.sendTextContent(iRequest, 200, "OK", null, "text/plain", buffer.toString());
            }
        }
        finally {
            if (db != null) {
                OSharedDocumentDatabase.release(db);
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

