/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.multipart;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentInputStream;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartContentParser;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Map;

public class OHttpMultipartFileToDiskContentParser
implements OHttpMultipartContentParser<StringWriter> {
    protected String path;

    public OHttpMultipartFileToDiskContentParser(String iPath) {
        this.path = iPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringWriter parse(OHttpRequest iRequest, Map<String, String> headers, OHttpMultipartContentInputStream in, ODatabaseRecord database) throws IOException {
        StringWriter buffer = new StringWriter();
        OJSONWriter json = new OJSONWriter(buffer);
        json.beginObject();
        String fileName = headers.get("filename");
        int fileSize = 0;
        if (fileName.charAt(0) == '\"') {
            fileName = new String(fileName.substring(1));
        }
        if (fileName.charAt(fileName.length() - 1) == '\"') {
            fileName = new String(fileName.substring(0, fileName.length() - 1));
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.path + fileName.toString()));
        try {
            while (in.available() > 0) {
                int value = in.read();
                ((OutputStream)out).write(value);
                ++fileSize;
            }
        }
        finally {
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
        }
        json.writeAttribute(1, true, "name", fileName);
        json.writeAttribute(1, true, "type", headers.get("Content-Type"));
        json.writeAttribute(1, true, "size", fileSize);
        json.endObject();
        return buffer;
    }
}

