/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.tx;

import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.server.tx.OTransactionEntryProxy;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class OTransactionOptimisticProxy
extends OTransactionOptimistic {
    private final Map<ORecordId, ORecord<?>> createdRecords = new HashMap();
    private final Map<ORecordId, ORecord<?>> updatedRecords = new HashMap();
    private final int clientTxId;
    private ODocument remoteIndexEntries = null;
    private final OChannelBinary channel;

    public OTransactionOptimisticProxy(ODatabaseRecordTx iDatabase, OChannelBinary iChannel) throws IOException {
        super(iDatabase);
        this.channel = iChannel;
        this.clientTxId = iChannel.readInt();
    }

    @Override
    public void begin() {
        super.begin();
        try {
            this.setUsingLog(this.channel.readByte() == 1);
            while (this.channel.readByte() == 1) {
                byte recordStatus = this.channel.readByte();
                ORecordId rid = this.channel.readRID();
                OTransactionEntryProxy entry = new OTransactionEntryProxy(this.channel.readByte());
                entry.status = recordStatus;
                switch (entry.status) {
                    case 3: {
                        entry.clusterName = this.channel.readString();
                        entry.getRecord().fill(this.database, rid, 0, this.channel.readBytes(), true);
                        this.createdRecords.put(rid.copy(), entry.getRecord());
                        break;
                    }
                    case 1: {
                        entry.getRecord().fill(this.database, rid, this.channel.readInt(), this.channel.readBytes(), true);
                        this.updatedRecords.put(rid, entry.getRecord());
                        break;
                    }
                    case 2: {
                        entry.getRecord().fill(this.database, rid, this.channel.readInt(), null, false);
                        break;
                    }
                    default: {
                        throw new OTransactionException("Unrecognized tx command: " + entry.status);
                    }
                }
                this.recordEntries.put((ORecordId)entry.getRecord().getIdentity(), entry);
            }
            this.remoteIndexEntries = new ODocument(this.channel.readBytes());
            for (ORecord<?> record : this.createdRecords.values()) {
                this.unmarshallRecord(record);
            }
            for (ORecord<?> record : this.updatedRecords.values()) {
                this.unmarshallRecord(record);
            }
        }
        catch (IOException e) {
            this.rollback();
            throw new OSerializationException("Can't read transaction record from the network. Transaction aborted", e);
        }
    }

    @Override
    public ORecordInternal<?> getRecord(ORID rid) {
        ORecordInternal record = super.getRecord(rid);
        if (record == null && rid.isNew()) {
            record = (ORecordInternal)this.createdRecords.get(rid);
        }
        return record;
    }

    @Override
    public ODocument getIndexChanges() {
        return this.remoteIndexEntries.merge(super.getIndexChanges(), true, true);
    }

    public Map<ORecordId, ORecord<?>> getCreatedRecords() {
        return this.createdRecords;
    }

    public Map<ORecordId, ORecord<?>> getUpdatedRecords() {
        return this.updatedRecords;
    }

    private void unmarshallRecord(ORecord<?> iRecord) {
        if (iRecord instanceof ODocument) {
            ((ODocument)iRecord).deserializeFields();
            for (Map.Entry<String, Object> field : (ODocument)iRecord) {
                if (field.getValue() instanceof ORecordLazyList) {
                    ((ORecordLazyList)field.getValue()).lazyLoad(true);
                    continue;
                }
                if (!(field.getValue() instanceof ORecordLazySet)) continue;
                ((ORecordLazySet)field.getValue()).lazyLoad(true);
            }
        }
    }
}

