/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.client.remote.ORemoteServerEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemoteServiceThread;
import com.orientechnologies.orient.client.remote.OStorageRemoteThread;
import com.orientechnologies.orient.client.remote.OStorageRemoteThreadLocal;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynch;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageRemote
extends OStorageAbstract {
    private static final String DEFAULT_HOST = "localhost";
    private static final String[] DEFAULT_PORTS = new String[]{"2424"};
    private static final String ADDRESS_SEPARATOR = ";";
    public static final String PARAM_MIN_POOL = "minpool";
    public static final String PARAM_MAX_POOL = "maxpool";
    private OStorageRemoteServiceThread serviceThread;
    private OContextConfiguration clientConfiguration;
    private int connectionRetry;
    private int connectionRetryDelay;
    private static List<OChannelBinaryClient> networkPool = new ArrayList<OChannelBinaryClient>();
    protected List<OPair<String, String[]>> serverURLs = new ArrayList<OPair<String, String[]>>();
    protected final Map<String, Integer> clustersIds = new HashMap<String, Integer>();
    protected final Map<String, String> clustersTypes = new HashMap<String, String>();
    protected int defaultClusterId;
    private int networkPoolCursor = 0;
    private int minPool;
    private int maxPool;
    private final boolean debug = false;
    private ODocument clusterConfiguration;
    private final List<ORemoteServerEventListener> remoteServerEventListeners = new ArrayList<ORemoteServerEventListener>();
    private String connectionUserName;
    private String connectionUserPassword;
    private Map<String, Object> connectionOptions;

    public OStorageRemote(String iURL, String iMode) throws IOException {
        super(iURL, iURL, iMode);
        this.configuration = null;
        this.clientConfiguration = new OContextConfiguration();
        this.connectionRetry = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        this.connectionRetryDelay = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY_DELAY);
        this.parseServerURLs();
    }

    public int getSessionId() {
        return ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId;
    }

    public void setSessionId(int iSessionId) {
        ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = iSessionId;
    }

    public List<ORemoteServerEventListener> getRemoteServerEventListeners() {
        return this.remoteServerEventListeners;
    }

    public void addRemoteServerEventListener(ORemoteServerEventListener iListener) {
        this.remoteServerEventListeners.add(iListener);
    }

    public void removeRemoteServerEventListener(ORemoteServerEventListener iListener) {
        this.remoteServerEventListeners.remove(iListener);
    }

    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        this.lock.acquireExclusiveLock();
        this.connectionUserName = iUserName;
        this.connectionUserPassword = iUserPassword;
        this.connectionOptions = iOptions != null ? new HashMap<String, Object>(iOptions) : null;
        try {
            this.openRemoteDatabase();
            this.configuration = new OStorageConfiguration(this);
            this.configuration.load();
        }
        catch (Exception e) {
            if (!OGlobalConfiguration.STORAGE_KEEP_OPEN.getValueAsBoolean()) {
                this.close();
            }
            if (e instanceof OException) {
                throw (OException)e;
            }
            throw new OStorageException("Can't open the remote storage: " + this.name, e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reload() {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)73);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    this.readDatabaseInformation(network);
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on reloading database information", e);
                continue;
            }
            break;
        }
    }

    @Override
    public void create(Map<String, Object> iOptions) {
        throw new UnsupportedOperationException("Can't create a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    @Override
    public boolean exists() {
        throw new UnsupportedOperationException("Can't check the existance of a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean iForce) {
        this.lock.acquireExclusiveLock();
        OChannelBinaryClient network = null;
        try {
            if (networkPool.size() > 0) {
                try {
                    network = this.beginRequest((byte)5);
                }
                finally {
                    this.endRequest(network);
                }
                this.getResponse(network);
            }
            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = -1;
            if (!this.checkForClose(iForce)) {
                return;
            }
            if (this.serviceThread != null) {
                this.serviceThread.sendShutdown();
                this.serviceThread.interrupt();
            }
            List<OChannelBinaryClient> list = networkPool;
            synchronized (list) {
                for (OChannelBinaryClient n : networkPool) {
                    n.close();
                }
                networkPool.clear();
            }
            this.level2Cache.shutdown();
            super.close(iForce);
            this.status = OStorageAbstract.STATUS.CLOSED;
            Orient.instance().unregisterStorage(this);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on closing remote connection: %s", new Object[]{network});
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Can't delete a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getClusterNames() {
        this.lock.acquireSharedLock();
        try {
            this.checkConnection();
            Set<String> set = this.clustersIds.keySet();
            return set;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameCluster(String iOldName, String iNewName) {
        this.lock.acquireSharedLock();
        try {
            this.checkConnection();
            Integer clusterId = this.clustersIds.remove(iOldName);
            this.clustersIds.put(iNewName, clusterId);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long createRecord(ORecordId iRid, byte[] iContent, byte iRecordType) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)31);
                network.writeShort((short)iRid.clusterId);
                network.writeBytes(iContent);
                network.writeByte(iRecordType);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = iRid.clusterPosition = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on create record in cluster: " + iRid.clusterId, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ORawBuffer readRecord(ODatabaseRecord iDatabase, ORecordId iRid, String iFetchPlan) {
        this.checkConnection();
        if (((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting) {
            return null;
        }
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)30);
                    network.writeRID(iRid);
                    network.writeString(iFetchPlan != null ? iFetchPlan : "");
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (network.readByte() == 0) {
                        ORawBuffer oRawBuffer = null;
                        return oRawBuffer;
                    }
                    ORawBuffer buffer = new ORawBuffer(network.readBytes(), network.readInt(), network.readByte());
                    while (network.readByte() == 2) {
                        ORecordInternal record = (ORecordInternal)OStorageRemote.readIdentifiable(network, iDatabase);
                        iDatabase.getLevel1Cache().updateRecord(record);
                    }
                    ORawBuffer oRawBuffer = buffer;
                    return oRawBuffer;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on read record #" + iRid, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)32);
                network.writeRID(iRid);
                network.writeBytes(iContent);
                network.writeInt(iVersion);
                network.writeByte(iRecordType);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                int n = network.readInt();
                this.endResponse(network);
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on update record #" + iRid, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRecord(ORecordId iRid, int iVersion) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)33);
                network.writeRID(iRid);
                network.writeInt(iVersion);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                boolean bl = network.readByte() == 1;
                this.endResponse(network);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on delete record #" + iRid, e);
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public long count(int iClusterId) {
        return this.count(new int[]{iClusterId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getClusterDataRange(int iClusterId) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)13);
                network.writeShort((short)iClusterId);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long[] lArray = new long[]{network.readLong(), network.readLong()};
                this.endResponse(network);
                return lArray;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on getting last entry position count in cluster: " + iClusterId, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)8);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on read database size", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long countRecords() {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)9);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on read database record count", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)12);
                network.writeShort((short)iClusterIds.length);
                for (int i = 0; i < iClusterIds.length; ++i) {
                    network.writeShort((short)iClusterIds[i]);
                }
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on read record count in clusters: " + Arrays.toString(iClusterIds), e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(String iClassName) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)40);
                network.writeString(iClassName);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on executing count on class: " + iClassName, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object command(OCommandRequestText iCommand) {
        this.checkConnection();
        if (!(iCommand instanceof OSerializableStream)) {
            throw new OCommandExecutionException("Can't serialize the command to being executed to the server side.");
        }
        OCommandRequestText command = iCommand;
        ArrayList<OIdentifiable> result = null;
        while (true) {
            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = true;
            OCommandRequestText aquery = iCommand;
            boolean asynch = iCommand instanceof OCommandRequestAsynch;
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)41);
                network.writeByte((byte)(asynch ? 97 : 115));
                network.writeBytes(OStreamSerializerAnyStreamable.INSTANCE.toStream(iCommand.getDatabase(), command));
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                if (asynch) {
                    ORecordSchemaAware record;
                    byte status;
                    block24: while ((status = network.readByte()) > 0 && (record = (ORecordSchemaAware)OStorageRemote.readIdentifiable(network, iCommand.getDatabase())) != null) {
                        switch (status) {
                            case 1: {
                                try {
                                    if (!aquery.getResultListener().result(record)) {
                                        while (network.in.available() > 0) {
                                            network.in.read();
                                        }
                                        continue block24;
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                                iCommand.getDatabase().getLevel1Cache().updateRecord(record);
                                break;
                            }
                            case 2: {
                                iCommand.getDatabase().getLevel1Cache().updateRecord(record);
                            }
                        }
                    }
                } else {
                    byte type = network.readByte();
                    switch (type) {
                        case 110: {
                            result = null;
                            break;
                        }
                        case 114: {
                            result = OStorageRemote.readIdentifiable(network, iCommand.getDatabase());
                            if (!(result instanceof ORecord)) break;
                            iCommand.getDatabase().getLevel1Cache().updateRecord((ORecordInternal)((Object)result));
                            break;
                        }
                        case 108: {
                            int tot = network.readInt();
                            ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                            for (int i = 0; i < tot; ++i) {
                                OIdentifiable resultItem = OStorageRemote.readIdentifiable(network, iCommand.getDatabase());
                                if (resultItem instanceof ORecord) {
                                    iCommand.getDatabase().getLevel1Cache().updateRecord((ORecordInternal)resultItem);
                                }
                                list.add(resultItem);
                            }
                            result = list;
                            break;
                        }
                        case 97: {
                            String value = new String(network.readBytes());
                            result = ORecordSerializerStringAbstract.fieldTypeFromStream(null, ORecordSerializerStringAbstract.getType(value), value);
                        }
                    }
                }
                this.endResponse(network);
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                break;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        this.endResponse(network);
                        throw throwable;
                    }
                    catch (OException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.handleException("Error on executing command: " + iCommand, e);
                        ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                    }
                }
                catch (Throwable throwable2) {
                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                    throw throwable2;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void commit(OTransaction iTx) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)60);
                    network.writeInt(iTx.getId());
                    network.writeByte((byte)(iTx.isUsingLog() ? 1 : 0));
                    ArrayList<OTransactionRecordEntry> tmpEntries = new ArrayList<OTransactionRecordEntry>();
                    while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                        for (OTransactionRecordEntry oTransactionRecordEntry : iTx.getCurrentRecordEntries()) {
                            tmpEntries.add(oTransactionRecordEntry);
                        }
                        iTx.clearRecordEntries();
                        if (tmpEntries.size() <= 0) continue;
                        for (OTransactionRecordEntry oTransactionRecordEntry : tmpEntries) {
                            this.commitEntry(network, oTransactionRecordEntry);
                        }
                    }
                    network.writeByte((byte)0);
                    network.writeBytes(iTx.getIndexChanges().toStream());
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    void var8_25;
                    this.beginResponse(network);
                    int createdRecords = network.readInt();
                    block13: for (int i = 0; i < createdRecords; ++i) {
                        ORecordId oRecordId = network.readRID();
                        ORecordId oRecordId2 = network.readRID();
                        for (OTransactionRecordEntry oTransactionRecordEntry : iTx.getAllRecordEntries()) {
                            if (!oTransactionRecordEntry.getRecord().getIdentity().equals(oRecordId)) continue;
                            oTransactionRecordEntry.getRecord().setIdentity(oRecordId2);
                            continue block13;
                        }
                    }
                    int updatedRecords = network.readInt();
                    boolean bl = false;
                    while (var8_25 < updatedRecords) {
                        ORecordId rid = network.readRID();
                        for (OTransactionRecordEntry oTransactionRecordEntry : iTx.getAllRecordEntries()) {
                            if (!oTransactionRecordEntry.getRecord().getIdentity().equals(rid)) continue;
                            oTransactionRecordEntry.getRecord().setVersion(network.readInt());
                            break;
                        }
                        ++var8_25;
                    }
                }
                finally {
                    this.endResponse(network);
                }
                for (OTransactionRecordEntry oTransactionRecordEntry : iTx.getAllRecordEntries()) {
                    oTransactionRecordEntry.getRecord().unload();
                }
                OTransactionAbstract.updateCacheFromEntries(this, iTx, iTx.getAllRecordEntries(), false);
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on commit", e);
                continue;
            }
            break;
        }
    }

    @Override
    public void rollback(OTransaction iTx) {
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        this.checkConnection();
        if (iClusterName == null) {
            return -1;
        }
        if (Character.isDigit(iClusterName.charAt(0))) {
            return Integer.parseInt(iClusterName);
        }
        Integer id = this.clustersIds.get(iClusterName.toLowerCase());
        if (id == null) {
            return -1;
        }
        return id;
    }

    @Override
    public String getClusterTypeByName(String iClusterName) {
        this.checkConnection();
        if (iClusterName == null) {
            return null;
        }
        return this.clustersTypes.get(iClusterName.toLowerCase());
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iClusterType, Object ... iArguments) {
        this.checkConnection();
        while (true) {
            network = null;
            try {
                network = this.beginRequest((byte)10);
                network.writeString(iClusterType.toString());
                network.writeString(iClusterName);
                switch (1.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE[iClusterType.ordinal()]) {
                    case 1: {
                        network.writeString(iArguments.length > 0 ? (String)iArguments[0] : "").writeInt(iArguments.length > 0 ? (Integer)iArguments[1] : -1);
                        ** break;
lbl15:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        network.writeInt(iArguments.length > 0 ? (Integer)iArguments[0] : -1);
                        break;
                    }
                    ** default:
lbl20:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                clusterId = network.readShort();
                this.clustersIds.put(iClusterName.toLowerCase(), Integer.valueOf(clusterId));
                this.clustersTypes.put(iClusterName.toLowerCase(), iClusterType.toString());
                var6_9 = clusterId;
                this.endResponse(network);
                return var6_9;
            }
            catch (Throwable var7_10) {
                try {
                    this.endResponse(network);
                    throw var7_10;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on add new cluster", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean dropCluster(int iClusterId) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)11);
                    network.writeShort((short)iClusterId);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (network.readByte() == 1) {
                        for (Map.Entry<String, Integer> entry : this.clustersIds.entrySet()) {
                            if (entry.getValue() == null || entry.getValue() != iClusterId) continue;
                            this.clustersIds.remove(entry.getKey());
                            this.clustersTypes.remove(entry.getKey());
                            if (this.configuration.clusters.size() <= iClusterId) break;
                            this.configuration.clusters.set(iClusterId, null);
                            break;
                        }
                        this.getLevel2Cache().freeCluster(iClusterId);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on removing of cluster", e);
                continue;
            }
            break;
        }
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        return this.addDataSegment(iDataSegmentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDataSegment(String iSegmentName, String iSegmentFileName) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)20);
                network.writeString(iSegmentName).writeString(iSegmentFileName);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                short s = network.readShort();
                this.endResponse(network);
                return s;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on add new data segment", e);
                    continue;
                }
            }
            break;
        }
    }

    @Override
    public void synch() {
    }

    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        for (Map.Entry<String, Integer> clusterEntry : this.clustersIds.entrySet()) {
            if (clusterEntry.getValue() != iClusterId) continue;
            return clusterEntry.getKey();
        }
        return null;
    }

    @Override
    public int getClusters() {
        return this.clustersIds.size();
    }

    public Collection<OCluster> getClusterInstances() {
        throw new UnsupportedOperationException("getClusters()");
    }

    @Override
    public OCluster getClusterById(int iId) {
        throw new UnsupportedOperationException("getClusterById()");
    }

    @Override
    public long getVersion() {
        throw new UnsupportedOperationException("getVersion");
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    protected void handleException(String iMessage, Exception iException) {
        int currentRetryDelay;
        int currentMaxRetry;
        if (iException instanceof OException) {
            throw (OException)((Object)iException);
        }
        if (!(iException instanceof IOException)) {
            throw new OStorageException(iMessage, iException);
        }
        if (this.status != OStorageAbstract.STATUS.OPEN) {
            return;
        }
        long lostConnectionTime = System.currentTimeMillis();
        if (this.clusterConfiguration != null) {
            currentMaxRetry = 1;
            currentRetryDelay = 0;
        } else {
            currentMaxRetry = this.connectionRetry;
            currentRetryDelay = this.connectionRetryDelay;
        }
        for (int retry = 0; retry < currentMaxRetry; ++retry) {
            if (currentRetryDelay > 0) {
                try {
                    Thread.sleep(currentRetryDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Retrying to connect to remote server #" + retry + "/" + currentMaxRetry + "...", new Object[0]);
                }
                this.openRemoteDatabase();
                OLogManager.instance().info((Object)this, "Connection re-acquired in transparent way after %dms and %d retries: no errors will be thrown at application level", new Object[]{System.currentTimeMillis() - lostConnectionTime, retry + 1});
                return;
            }
            catch (Throwable t) {
                if (this.clusterConfiguration == null) continue;
            }
        }
        throw new OStorageException(iMessage, iException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openRemoteDatabase() throws IOException {
        int sessionId;
        this.minPool = OGlobalConfiguration.CLIENT_CHANNEL_MIN_POOL.getValueAsInteger();
        this.maxPool = OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger();
        if (this.connectionOptions != null && this.connectionOptions.size() > 0) {
            if (this.connectionOptions.containsKey(PARAM_MIN_POOL)) {
                this.minPool = Integer.parseInt(this.connectionOptions.get(PARAM_MIN_POOL).toString());
            }
            if (this.connectionOptions.containsKey(PARAM_MAX_POOL)) {
                this.maxPool = Integer.parseInt(this.connectionOptions.get(PARAM_MAX_POOL).toString());
            }
        }
        this.setSessionId(-1);
        this.createConnectionPool();
        OChannelBinaryClient network = null;
        try {
            network = this.beginRequest((byte)3);
            network.writeString(this.name).writeString(this.connectionUserName).writeString(this.connectionUserPassword);
        }
        finally {
            this.endRequest(network);
        }
        try {
            this.beginResponse(network);
            sessionId = network.readInt();
            OLogManager.instance().debug(null, "Client connected with session id: " + sessionId, new Object[0]);
            this.readDatabaseInformation(network);
            this.clusterConfiguration = new ODocument(network.readBytes());
        }
        finally {
            this.endResponse(network);
        }
        this.setSessionId(sessionId);
        this.defaultClusterId = this.clustersIds.get("default");
        this.status = OStorageAbstract.STATUS.OPEN;
    }

    protected void parseServerURLs() {
        int dbPos = this.url.indexOf(47);
        if (dbPos == -1) {
            this.name = this.url;
            String remoteHost = this.getDefaultHost();
            String[] remotePorts = this.getDefaultPort();
        } else {
            this.name = this.url.substring(dbPos + 1);
            int startPos = 0;
            int endPos = 0;
            while (endPos < dbPos) {
                String[] remotePorts;
                String remoteHost;
                endPos = this.url.indexOf(ADDRESS_SEPARATOR, startPos) > -1 ? this.url.indexOf(ADDRESS_SEPARATOR, startPos) : dbPos;
                int posRemotePort = this.url.indexOf(58, startPos);
                if (posRemotePort != -1 && posRemotePort < endPos) {
                    remoteHost = this.url.substring(startPos, posRemotePort);
                    remotePorts = this.url.substring(posRemotePort + 1, endPos).split("_");
                    startPos = endPos + 1;
                } else {
                    remoteHost = this.url.substring(startPos, endPos);
                    remotePorts = this.getDefaultPort();
                    startPos = endPos + 1;
                }
                this.serverURLs.add((OPair<String, String[]>)new OPair((Comparable)((Object)remoteHost), (Object)remotePorts));
            }
        }
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    protected String[] getDefaultPort() {
        return DEFAULT_PORTS;
    }

    protected OChannelBinaryClient createNetworkConnection() throws IOException, UnknownHostException {
        Iterator<OPair<String, String[]>> i$ = this.serverURLs.iterator();
        if (i$.hasNext()) {
            OPair<String, String[]> server = i$.next();
            int port = Integer.parseInt(((String[])server.getValue())[((String[])server.getValue()).length - 1]);
            OLogManager.instance().debug((Object)this, "Trying to connect to the remote host %s:%d...", new Object[]{server.getKey(), port});
            OChannelBinaryClient network = new OChannelBinaryClient((String)((Object)server.getKey()), port, this.clientConfiguration);
            OChannelBinaryProtocol.checkProtocolVersion(network);
            return network;
        }
        StringBuilder buffer = new StringBuilder();
        for (OPair<String, String[]> server : this.serverURLs) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append((String)((Object)server.getKey()));
        }
        throw new OIOException("Can't connect to any configured remote nodes: " + buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnection() {
        this.lock.acquireSharedLock();
        try {
            List<OChannelBinaryClient> list = networkPool;
            synchronized (list) {
                if (networkPool.size() == 0) {
                    throw new ODatabaseException("Connection is closed");
                }
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    static OIdentifiable readIdentifiable(OChannelBinaryClient network, ODatabaseRecord iDatabase) throws IOException {
        short classId = network.readShort();
        if (classId == -2) {
            return null;
        }
        if (classId == -3) {
            return network.readRID();
        }
        ORecordInternal<?> record = Orient.instance().getRecordFactoryManager().newInstance(iDatabase, network.readByte());
        if (record instanceof ORecordSchemaAware) {
            ((ORecordSchemaAware)record).fill(iDatabase, classId, network.readRID(), network.readInt(), network.readBytes(), false);
        } else {
            record.fill(iDatabase, network.readRID(), network.readInt(), network.readBytes(), false);
        }
        return record;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OChannelBinaryClient beginRequest(byte iCommand) throws IOException {
        OChannelBinary network = null;
        List<OChannelBinaryClient> list = networkPool;
        synchronized (list) {
            int beginCursor = this.networkPoolCursor;
            while (network == null) {
                if (networkPool.size() == 0) {
                    throw new ONetworkProtocolException("Connection pool closed");
                }
                network = networkPool.get(this.networkPoolCursor);
                if (((OChannelBinaryAsynch)network).getLockWrite().tryLock()) break;
                network = null;
                ++this.networkPoolCursor;
                if (this.networkPoolCursor >= networkPool.size()) {
                    this.networkPoolCursor = 0;
                }
                if (this.networkPoolCursor != beginCursor) continue;
                if (networkPool.size() < this.maxPool) {
                    network = this.createNetworkConnection();
                    ((OChannelBinaryAsynch)network).getLockWrite().lock();
                    networkPool.add((OChannelBinaryClient)network);
                    continue;
                }
                long startToWait = System.currentTimeMillis();
                try {
                    networkPool.wait(5000L);
                }
                catch (InterruptedException e) {
                    OProfiler.getInstance().updateCounter("network.connectionPool.timeout", 1L);
                }
                long elapsed = OProfiler.getInstance().stopChrono("network.connectionPool.waitingTime", startToWait);
            }
        }
        network.writeByte(iCommand);
        network.writeInt(this.getSessionId());
        return network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequest(OChannelBinaryClient iNetwork) throws IOException {
        if (iNetwork == null) {
            return;
        }
        try {
            iNetwork.flush();
        }
        finally {
            iNetwork.getLockWrite().unlock();
            List<OChannelBinaryClient> list = networkPool;
            synchronized (list) {
                networkPool.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeChannel(OChannelBinaryClient iNetwork) {
        iNetwork.close();
        List<OChannelBinaryClient> list = networkPool;
        synchronized (list) {
            networkPool.remove((Object)iNetwork);
        }
    }

    protected void beginResponse(OChannelBinaryClient iNetwork) throws IOException {
        iNetwork.beginResponse(this.getSessionId());
    }

    public void endResponse(OChannelBinaryClient iNetwork) {
        iNetwork.endResponse();
    }

    public boolean isPermanentRequester() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getResponse(OChannelBinaryClient iNetwork) throws IOException {
        try {
            this.beginResponse(iNetwork);
        }
        finally {
            this.endResponse(iNetwork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterConfiguration(byte[] iContent) {
        if (iContent == null) {
            return;
        }
        ODocument oDocument = this.clusterConfiguration;
        synchronized (oDocument) {
            this.clusterConfiguration.reset();
            this.clusterConfiguration.fromStream(iContent);
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Received new cluster configuration: %s", new Object[]{this.clusterConfiguration.toJSON("")});
            }
        }
    }

    private void commitEntry(OChannelBinaryClient iNetwork, OTransactionRecordEntry txEntry) throws IOException {
        if (txEntry.status == 0) {
            return;
        }
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.status);
        iNetwork.writeShort((short)txEntry.getRecord().getIdentity().getClusterId());
        iNetwork.writeLong(txEntry.getRecord().getIdentity().getClusterPosition());
        iNetwork.writeByte(txEntry.getRecord().getRecordType());
        switch (txEntry.status) {
            case 3: {
                iNetwork.writeString(txEntry.clusterName);
                iNetwork.writeBytes(txEntry.getRecord().toStream());
                break;
            }
            case 1: {
                iNetwork.writeInt(txEntry.getRecord().getVersion());
                iNetwork.writeBytes(txEntry.getRecord().toStream());
                break;
            }
            case 2: {
                iNetwork.writeInt(txEntry.getRecord().getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConnectionPool() throws IOException, UnknownHostException {
        List<OChannelBinaryClient> list = networkPool;
        synchronized (list) {
            if (!networkPool.isEmpty()) {
                ArrayList<OChannelBinaryClient> editableList = new ArrayList<OChannelBinaryClient>(networkPool);
                for (OChannelBinaryClient net : editableList) {
                    if (net.isConnected()) continue;
                    this.closeChannel(net);
                }
            }
            if (networkPool.size() == 0) {
                OChannelBinaryClient firstChannel = this.createNetworkConnection();
                networkPool.add(firstChannel);
                this.serviceThread = new OStorageRemoteServiceThread(new OStorageRemoteThread(this, Integer.MIN_VALUE), firstChannel);
                for (int i = 1; i < this.minPool; ++i) {
                    networkPool.add(this.createNetworkConnection());
                }
            }
        }
    }

    private void readDatabaseInformation(OChannelBinaryClient network) throws IOException {
        int tot = network.readInt();
        this.clustersIds.clear();
        this.clustersTypes.clear();
        for (int i = 0; i < tot; ++i) {
            String clusterName = network.readString().toLowerCase();
            this.clustersIds.put(clusterName, network.readInt());
            this.clustersTypes.put(clusterName, network.readString());
        }
        this.defaultClusterId = this.clustersIds.get("default");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE;

        static {
            $SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE = new int[OStorage.CLUSTER_TYPE.values().length];
            try {
                1.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE[OStorage.CLUSTER_TYPE.PHYSICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE[OStorage.CLUSTER_TYPE.LOGICAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

