/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.client.remote.ORemoteServerEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageRemoteThread
implements OStorage {
    private static AtomicInteger sessionSerialId = new AtomicInteger(-1);
    private final OStorageRemote delegate;
    private int sessionId;

    public OStorageRemoteThread(OStorageRemote iSharedStorage) {
        this.delegate = iSharedStorage;
        this.sessionId = sessionSerialId.decrementAndGet();
    }

    public OStorageRemoteThread(OStorageRemote iSharedStorage, int iSessionId) {
        this.delegate = iSharedStorage;
        this.sessionId = iSessionId;
    }

    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.open(iUserName, iUserPassword, iOptions);
        this.sessionId = this.delegate.getSessionId();
    }

    @Override
    public void create(Map<String, Object> iOptions) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.create(iOptions);
        this.sessionId = this.delegate.getSessionId();
    }

    @Override
    public void close(boolean iForce) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.close(iForce);
        Orient.instance().unregisterStorage(this);
    }

    @Override
    public boolean dropCluster(String iClusterName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.dropCluster(iClusterName);
    }

    @Override
    public int getUsers() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getUsers();
    }

    @Override
    public int addUser() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addUser();
    }

    public OSharedResourceAdaptive getLock() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getLock();
    }

    public void setSessionId(int iSessionId) {
        this.sessionId = iSessionId;
        this.delegate.setSessionId(iSessionId);
    }

    @Override
    public void reload() {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.reload();
    }

    @Override
    public boolean exists() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.exists();
    }

    @Override
    public int removeUser() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.removeUser();
    }

    @Override
    public void close() {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.close();
        Orient.instance().unregisterStorage(this);
    }

    @Override
    public void delete() {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.delete();
        Orient.instance().unregisterStorage(this);
    }

    @Override
    public Set<String> getClusterNames() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterNames();
    }

    @Override
    public long createRecord(ORecordId iRid, byte[] iContent, byte iRecordType) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.createRecord(iRid, iContent, iRecordType);
    }

    @Override
    public ORawBuffer readRecord(ODatabaseRecord iDatabase, ORecordId iRid, String iFetchPlan) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.readRecord(iDatabase, iRid, iFetchPlan);
    }

    @Override
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.updateRecord(iRid, iContent, iVersion, iRecordType);
    }

    public String toString() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.toString();
    }

    @Override
    public boolean deleteRecord(ORecordId iRid, int iVersion) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.deleteRecord(iRid, iVersion);
    }

    @Override
    public long count(int iClusterId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.count(iClusterId);
    }

    @Override
    public long[] getClusterDataRange(int iClusterId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterDataRange(iClusterId);
    }

    @Override
    public long getSize() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getSize();
    }

    @Override
    public long countRecords() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.countRecords();
    }

    @Override
    public long count(int[] iClusterIds) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.count(iClusterIds);
    }

    public long count(String iClassName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.count(iClassName);
    }

    @Override
    public Object command(OCommandRequestText iCommand) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.command(iCommand);
    }

    @Override
    public void commit(OTransaction iTx) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.commit(iTx);
    }

    @Override
    public void rollback(OTransaction iTx) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.rollback(iTx);
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterIdByName(iClusterName);
    }

    @Override
    public String getClusterTypeByName(String iClusterName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterTypeByName(iClusterName);
    }

    @Override
    public int getDefaultClusterId() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getDefaultClusterId();
    }

    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iClusterType, Object ... iArguments) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addCluster(iClusterName, iClusterType, iArguments);
    }

    @Override
    public boolean dropCluster(int iClusterId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.dropCluster(iClusterId);
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addDataSegment(iDataSegmentName);
    }

    @Override
    public int addDataSegment(String iSegmentName, String iSegmentFileName) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.addDataSegment(iSegmentName, iSegmentFileName);
    }

    @Override
    public void synch() {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.synch();
    }

    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getPhysicalClusterNameById(iClusterId);
    }

    @Override
    public int getClusters() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusters();
    }

    public Collection<OCluster> getClusterInstances() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterInstances();
    }

    @Override
    public OCluster getClusterById(int iId) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getClusterById(iId);
    }

    @Override
    public void renameCluster(String iOldName, String iNewName) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.renameCluster(iOldName, iNewName);
    }

    @Override
    public long getVersion() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getVersion();
    }

    public boolean isPermanentRequester() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.isPermanentRequester();
    }

    public void updateClusterConfiguration(byte[] iContent) {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.updateClusterConfiguration(iContent);
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getConfiguration();
    }

    @Override
    public boolean isClosed() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.isClosed();
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.checkForRecordValidity(ppos);
    }

    @Override
    public String getName() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getName();
    }

    @Override
    public String getURL() {
        this.delegate.setSessionId(this.sessionId);
        return this.delegate.getURL();
    }

    public void beginResponse(OChannelBinaryClient iNetwork) throws IOException {
        this.delegate.setSessionId(this.sessionId);
        this.delegate.beginResponse(iNetwork);
    }

    @Override
    public OLevel2RecordCache getLevel2Cache() {
        return this.delegate.getLevel2Cache();
    }

    public boolean existsResource(String iName) {
        return this.delegate.existsResource(iName);
    }

    public synchronized <T> T getResource(String iName, Callable<T> iCallback) {
        return (T)this.delegate.getResource(iName, iCallback);
    }

    public <T> T removeResource(String iName) {
        return (T)this.delegate.removeResource(iName);
    }

    public ODocument getClusterConfiguration() {
        return this.delegate.getClusterConfiguration();
    }

    public List<ORemoteServerEventListener> getRemoteServerEventListeners() {
        return this.delegate.getRemoteServerEventListeners();
    }

    public void addRemoteServerEventListener(ORemoteServerEventListener iListener) {
        this.delegate.addRemoteServerEventListener(iListener);
    }

    public void removeRemoteServerEventListener(ORemoteServerEventListener iListener) {
        this.delegate.removeRemoteServerEventListener(iListener);
    }

    public void closeChannel(OChannelBinaryClient network) {
        this.delegate.closeChannel(network);
    }

    protected void handleException(String iMessage, Exception iException) {
        this.delegate.handleException(iMessage, iException);
    }
}

