/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection;

import com.orientechnologies.common.collection.OMVRBTree;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OMVRBTreeEntry<K, V>
implements Map.Entry<K, V>,
Comparable<OMVRBTreeEntry<K, V>> {
    protected OMVRBTree<K, V> tree;
    protected int size = 1;
    protected int pageSize;
    protected K[] keys;
    protected V[] values;
    protected boolean color = false;
    private int pageSplitItems;
    public static final int BINARY_SEARCH_THRESHOLD = 10;

    protected OMVRBTreeEntry(OMVRBTree<K, V> iTree) {
        this.tree = iTree;
        this.init();
    }

    protected OMVRBTreeEntry(OMVRBTree<K, V> iTree, K iKey, V iValue, OMVRBTreeEntry<K, V> iParent) {
        this.tree = iTree;
        this.setParent(iParent);
        this.pageSize = this.tree.getPageSize();
        this.keys = new Object[this.pageSize];
        this.keys[0] = iKey;
        this.values = new Object[this.pageSize];
        this.values[0] = iValue;
        this.init();
    }

    protected OMVRBTreeEntry(OMVRBTreeEntry<K, V> iParent, int iPosition) {
        this.tree = iParent.tree;
        this.pageSize = this.tree.getPageSize();
        this.keys = new Object[this.pageSize];
        this.values = new Object[this.pageSize];
        this.size = iParent.size - iPosition;
        System.arraycopy(iParent.keys, iPosition, this.keys, 0, this.size);
        System.arraycopy(iParent.values, iPosition, this.values, 0, this.size);
        Arrays.fill(iParent.keys, iPosition, iParent.size, null);
        Arrays.fill(iParent.values, iPosition, iParent.size, null);
        iParent.size = iPosition;
        this.init();
    }

    public abstract void setLeft(OMVRBTreeEntry<K, V> var1);

    public abstract OMVRBTreeEntry<K, V> getLeft();

    public abstract OMVRBTreeEntry<K, V> setRight(OMVRBTreeEntry<K, V> var1);

    public abstract OMVRBTreeEntry<K, V> getRight();

    public abstract OMVRBTreeEntry<K, V> setParent(OMVRBTreeEntry<K, V> var1);

    public abstract OMVRBTreeEntry<K, V> getParent();

    protected abstract OMVRBTreeEntry<K, V> getLeftInMemory();

    protected abstract OMVRBTreeEntry<K, V> getParentInMemory();

    protected abstract OMVRBTreeEntry<K, V> getRightInMemory();

    protected abstract OMVRBTreeEntry<K, V> getNextInMemory();

    public OMVRBTreeEntry<K, V> getFirstInMemory() {
        OMVRBTreeEntry<K, V> prev = this;
        for (OMVRBTreeEntry<K, V> node = this; node != null; node = node.getPreviousInMemory()) {
            prev = node;
        }
        return prev;
    }

    public OMVRBTreeEntry<K, V> getPreviousInMemory() {
        OMVRBTreeEntry<K, V> t = this;
        OMVRBTreeEntry<K, V> p = null;
        if (t.getLeftInMemory() != null) {
            p = t.getLeftInMemory();
            while (p.getRightInMemory() != null) {
                p = p.getRightInMemory();
            }
        } else {
            for (p = t.getParentInMemory(); p != null && t == p.getLeftInMemory(); p = p.getParentInMemory()) {
                t = p;
            }
        }
        return p;
    }

    protected OMVRBTree<K, V> getTree() {
        return this.tree;
    }

    public int getDepth() {
        int level = 0;
        OMVRBTreeEntry<K, V> entry = this;
        while (entry.getParent() != null) {
            ++level;
            entry = entry.getParent();
        }
        return level;
    }

    @Override
    public K getKey() {
        return this.getKey(this.tree.pageIndex);
    }

    public K getKey(int iIndex) {
        if (iIndex >= this.size) {
            throw new IndexOutOfBoundsException("Requested index " + iIndex + " when the range is 0-" + this.size);
        }
        this.tree.pageIndex = iIndex;
        return this.getKeyAt(iIndex);
    }

    protected K getKeyAt(int iIndex) {
        return this.keys[iIndex];
    }

    @Override
    public V getValue() {
        if (this.tree.pageIndex == -1) {
            return this.getValueAt(0);
        }
        return this.getValueAt(this.tree.pageIndex);
    }

    public V getValue(int iIndex) {
        this.tree.pageIndex = iIndex;
        return this.getValueAt(iIndex);
    }

    protected V getValueAt(int iIndex) {
        return this.values[iIndex];
    }

    @Override
    public V setValue(V value) {
        V oldValue = this.getValue();
        this.values[this.tree.pageIndex] = value;
        return oldValue;
    }

    public int getFreeSpace() {
        return this.pageSize - this.size;
    }

    public String toString() {
        if (this.keys == null) {
            return "?";
        }
        StringBuilder buffer = new StringBuilder();
        Character k = this.tree.pageIndex >= this.size ? Character.valueOf('?') : this.getKey();
        buffer.append(k);
        buffer.append(" (size=");
        buffer.append(this.size);
        if (this.size > 0) {
            buffer.append(" [");
            buffer.append(this.keys[0] != null ? this.keys[0] : "{lazy}");
            buffer.append('-');
            buffer.append(this.keys[this.size - 1] != null ? this.keys[this.size - 1] : "{lazy}");
            buffer.append(']');
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected V search(Comparable<? super K> iKey) {
        this.tree.pageItemFound = false;
        if (this.size == 0) {
            return null;
        }
        this.tree.pageItemComparator = this.tree.comparator != null ? this.tree.comparator.compare(iKey, this.getKeyAt(0)) : iKey.compareTo(this.getKeyAt(0));
        if (this.tree.pageItemComparator == 0) {
            this.tree.pageItemFound = true;
            this.tree.pageIndex = 0;
            return this.getValueAt(this.tree.pageIndex);
        }
        if (this.tree.pageItemComparator < 0) {
            this.tree.pageIndex = 0;
            return null;
        }
        this.tree.pageItemComparator = this.tree.comparator != null ? this.tree.comparator.compare(iKey, this.getKeyAt(this.size - 1)) : iKey.compareTo(this.getKeyAt(this.size - 1));
        if (this.tree.pageItemComparator > 0) {
            this.tree.pageIndex = this.size;
            return null;
        }
        if (this.size < 10) {
            return this.linearSearch(iKey);
        }
        return this.binarySearch(iKey);
    }

    private V linearSearch(Comparable<? super K> iKey) {
        int i;
        V value = null;
        this.tree.pageItemComparator = -1;
        for (i = 0; i < this.size; ++i) {
            this.tree.pageItemComparator = this.tree.comparator != null ? this.tree.comparator.compare(this.getKeyAt(i), iKey) : ((Comparable)this.getKeyAt(i)).compareTo(iKey);
            if (this.tree.pageItemComparator == 0) {
                this.tree.pageItemFound = true;
                value = this.getValueAt(i);
                break;
            }
            if (this.tree.pageItemComparator > 0) break;
        }
        this.tree.pageIndex = i;
        return value;
    }

    private V binarySearch(Comparable<? super K> iKey) {
        int low = 0;
        int high = this.size - 1;
        int mid = 0;
        while (low <= high) {
            mid = low + high >>> 1;
            Comparable midVal = (Comparable)this.getKeyAt(mid);
            this.tree.pageItemComparator = this.tree.comparator != null ? this.tree.comparator.compare(midVal, iKey) : midVal.compareTo(iKey);
            if (this.tree.pageItemComparator == 0) {
                this.tree.pageItemFound = true;
                this.tree.pageIndex = mid;
                return this.getValueAt(this.tree.pageIndex);
            }
            if (low == high) break;
            if (this.tree.pageItemComparator < 0) {
                low = mid + 1;
                continue;
            }
            high = mid;
        }
        this.tree.pageIndex = mid;
        return null;
    }

    protected void insert(int iPosition, K key, V value) {
        if (iPosition < this.size) {
            System.arraycopy(this.keys, iPosition, this.keys, iPosition + 1, this.size - iPosition);
            System.arraycopy(this.values, iPosition, this.values, iPosition + 1, this.size - iPosition);
        }
        this.keys[iPosition] = key;
        this.values[iPosition] = value;
        ++this.size;
    }

    protected void remove() {
        if (this.tree.pageIndex != this.size - 1 && this.tree.pageIndex > -1) {
            System.arraycopy(this.keys, this.tree.pageIndex + 1, this.keys, this.tree.pageIndex, this.size - this.tree.pageIndex - 1);
            System.arraycopy(this.values, this.tree.pageIndex + 1, this.values, this.tree.pageIndex, this.size - this.tree.pageIndex - 1);
        }
        this.keys[this.size - 1] = null;
        this.values[this.size - 1] = null;
        --this.size;
        this.tree.pageIndex = 0;
    }

    protected void setColor(boolean iColor) {
        this.color = iColor;
    }

    public boolean getColor() {
        return this.color;
    }

    public int getSize() {
        return this.size;
    }

    public K getLastKey() {
        return this.getKey(this.size - 1);
    }

    public K getFirstKey() {
        return this.getKey(0);
    }

    protected void copyFrom(OMVRBTreeEntry<K, V> iSource) {
        int i;
        this.keys = new Object[iSource.keys.length];
        for (i = 0; i < iSource.keys.length; ++i) {
            this.keys[i] = iSource.keys[i];
        }
        this.values = new Object[iSource.values.length];
        for (i = 0; i < iSource.values.length; ++i) {
            this.values[i] = iSource.values[i];
        }
        this.size = iSource.size;
    }

    public int getPageSplitItems() {
        return this.pageSplitItems;
    }

    protected void init() {
        this.pageSplitItems = (int)((float)this.pageSize * this.tree.pageLoadFactor);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public int compareTo(OMVRBTreeEntry<K, V> o) {
        if (o == null) {
            return 1;
        }
        if (o == this) {
            return 0;
        }
        if (this.size == 0) {
            return -1;
        }
        if (o.size == 0) {
            return 1;
        }
        return ((Comparable)this.getFirstKey()).compareTo(o.getFirstKey());
    }
}

