/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OSharedResourceAdaptive {
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private AtomicInteger users = new AtomicInteger(0);
    private final boolean concurrent;

    public OSharedResourceAdaptive(boolean iConcurrent) {
        this.concurrent = iConcurrent;
    }

    protected void acquireExclusiveLock() {
        if (this.concurrent) {
            this.lock.writeLock().lock();
        }
    }

    protected void acquireSharedLock() {
        if (this.concurrent) {
            this.lock.readLock().lock();
        }
    }

    protected void releaseExclusiveLock() {
        if (this.concurrent) {
            this.lock.writeLock().unlock();
        }
    }

    protected void releaseSharedLock() {
        if (this.concurrent) {
            this.lock.readLock().unlock();
        }
    }

    public int getUsers() {
        return this.users.get();
    }

    public int addUser() {
        return this.users.incrementAndGet();
    }

    public int removeUser() {
        if (this.users.get() < 1) {
            throw new IllegalStateException("Can't remove user of the shared resource " + this.toString() + " because no user is using it");
        }
        return this.users.decrementAndGet();
    }

    public boolean isConcurrent() {
        return this.concurrent;
    }
}

