/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.io;

import java.io.File;

public class OFileUtils {
    private static final int KILOBYTE = 1024;
    private static final int MEGABYTE = 0x100000;
    private static final int GIGABYTE = 0x40000000;
    private static final long TERABYTE = 0x10000000000L;

    public static long getSizeAsNumber(Object iSize) {
        if (iSize == null) {
            throw new IllegalArgumentException("Size is null");
        }
        if (iSize instanceof Number) {
            return ((Number)iSize).longValue();
        }
        String size = iSize.toString();
        boolean number = true;
        for (int i = size.length() - 1; i >= 0; --i) {
            if (Character.isDigit(size.charAt(i))) continue;
            number = false;
            break;
        }
        if (number) {
            return Long.parseLong(size);
        }
        int pos = (size = size.toUpperCase()).indexOf("KB");
        if (pos > -1) {
            return Long.parseLong(size.substring(0, pos)) * 1024L;
        }
        pos = size.indexOf("MB");
        if (pos > -1) {
            return Long.parseLong(size.substring(0, pos)) * 0x100000L;
        }
        pos = size.indexOf("GB");
        if (pos > -1) {
            return Long.parseLong(size.substring(0, pos)) * 0x40000000L;
        }
        pos = size.indexOf("TB");
        if (pos > -1) {
            return Long.parseLong(size.substring(0, pos)) * 0x10000000000L;
        }
        pos = size.indexOf(66);
        if (pos > -1) {
            return Long.parseLong(size.substring(0, pos));
        }
        pos = size.indexOf(37);
        if (pos > -1) {
            return -1L * Long.parseLong(size.substring(0, pos));
        }
        throw new IllegalArgumentException("Size " + size + " has a unrecognizable format");
    }

    public static String getSizeAsString(long iSize) {
        if (iSize > 0x10000000000L) {
            return String.format("%2.2fTb", Float.valueOf((float)iSize / 1.0995116E12f));
        }
        if (iSize > 0x40000000L) {
            return String.format("%2.2fGb", Float.valueOf((float)iSize / 1.0737418E9f));
        }
        if (iSize > 0x100000L) {
            return String.format("%2.2fMb", Float.valueOf((float)iSize / 1048576.0f));
        }
        if (iSize > 1024L) {
            return String.format("%2.2fKb", Float.valueOf((float)iSize / 1024.0f));
        }
        return String.valueOf(iSize) + "b";
    }

    public static String getDirectory(String iPath) {
        int pos = (iPath = OFileUtils.getPath(iPath)).lastIndexOf("/");
        if (pos == -1) {
            return "";
        }
        return iPath.substring(0, pos);
    }

    public static void createDirectoryTree(String iFileName) {
        String[] fileDirectories = iFileName.split("/");
        for (int i = 0; i < fileDirectories.length - 1; ++i) {
            new File(fileDirectories[i]).mkdir();
        }
    }

    public static String getPath(String iPath) {
        if (iPath == null) {
            return null;
        }
        return iPath.replace('\\', '/');
    }
}

