/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.log;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogFormatter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OLogManager {
    private boolean debug = true;
    private boolean info = true;
    private boolean warn = true;
    private boolean error = true;
    private Level minimumLevel = Level.SEVERE;
    private static final OLogManager instance = new OLogManager();
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSS");

    protected OLogManager() {
    }

    public void setConsoleLevel(String iLevel) {
        this.setLevel(iLevel, ConsoleHandler.class);
    }

    public void setFileLevel(String iLevel) {
        this.setLevel(iLevel, FileHandler.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String log(Object iRequester, Level iLevel, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        Logger log;
        if (iMessage == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append('\n');
        DateFormat dateFormat = OLogManager.dateFormat;
        synchronized (dateFormat) {
            buffer.append(OLogManager.dateFormat.format(new Date()));
        }
        buffer.append(' ');
        buffer.append(iLevel.getName().substring(0, 4));
        if (iRequester != null) {
            buffer.append(" [");
            buffer.append(iRequester.getClass().getSimpleName());
            buffer.append(']');
        }
        buffer.append(' ');
        try {
            buffer.append(String.format(iMessage, iAdditionalArgs));
        }
        catch (Exception e) {
            buffer.append(iMessage);
        }
        Logger logger = log = iRequester != null ? Logger.getLogger(iRequester.getClass().getName()) : Logger.getLogger("");
        if (log.isLoggable(iLevel)) {
            if (iException != null) {
                log.log(iLevel, buffer.toString(), iException);
            } else {
                log.log(iLevel, buffer.toString());
            }
        }
        return buffer.toString();
    }

    public void debug(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isDebugEnabled()) {
            this.log(iRequester, Level.FINE, iMessage, null, iAdditionalArgs);
        }
    }

    public void debug(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isDebugEnabled()) {
            this.log(iRequester, Level.FINE, iMessage, iException, iAdditionalArgs);
        }
    }

    public void debug(Object iRequester, String iMessage, Throwable iException, Class<? extends OException> iExceptionClass, Object ... iAdditionalArgs) {
        this.debug(iRequester, iMessage, iException, iAdditionalArgs);
        try {
            throw iExceptionClass.getConstructor(String.class, Throwable.class).newInstance(iMessage, iException);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (SecurityException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void info(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isInfoEnabled()) {
            this.log(iRequester, Level.INFO, iMessage, null, iAdditionalArgs);
        }
    }

    public String info(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isInfoEnabled()) {
            return this.log(iRequester, Level.INFO, iMessage, iException, iAdditionalArgs);
        }
        return null;
    }

    public String warn(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        if (this.isWarnEnabled()) {
            return this.log(iRequester, Level.WARNING, iMessage, null, iAdditionalArgs);
        }
        return null;
    }

    public String warn(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isWarnEnabled()) {
            return this.log(iRequester, Level.WARNING, iMessage, iException, iAdditionalArgs);
        }
        return null;
    }

    public String error(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        return this.log(iRequester, Level.SEVERE, iMessage, null, iAdditionalArgs);
    }

    public String error(Object iRequester, String iMessage, Throwable iException, Object ... iAdditionalArgs) {
        if (this.isErrorEnabled()) {
            return this.log(iRequester, Level.SEVERE, iMessage, iException, iAdditionalArgs);
        }
        return null;
    }

    public String config(Object iRequester, String iMessage, Object ... iAdditionalArgs) {
        return this.log(iRequester, Level.CONFIG, iMessage, null, iAdditionalArgs);
    }

    public void error(Object iRequester, String iMessage, Throwable iException, Class<? extends OException> iExceptionClass, Object ... iAdditionalArgs) {
        String msg = this.error(iRequester, iMessage, iException, iAdditionalArgs);
        try {
            throw iExceptionClass.getConstructor(String.class, Throwable.class).newInstance(msg, iException);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (SecurityException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
    }

    public void error(Object iRequester, String iMessage, Class<? extends OException> iExceptionClass) {
        this.error(iRequester, iMessage, (Throwable)null, new Object[0]);
        try {
            throw iExceptionClass.getConstructor(String.class).newInstance(iMessage);
        }
        catch (IllegalArgumentException e) {
        }
        catch (SecurityException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
    }

    public void exception(String iMessage, Exception iNestedException, Class<? extends OException> iExceptionClass, Object ... iAdditionalArgs) throws OException {
        Constructor<? extends OException> c;
        if (iMessage == null) {
            return;
        }
        String msg = String.format(iMessage, iAdditionalArgs);
        OException exceptionToThrow = null;
        try {
            if (iNestedException != null) {
                c = iExceptionClass.getConstructor(String.class, Throwable.class);
                exceptionToThrow = c.newInstance(msg, iNestedException);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (exceptionToThrow == null) {
            try {
                c = iExceptionClass.getConstructor(String.class);
                exceptionToThrow = c.newInstance(msg);
            }
            catch (SecurityException e1) {
            }
            catch (NoSuchMethodException e1) {
            }
            catch (IllegalArgumentException e1) {
            }
            catch (InstantiationException e1) {
            }
            catch (IllegalAccessException e1) {
            }
            catch (InvocationTargetException e1) {
                // empty catch block
            }
        }
        if (exceptionToThrow != null) {
            throw exceptionToThrow;
        }
        throw new IllegalArgumentException("Can't create the exception of type: " + iExceptionClass);
    }

    public boolean isWarn() {
        return this.warn;
    }

    public void setWarnEnabled(boolean warn) {
        this.warn = warn;
    }

    public void setInfoEnabled(boolean info) {
        this.info = info;
    }

    public void setDebugEnabled(boolean debug) {
        this.debug = debug;
    }

    public void setErrorEnabled(boolean error) {
        this.error = error;
    }

    public boolean isDebugEnabled() {
        return this.debug;
    }

    public boolean isInfoEnabled() {
        return this.info;
    }

    public boolean isWarnEnabled() {
        return this.warn;
    }

    public boolean isErrorEnabled() {
        return this.error;
    }

    public static OLogManager instance() {
        return instance;
    }

    public Level setLevel(String iLevel, Class<? extends Handler> iHandler) {
        Level level;
        Level level2 = level = iLevel != null ? Level.parse(iLevel.toUpperCase()) : Level.INFO;
        if (level.intValue() < this.minimumLevel.intValue()) {
            this.minimumLevel = level;
            if (level.equals(Level.FINER) || level.equals(Level.FINE) || level.equals(Level.FINEST)) {
                this.error = true;
                this.warn = true;
                this.info = true;
                this.debug = true;
            } else if (level.equals(Level.INFO)) {
                this.error = true;
                this.warn = true;
                this.info = true;
                this.debug = false;
            } else if (level.equals(Level.WARNING)) {
                this.error = true;
                this.warn = true;
                this.info = false;
                this.debug = false;
            } else if (level.equals(Level.SEVERE)) {
                this.error = true;
                this.warn = false;
                this.info = false;
                this.debug = false;
            }
        }
        Logger log = Logger.getLogger("");
        for (Handler h : log.getHandlers()) {
            if (!h.getClass().isAssignableFrom(iHandler)) continue;
            h.setLevel(level);
            break;
        }
        return level;
    }

    public static void installCustomFormatter() {
        Logger log = Logger.getLogger("");
        if (log.getHandlers().length == 0) {
            ConsoleHandler h = new ConsoleHandler();
            h.setFormatter(new OLogFormatter());
            log.addHandler(h);
        } else {
            for (Handler h : log.getHandlers()) {
                if (!(h instanceof ConsoleHandler) || h.getFormatter().getClass().equals(OLogFormatter.class)) continue;
                h.setFormatter(new OLogFormatter());
            }
        }
    }
}

