/*
 * Decompiled with CFR 0.152.
 */
package play.modules.orientdb;

import com.orientechnologies.orient.core.db.object.ODatabaseObjectTx;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OObjectIteratorMultiCluster;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import play.Play;
import play.data.binding.BeanWrapper;
import play.data.validation.Validation;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.modules.orientdb.ODB;
import play.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Model
implements play.db.Model {
    public static <T extends Model> OObjectIteratorMultiCluster<T> all() {
        throw new UnsupportedOperationException("Model not enhanced.");
    }

    public static long count() {
        throw new UnsupportedOperationException("Model not enhanced.");
    }

    public static <T extends Model> T create(Class<T> type, String name, Map<String, String[]> params, Annotation[] annotations) {
        try {
            Constructor<T> c = type.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            Model model = (Model)c.newInstance(new Object[0]);
            return Model.edit(model, name, params, annotations);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ODatabaseObjectTx db() {
        return ODB.openObjectDB();
    }

    public static int deleteAll() {
        int i = 0;
        for (Model m : Model.all()) {
            m.delete();
            ++i;
        }
        return i;
    }

    public static <T extends Model> T edit(Object o, String name, Map<String, String[]> params, Annotation[] annotations) {
        try {
            BeanWrapper bw = new BeanWrapper(o.getClass());
            HashSet fields = new HashSet();
            Class<?> clazz = o.getClass();
            while (!clazz.equals(Object.class)) {
                Collections.addAll(fields, clazz.getDeclaredFields());
                clazz = clazz.getSuperclass();
            }
            for (Field field : fields) {
                Class c;
                Class fieldType;
                boolean isEntity = false;
                String relation = null;
                boolean multiple = false;
                if (Model.class.isAssignableFrom(field.getType())) {
                    isEntity = true;
                    relation = field.getType().getName();
                }
                if (Collection.class.isAssignableFrom(field.getType()) && Model.class.isAssignableFrom(fieldType = (Class)((ParameterizedType)field.getGenericType()).getActualTypeArguments()[0])) {
                    isEntity = true;
                    relation = fieldType.getName();
                    multiple = true;
                }
                if (!isEntity || !Model.class.isAssignableFrom(c = Play.classloader.loadClass(relation))) continue;
                String keyName = Model.Manager.factoryFor((Class)c).keyName();
                if (multiple && Collection.class.isAssignableFrom(field.getType())) {
                    String[] ids;
                    AbstractCollection l = new ArrayList();
                    if (SortedSet.class.isAssignableFrom(field.getType())) {
                        l = new TreeSet();
                    } else if (Set.class.isAssignableFrom(field.getType())) {
                        l = new HashSet();
                    }
                    if ((ids = params.get(name + "." + field.getName() + "." + keyName)) == null) continue;
                    params.remove(name + "." + field.getName() + "." + keyName);
                    for (String _id : ids) {
                        if (_id.equals("")) continue;
                        String param = _id;
                        try {
                            if (param instanceof String) {
                                param = new ORecordId(param);
                            }
                            Object res = ODB.openObjectDB().load((ORID)param);
                            l.add(res);
                        }
                        catch (ORecordNotFoundException e) {
                            Validation.addError((String)(name + "." + field.getName()), (String)"validation.notFound", (String[])new String[]{_id});
                        }
                    }
                    bw.set(field.getName(), o, l);
                    continue;
                }
                String[] ids = params.get(name + "." + field.getName() + "." + keyName);
                if (ids != null && ids.length > 0 && !ids[0].equals("")) {
                    params.remove(name + "." + field.getName() + "." + keyName);
                    String param = ids[0];
                    try {
                        String localName = name + "." + field.getName();
                        if (param instanceof String) {
                            param = new ORecordId(param);
                        }
                        Object to = ODB.openObjectDB().load((ORID)param);
                        Model.edit(to, localName, params, field.getAnnotations());
                        params = Utils.filterMap(params, (String)localName);
                        bw.set(field.getName(), o, to);
                    }
                    catch (ORecordNotFoundException e) {
                        Validation.addError((String)(name + "." + field.getName()), (String)"validation.notFound", (String[])new String[]{ids[0]});
                    }
                    continue;
                }
                if (ids == null || ids.length <= 0 || !ids[0].equals("")) continue;
                bw.set(field.getName(), o, null);
                params.remove(name + "." + field.getName() + "." + keyName);
            }
            bw.bind(name, o.getClass(), params, "", o, annotations);
            return (T)((Model)o);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public static <T extends Model> List<T> find(String query, Object ... params) {
        return Model.db().query((OQuery)new OSQLSynchQuery(query), params);
    }

    public static <T extends Model> T findById(ORID id) {
        try {
            return (T)((Model)Model.db().load(id));
        }
        catch (ORecordNotFoundException e) {
            return null;
        }
    }

    public void _delete() {
        Model.db().delete((Object)this);
    }

    public Object _key() {
        return Model.db().getIdentity((Object)this);
    }

    public void _save() {
        Model.db().save((Object)this);
    }

    public <T extends Model> T delete() {
        this._delete();
        return (T)this;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!this.getClass().isAssignableFrom(other.getClass())) {
            return false;
        }
        if (this._key() == null) {
            return false;
        }
        return this._key().equals(((Model)other)._key());
    }

    public Object getIdentity() {
        return this._key();
    }

    public int hashCode() {
        if (this._key() == null) {
            return 0;
        }
        return this._key().hashCode();
    }

    public boolean isManaged() {
        return Model.db().isManaged((Object)this);
    }

    public <T extends Model> T refresh() {
        Model.db().reload((Object)this);
        return (T)this;
    }

    public <T extends Model> T save() {
        this._save();
        return (T)this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._key() + "]";
    }

    public boolean validateAndSave() {
        if (Validation.current().valid((Object)this).ok) {
            this.save();
            return true;
        }
        return false;
    }
}

