/*
 * Decompiled with CFR 0.152.
 */
package play.modules.orientdb;

import com.orientechnologies.orient.client.remote.OEngineRemote;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.graph.OGraphDatabasePool;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectPool;
import com.orientechnologies.orient.core.db.object.ODatabaseObjectTx;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelegate;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.classloading.ApplicationClasses;
import play.data.binding.Binder;
import play.db.Model;
import play.exceptions.UnexpectedException;
import play.inject.BeanSource;
import play.inject.Injector;
import play.modules.orientdb.DatabaseSource;
import play.modules.orientdb.Model;
import play.modules.orientdb.ODB;
import play.modules.orientdb.ODBEnhancer;
import play.modules.orientdb.OModelLoader;
import play.modules.orientdb.OSQLSynchPaginatedQuery;
import play.modules.orientdb.Transactional;
import play.vfs.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODBPlugin
extends PlayPlugin {
    private static final String PLUGIN_PREFIX = "[ODB] ";
    public static String url;
    public static String gurl;
    public static String user;
    public static String passwd;
    private OServer server;
    private int openInView = 0;
    private boolean stale;
    static final int OIV_DOCUMENT_DB = 1;
    static final int OIV_OBJECT_DB = 2;
    static final int OIV_GRAPH_DB = 4;

    public void beforeActionInvocation(Method actionMethod) {
        if (actionMethod.isAnnotationPresent(Transactional.class)) {
            Transactional annotation = actionMethod.getAnnotation(Transactional.class);
            ODB.begin(annotation.type(), annotation.db());
        }
    }

    public void beforeInvocation() {
        if (this.openInView != 0) {
            Injector.inject((BeanSource)new DatabaseSource(this.openInView));
        }
    }

    public Object bind(String name, Class clazz, Type type, Annotation[] annotations, Map<String, String[]> params) {
        if (Model.class.isAssignableFrom(clazz)) {
            String keyName = Model.Manager.factoryFor((Class)clazz).keyName();
            String idKey = name + "." + keyName;
            if (params.containsKey(idKey) && params.get(idKey).length > 0 && params.get(idKey)[0] != null && params.get(idKey)[0].trim().length() > 0) {
                String id = params.get(idKey)[0];
                try {
                    OSQLSynchQuery query = new OSQLSynchQuery("from " + clazz.getName() + " o where o." + keyName + " = ?");
                    Object param = Binder.directBind((String)name, (Annotation[])annotations, (String)(id + ""), (Class)Model.Manager.factoryFor((Class)clazz).keyType());
                    List res = ODB.openObjectDB().query((OQuery)query, new Object[]{param});
                    Object o = res.get(0);
                    return Model.edit(o, name, params, annotations);
                }
                catch (ORecordNotFoundException e) {
                }
                catch (Exception e) {
                    throw new UnexpectedException((Throwable)e);
                }
            }
            return Model.create(clazz, name, params, annotations);
        }
        return super.bind(name, clazz, type, annotations, params);
    }

    public Object bind(String name, Object o, Map<String, String[]> params) {
        if (o instanceof Model) {
            return Model.edit(o, name, params, null);
        }
        return null;
    }

    public void detectChange() {
        if (this.stale && Play.mode == Play.Mode.DEV) {
            throw new RuntimeException("Need reload");
        }
    }

    public void enhance(ApplicationClasses.ApplicationClass applicationClass) throws Exception {
        new ODBEnhancer().enhanceThisClass(applicationClass);
    }

    public void invocationFinally() {
        ODB.close();
    }

    public Model.Factory modelFactory(Class<? extends play.db.Model> modelClass) {
        if (Model.class.isAssignableFrom(modelClass)) {
            return new OModelLoader(modelClass);
        }
        return null;
    }

    public void onApplicationStart() {
        this.stale = false;
        if (this.server == null) {
            this.configure();
            if (url.startsWith("remote")) {
                Orient.instance().registerEngine((OEngine)new OEngineRemote());
            } else {
                this.runEmbeddedOrientDB();
            }
            this.registerEntityClasses();
        }
    }

    public void onApplicationStop() {
        if (this.server != null) {
            if (Play.mode == Play.Mode.DEV) {
                this.clearReferencesToStaleClasses();
            }
            this.server.shutdown();
            this.server = null;
        }
    }

    public List<ApplicationClasses.ApplicationClass> onClassesChange(List<ApplicationClasses.ApplicationClass> modified) {
        this.stale = true;
        return super.onClassesChange(modified);
    }

    public void onInvocationException(Throwable e) {
        ODB.rollback();
    }

    public void onInvocationSuccess() {
        ODB.commit();
    }

    public void onLoad() {
        OCommandManager cmdMan = OCommandManager.instance();
        cmdMan.registerExecutor(OSQLSynchPaginatedQuery.class, OCommandExecutorSQLDelegate.class);
    }

    private void clearReferencesToStaleClasses() {
        Logger.trace((String)"[ODB]  Cleaning stale classes", (Object[])new Object[0]);
        try {
            Field classes = OObjectSerializerHelper.class.getDeclaredField("classes");
            classes.setAccessible(true);
            classes.set(null, new HashMap());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ODatabaseObjectPool.global().getPools().clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ODatabaseDocumentPool.global().getPools().clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            OGraphDatabasePool.global().getPools().clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void configure() {
        Properties p = Play.configuration;
        url = p.getProperty("odb.url", "memory:temp");
        user = p.getProperty("odb.user", "admin");
        passwd = p.getProperty("odb.password", "admin");
        gurl = p.getProperty("odb.graph.url", null);
        if (Boolean.parseBoolean(p.getProperty("odb.open-in-view.documentdb", "true"))) {
            this.openInView |= 1;
        }
        if (Boolean.parseBoolean(p.getProperty("odb.open-in-view.objectdb", "true"))) {
            this.openInView |= 2;
        }
        if (Boolean.parseBoolean(p.getProperty("odb.open-in-view.graphdb", "true"))) {
            this.openInView |= 4;
        }
    }

    private void info(String msg, Object ... args) {
        Logger.info((String)(PLUGIN_PREFIX + msg), (Object[])args);
    }

    private void registerEntityClasses() {
        String modelPackage = Play.configuration.getProperty("odb.entities.package", "models");
        ODatabaseObjectTx db = new ODatabaseObjectTx(url);
        db.open(user, passwd);
        this.info("Registering Entities", new Object[0]);
        for (ApplicationClasses.ApplicationClass appClass : Play.classes.all()) {
            Class javaClass = appClass.javaClass;
            if (!javaClass.getName().startsWith(modelPackage)) continue;
            String entityName = javaClass.getSimpleName();
            this.info("Entity: %s", javaClass.getName());
            db.getEntityManager().registerEntityClass(javaClass);
            OSchema schema = db.getMetadata().getSchema();
            if (schema.existsClass(entityName)) continue;
            this.info("Schema: %s", entityName);
            schema.createClass(javaClass);
            schema.save();
        }
        this.info("Registering Database Listeners", new Object[0]);
        for (ApplicationClasses.ApplicationClass listener : Play.classes.getAssignableClasses(ODatabaseListener.class)) {
            this.info("Listener: %s", listener.javaClass.getName());
            ODB.listeners.add(listener);
        }
        this.info("Registering Record Hooks", new Object[0]);
        for (ApplicationClasses.ApplicationClass hook : Play.classes.getAssignableClasses(ORecordHook.class)) {
            this.info("Hook: %s", hook.javaClass.getName());
            ODB.hooks.add(hook);
        }
        db.close();
    }

    private void runEmbeddedOrientDB() {
        try {
            this.server = OServerMain.create();
            String cfile = Play.configuration.getProperty("odb.config.file", "/play/modules/orientdb/db.config");
            VirtualFile vconf = Play.getVirtualFile((String)cfile);
            File configuration = vconf == null || !vconf.exists() ? this.writeConfigFile(cfile) : vconf.getRealFile();
            this.info("Starting OrientDB embbeded", new Object[0]);
            this.server.startup(configuration);
            this.info("OrientDB started", new Object[0]);
        }
        catch (Exception e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    private File writeConfigFile(String cfile) throws FileNotFoundException, IOException {
        int len;
        File f = new File("db.config");
        if (f.exists()) {
            return f;
        }
        InputStream in = ODBPlugin.class.getResourceAsStream(cfile);
        FileOutputStream out = new FileOutputStream(f);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
        return f;
    }
}

