/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;

public class OChannelBinaryClient
extends OChannelBinaryAsynch {
    protected final int timeout;

    public OChannelBinaryClient(String remoteHost, int remotePort, OContextConfiguration iConfig) throws IOException {
        super(new Socket(), iConfig);
        this.timeout = iConfig.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_TIMEOUT);
        this.socket.setPerformancePreferences(0, 2, 1);
        this.socket.setKeepAlive(true);
        this.socket.setSendBufferSize(this.socketBufferSize);
        this.socket.setReceiveBufferSize(this.socketBufferSize);
        this.socket.connect(new InetSocketAddress(remoteHost, remotePort), this.timeout);
        this.inStream = new BufferedInputStream(this.socket.getInputStream(), this.socketBufferSize);
        this.outStream = new BufferedOutputStream(this.socket.getOutputStream(), this.socketBufferSize);
        this.in = new DataInputStream(this.inStream);
        this.out = new DataOutputStream(this.outStream);
    }

    public void reconnect() throws IOException {
        SocketAddress address = this.socket.getRemoteSocketAddress();
        this.socket.close();
        this.socket.connect(address, this.timeout);
    }

    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected() && !this.socket.isInputShutdown() && !this.socket.isOutputShutdown();
    }
}

