/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynch;
import java.io.IOException;
import java.io.OutputStream;

public class OChannelBinaryOutputStream
extends OutputStream {
    private OChannelBinaryAsynch channel;
    private final byte[] buffer;
    private int pos = 0;

    public OChannelBinaryOutputStream(OChannelBinaryAsynch channel) {
        this.channel = channel;
        this.buffer = channel.getBuffer();
    }

    public void write(int iByte) throws IOException {
        if (this.pos >= this.buffer.length) {
            this.flush(true);
        }
        this.buffer[this.pos++] = (byte)iByte;
    }

    public void close() throws IOException {
        this.flush(false);
        this.channel = null;
    }

    public void flush() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean iContinue) throws IOException {
        this.channel.beginRequest();
        try {
            this.channel.out.writeInt(this.pos);
            if (this.pos > 0) {
                this.channel.out.write(this.buffer, 0, this.pos);
                this.pos = 0;
            }
            this.channel.out.writeByte(iContinue ? 1 : 0);
        }
        finally {
            this.channel.endRequest();
        }
    }
}

