/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.enterprise.channel.binary;

import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinary;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import java.io.IOException;

public class OChannelBinaryProtocol {
    public static final byte REQUEST_SHUTDOWN = 1;
    public static final byte REQUEST_CONNECT = 2;
    public static final byte REQUEST_DB_OPEN = 3;
    public static final byte REQUEST_DB_CREATE = 4;
    public static final byte REQUEST_DB_CLOSE = 5;
    public static final byte REQUEST_DB_EXIST = 6;
    public static final byte REQUEST_DB_DELETE = 7;
    public static final byte REQUEST_DB_SIZE = 8;
    public static final byte REQUEST_DB_COUNTRECORDS = 9;
    public static final byte REQUEST_DATACLUSTER_ADD = 10;
    public static final byte REQUEST_DATACLUSTER_REMOVE = 11;
    public static final byte REQUEST_DATACLUSTER_COUNT = 12;
    public static final byte REQUEST_DATACLUSTER_DATARANGE = 13;
    public static final byte REQUEST_DATASEGMENT_ADD = 20;
    public static final byte REQUEST_DATASEGMENT_REMOVE = 21;
    public static final byte REQUEST_RECORD_LOAD = 30;
    public static final byte REQUEST_RECORD_CREATE = 31;
    public static final byte REQUEST_RECORD_UPDATE = 32;
    public static final byte REQUEST_RECORD_DELETE = 33;
    public static final byte REQUEST_COUNT = 40;
    public static final byte REQUEST_COMMAND = 41;
    public static final byte REQUEST_TX_COMMIT = 60;
    public static final byte REQUEST_CONFIG_GET = 70;
    public static final byte REQUEST_CONFIG_SET = 71;
    public static final byte REQUEST_CONFIG_LIST = 72;
    public static final byte REQUEST_DB_RELOAD = 73;
    public static final byte REQUEST_PUSH_RECORD = 79;
    public static final byte RESPONSE_STATUS_OK = 0;
    public static final byte RESPONSE_STATUS_ERROR = 1;
    public static final byte PUSH_DATA = 3;
    public static final short RECORD_NULL = -2;
    public static final short RECORD_RID = -3;
    public static final int CURRENT_PROTOCOL_VERSION = 5;

    public static void checkProtocolVersion(OChannelBinary iNetwork) throws IOException {
        short srvProtocolVersion;
        try {
            srvProtocolVersion = iNetwork.readShort();
        }
        catch (IOException e) {
            throw new ONetworkProtocolException("Can't read data from remote server " + iNetwork.socket.getRemoteSocketAddress() + ": " + e);
        }
        if (srvProtocolVersion != 5) {
            iNetwork.close();
            throw new ONetworkProtocolException("Binary protocol is uncompatible with the Server connected: client=5, server=" + srvProtocolVersion);
        }
    }
}

