/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OrientShutdownHook;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseLifecycleListener;
import com.orientechnologies.orient.core.engine.OEngine;
import com.orientechnologies.orient.core.engine.local.OEngineLocal;
import com.orientechnologies.orient.core.engine.memory.OEngineMemory;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.record.ORecordFactoryManager;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Orient
extends OSharedResourceAbstract {
    public static final String URL_SYNTAX = "<engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*";
    protected Map<String, OEngine> engines = new HashMap<String, OEngine>();
    protected Map<String, OStorage> storages = new HashMap<String, OStorage>();
    protected Set<ODatabaseLifecycleListener> dbLifecycleListeners = new HashSet<ODatabaseLifecycleListener>();
    protected ORecordFactoryManager recordFactoryManager = new ORecordFactoryManager();
    protected volatile boolean active = false;
    protected static final OrientShutdownHook shutdownHook = new OrientShutdownHook();
    protected static final Timer timer = new Timer(true);
    protected static final ThreadGroup threadGroup = new ThreadGroup("OrientDB");
    protected static Orient instance = new Orient();
    private final OMemoryWatchDog memoryWatchDog;
    private static AtomicInteger serialId = new AtomicInteger();

    protected Orient() {
        this.registerEngine(new OEngineLocal());
        this.registerEngine(new OEngineMemory());
        this.registerEngine("com.orientechnologies.orient.client.remote.OEngineRemote");
        if (OGlobalConfiguration.PROFILER_ENABLED.getValueAsBoolean()) {
            OProfiler.getInstance().startRecording();
        }
        this.memoryWatchDog = new OMemoryWatchDog(OGlobalConfiguration.MEMORY_OPTIMIZE_THRESHOLD.getValueAsFloat());
        this.active = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage loadStorage(String iURL) {
        OStorage oStorage;
        int pos;
        if (iURL == null || iURL.length() == 0) {
            throw new IllegalArgumentException("URL missed");
        }
        if (iURL.endsWith("/")) {
            iURL = iURL.substring(0, iURL.length() - 1);
        }
        if ((pos = iURL.indexOf(58)) <= 0) {
            throw new OConfigurationException("Error in database URL: the engine was not specified. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
        }
        String engineName = iURL.substring(0, pos);
        this.acquireExclusiveLock();
        try {
            OStorage storage;
            OEngine engine = this.engines.get(engineName.toLowerCase());
            if (engine == null) {
                throw new OConfigurationException("Error on opening database: the engine '" + engineName + "' was not found. URL was: " + iURL + ". registered engines are: " + this.engines.keySet());
            }
            iURL = iURL.substring(pos + 1);
            pos = iURL.indexOf(63);
            HashMap<String, String> parameters = null;
            String dbName = null;
            if (pos > 0) {
                String[] pairs;
                dbName = iURL.substring(0, pos);
                iURL = iURL.substring(pos + 1);
                parameters = new HashMap<String, String>();
                for (String pair : pairs = iURL.split("&")) {
                    String[] kv = pair.split("=");
                    if (kv.length < 2) {
                        throw new OConfigurationException("Error on opening database: the parameter has no value. Syntax is: <engine>:<db-type>:<db-name>[?<db-param>=<db-value>[&]]*. URL was: " + iURL);
                    }
                    parameters.put(kv[0], kv[1]);
                }
            } else {
                dbName = iURL;
            }
            if (engine.isShared()) {
                storage = this.storages.get(dbName);
                if (storage == null) {
                    storage = engine.createStorage(dbName, parameters);
                    this.storages.put(dbName, storage);
                }
            } else {
                storage = engine.createStorage(dbName, parameters);
                this.storages.put(dbName + "__" + serialId.incrementAndGet(), storage);
            }
            oStorage = storage;
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
        return oStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStorage(OStorage iStorage) throws IOException {
        this.acquireExclusiveLock();
        try {
            if (!this.storages.containsKey(iStorage.getName())) {
                this.storages.put(iStorage.getURL(), iStorage);
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OStorage getStorage(String iDbName) {
        OStorage oStorage;
        try {
            this.acquireSharedLock();
            oStorage = this.storages.get(iDbName);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return oStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEngine(OEngine iEngine) {
        this.acquireExclusiveLock();
        try {
            this.engines.put(iEngine.getName(), iEngine);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    private void registerEngine(String iClassName) {
        try {
            Class<?> cls = Class.forName(iClassName);
            this.registerEngine((OEngine)cls.newInstance());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OEngine getEngine(String iEngineName) {
        OEngine oEngine;
        this.acquireSharedLock();
        try {
            oEngine = this.engines.get(iEngineName);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return oEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEngines() {
        Set<String> set;
        this.acquireSharedLock();
        try {
            set = Collections.unmodifiableSet(this.engines.keySet());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return set;
    }

    public void unregisterStorage(OStorage iStorage) {
        for (Map.Entry<String, OStorage> s : this.storages.entrySet()) {
            if (s.getValue() != iStorage) continue;
            this.storages.remove(s.getKey());
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<OStorage> getStorages() {
        Collection<OStorage> collection;
        try {
            this.acquireSharedLock();
            collection = Collections.unmodifiableCollection(this.storages.values());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        block5: {
            block4: {
                this.acquireExclusiveLock();
                try {
                    if (!this.active) {
                        Object var5_1 = null;
                        break block4;
                    }
                    OLogManager.instance().debug((Object)this, "Orient Engine is shutdowning...", new Object[0]);
                    ArrayList<OStorage> storagesCopy = new ArrayList<OStorage>(this.storages.values());
                    for (OStorage stg : storagesCopy) {
                        OLogManager.instance().debug((Object)this, "Shutdowning storage: " + stg.getName() + "...", new Object[0]);
                        stg.close(true);
                    }
                    OMMapManager.shutdown();
                    this.active = false;
                    threadGroup.interrupt();
                    OLogManager.instance().debug((Object)this, "Orient Engine shutdown complete", new Object[0]);
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var5_3 = null;
                    this.releaseExclusiveLock();
                    throw throwable;
                }
            }
            this.releaseExclusiveLock();
            return;
        }
        Object var5_2 = null;
        this.releaseExclusiveLock();
    }

    public static Timer getTimer() {
        return timer;
    }

    public void removeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(shutdownHook);
    }

    public Iterable<ODatabaseLifecycleListener> getDbLifecycleListeners() {
        return this.dbLifecycleListeners;
    }

    public void addDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.add(iListener);
    }

    public void removeDbLifecycleListener(ODatabaseLifecycleListener iListener) {
        this.dbLifecycleListeners.remove(iListener);
    }

    public static Orient instance() {
        return instance;
    }

    public static ThreadGroup getThreadGroup() {
        return threadGroup;
    }

    public OMemoryWatchDog getMemoryWatchDog() {
        return this.memoryWatchDog;
    }

    public ORecordFactoryManager getRecordFactoryManager() {
        return this.recordFactoryManager;
    }
}

