/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordCache
extends LinkedHashMap<ORID, ORecordInternal<?>> {
    private int maxSize;

    public ORecordCache(int maxSize, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor, true);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<ORID, ORecordInternal<?>> iEldest) {
        int size = this.size();
        if (this.maxSize == -1 || size < this.maxSize) {
            return false;
        }
        if (this.maxSize - size > 1) {
            this.removeEldestItems(this.maxSize - size);
            return false;
        }
        return true;
    }

    public void removeEldestItems(int iThreshold) {
        ORID[] ridToRemove = new ORID[this.size() - iThreshold];
        int entryNum = 0;
        int i = 0;
        for (Map.Entry ridEntry : this.entrySet()) {
            if (!((ORecordInternal)ridEntry.getValue()).isDirty() && entryNum++ >= iThreshold) {
                ridToRemove[i++] = (ORID)ridEntry.getKey();
            }
            if (i < ridToRemove.length) continue;
            break;
        }
        for (ORID rid : ridToRemove) {
            this.remove(rid);
        }
    }
}

