/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.OCommandSQLPojoWrapper;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseSchemaAware;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.OLazyObjectList;
import com.orientechnologies.orient.core.db.object.OLazyObjectMap;
import com.orientechnologies.orient.core.db.object.OLazyObjectSet;
import com.orientechnologies.orient.core.db.object.OObjectNotDetachedException;
import com.orientechnologies.orient.core.db.object.OObjectNotManagedException;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelper;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabasePojoAbstract<T>
extends ODatabaseWrapperAbstract<ODatabaseDocumentTx>
implements ODatabaseSchemaAware<T> {
    protected HashMap<Integer, ODocument> objects2Records = new HashMap();
    protected IdentityHashMap<ODocument, T> records2Objects = new IdentityHashMap();
    protected HashMap<ORID, ODocument> rid2Records = new HashMap();
    private boolean retainObjects = true;

    public ODatabasePojoAbstract(ODatabaseDocumentTx iDatabase) {
        super(iDatabase);
        iDatabase.setDatabaseOwner(this);
    }

    public abstract ODocument pojo2Stream(T var1, ODocument var2);

    public abstract Object stream2pojo(ODocument var1, Object var2, String var3);

    @Override
    public void close() {
        this.objects2Records.clear();
        this.records2Objects.clear();
        this.rid2Records.clear();
        super.close();
    }

    @Override
    public OTransaction getTransaction() {
        return ((ODatabaseDocumentTx)this.underlying).getTransaction();
    }

    @Override
    public ODatabaseComplex<T> begin() {
        return ((ODatabaseDocumentTx)this.underlying).begin();
    }

    @Override
    public ODatabaseComplex<T> begin(OTransaction.TXTYPE iType) {
        return ((ODatabaseDocumentTx)this.underlying).begin(iType);
    }

    @Override
    public ODatabaseComplex<T> begin(OTransaction iTx) {
        return ((ODatabaseDocumentTx)this.underlying).begin(iTx);
    }

    @Override
    public ODatabaseComplex<T> commit() {
        this.clearNewEntriesFromCache();
        ((ODatabaseDocumentTx)this.underlying).commit();
        return this;
    }

    @Override
    public ODatabaseComplex<T> rollback() {
        this.clearNewEntriesFromCache();
        ((ODatabaseDocumentTx)this.underlying).rollback();
        HashSet<ORID> rids = new HashSet<ORID>(this.rid2Records.keySet());
        for (ORID rid : rids) {
            T object;
            ORecord record;
            if (!rid.isTemporary() || (record = (ORecord)this.rid2Records.remove(rid)) == null || (object = this.records2Objects.remove(record)) == null) continue;
            this.objects2Records.remove(object);
        }
        return this;
    }

    public void setDirty(Object iPojo) {
        if (iPojo == null) {
            return;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            throw new OObjectNotManagedException("The object " + iPojo + " is not managed by the current database");
        }
        record.setDirty();
    }

    public void unsetDirty(Object iPojo) {
        if (iPojo == null) {
            return;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            return;
        }
        record.unsetDirty();
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES attribute, Object iValue) {
        ((ODatabaseDocumentTx)this.underlying).setInternal(attribute, iValue);
    }

    public int getVersion(Object iPojo) {
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            throw new OObjectNotManagedException("The object " + iPojo + " is not managed by the current database");
        }
        return record.getVersion();
    }

    public ORID getIdentity(Object iPojo) {
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            throw new OObjectNotManagedException("The object " + iPojo + " is not managed by the current database");
        }
        return record.getIdentity();
    }

    @Override
    public OUser getUser() {
        return ((ODatabaseDocumentTx)this.underlying).getUser();
    }

    @Override
    public OMetadata getMetadata() {
        return ((ODatabaseDocumentTx)this.underlying).getMetadata();
    }

    @Override
    public <RET extends OCommandRequest> RET command(OCommandRequest iCommand) {
        return (RET)new OCommandSQLPojoWrapper(this, (OCommandRequest)((ODatabaseDocumentTx)this.underlying).command(iCommand));
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<?> iCommand, Object ... iArgs) {
        this.checkOpeness();
        this.convertParameters(iArgs);
        Object result = ((ODatabaseDocumentTx)this.underlying).query((OQuery<? extends Object>)iCommand, iArgs);
        if (result == null) {
            return null;
        }
        ArrayList<ODocument> resultPojo = new ArrayList<ODocument>();
        for (ODocument doc : result) {
            ODocument obj = doc.getClassName() == null ? doc : this.getUserObjectByRecord(doc, iCommand.getFetchPlan(), true);
            resultPojo.add(obj);
        }
        return (RET)resultPojo;
    }

    @Override
    public ODatabaseComplex<T> delete(ORecordInternal<?> iRecord) {
        ((ODatabaseDocumentTx)this.underlying).delete((ODocument)iRecord);
        return this;
    }

    @Override
    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE registerHook(ORecordHook iHookImpl) {
        ((ODatabaseDocumentTx)this.underlying).registerHook(iHookImpl);
        return (DBTYPE)this;
    }

    @Override
    public boolean callbackHooks(ORecordHook.TYPE iType, OIdentifiable iObject) {
        return ((ODatabaseDocumentTx)this.underlying).callbackHooks(iType, iObject);
    }

    @Override
    public Set<ORecordHook> getHooks() {
        return ((ODatabaseDocumentTx)this.underlying).getHooks();
    }

    @Override
    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE unregisterHook(ORecordHook iHookImpl) {
        ((ODatabaseDocumentTx)this.underlying).unregisterHook(iHookImpl);
        return (DBTYPE)this;
    }

    @Override
    public boolean isMVCC() {
        return ((ODatabaseDocumentTx)this.underlying).isMVCC();
    }

    @Override
    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE setMVCC(boolean iMvcc) {
        ((ODatabaseDocumentTx)this.underlying).setMVCC(iMvcc);
        return (DBTYPE)this;
    }

    public ODatabasePojoAbstract<T> setRetainObjects(boolean iValue) {
        this.retainObjects = iValue;
        return this;
    }

    public boolean isRetainObjects() {
        return this.retainObjects;
    }

    public ODocument getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
        if (iPojo instanceof ODocument) {
            return (ODocument)iPojo;
        }
        ODocument record = this.objects2Records.get(System.identityHashCode(iPojo));
        if (record == null) {
            ORecordId rid = OObjectSerializerHelper.getObjectID(this, iPojo);
            if (rid != null && rid.isValid()) {
                record = this.rid2Records.get(rid);
                if (record == null) {
                    record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(rid);
                }
            } else if (iCreateIfNotAvailable) {
                record = ((ODatabaseDocumentTx)this.underlying).newInstance(iPojo.getClass().getSimpleName());
            } else {
                return null;
            }
            this.registerUserObject(iPojo, record);
        }
        return record;
    }

    @Override
    public boolean existsUserObjectByRID(ORID iRID) {
        return this.rid2Records.containsKey(iRID);
    }

    public ODocument getRecordById(ORID iRecordId) {
        return iRecordId.isValid() ? this.rid2Records.get(iRecordId) : null;
    }

    public boolean isManaged(Object iEntity) {
        return this.objects2Records.containsKey(System.identityHashCode(iEntity));
    }

    public T getUserObjectByRecord(ORecordInternal<?> iRecord, String iFetchPlan) {
        return this.getUserObjectByRecord(iRecord, iFetchPlan, true);
    }

    public T getUserObjectByRecord(ORecordInternal<?> iRecord, String iFetchPlan, boolean iCreate) {
        Object pojo;
        if (!(iRecord instanceof ODocument)) {
            return null;
        }
        ODocument record = this.rid2Records.get(iRecord.getIdentity());
        if (record == null) {
            record = (ODocument)iRecord;
        }
        if ((pojo = this.records2Objects.get(record)) == null && iCreate) {
            this.checkOpeness();
            try {
                if (iRecord.getDatabase() != this.underlying) {
                    iRecord.setDatabase((ODatabaseRecord)this.underlying);
                }
                if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    record = (ODocument)record.load();
                }
                pojo = this.newInstance(record.getClassName());
                this.registerUserObject(pojo, record);
                this.stream2pojo(record, pojo, iFetchPlan);
            }
            catch (Exception e) {
                throw new OConfigurationException("Can't retrieve pojo from the record " + record, e);
            }
        }
        return pojo;
    }

    public void attach(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.objects2Records.get(System.identityHashCode(iPojo));
        if (record != null) {
            return;
        }
        if (OObjectSerializerHelper.hasObjectID(iPojo)) {
            for (Field field : iPojo.getClass().getDeclaredFields()) {
                Object value = OObjectSerializerHelper.getFieldValue(iPojo, field.getName());
                if (value instanceof OLazyObjectMap) {
                    ((OLazyObjectMap)value).assignDatabase(this);
                    continue;
                }
                if (value instanceof OLazyObjectList) {
                    ((OLazyObjectList)value).assignDatabase(this);
                    continue;
                }
                if (!(value instanceof OLazyObjectSet)) continue;
                ((OLazyObjectSet)value).assignDatabase(this);
            }
        } else {
            throw new OObjectNotDetachedException("Cannot attach a non detached object");
        }
    }

    public Object detach(Object iPojo) {
        this.checkOpeness();
        for (Field field : iPojo.getClass().getDeclaredFields()) {
            Object value = OObjectSerializerHelper.getFieldValue(iPojo, field.getName());
            if (value instanceof OLazyObjectList) {
                ((OLazyObjectList)value).detach();
                continue;
            }
            if (value instanceof OLazyObjectSet) {
                ((OLazyObjectSet)value).detach();
                continue;
            }
            if (!(value instanceof OLazyObjectMap)) continue;
            ((OLazyObjectMap)value).detach();
        }
        return iPojo;
    }

    @Override
    public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
        if (!(iRecord instanceof ODocument)) {
            return;
        }
        ODocument doc = (ODocument)iRecord;
        if (this.retainObjects) {
            ORID rid;
            if (iObject != null) {
                this.objects2Records.put(System.identityHashCode(iObject), doc);
                this.records2Objects.put(doc, iObject);
                OObjectSerializerHelper.setObjectID(iRecord.getIdentity(), iObject);
                OObjectSerializerHelper.setObjectVersion(iRecord.getVersion(), iObject);
            }
            if ((rid = iRecord.getIdentity()).isValid()) {
                this.rid2Records.put(rid, doc);
            }
        }
    }

    public void unregisterPojo(T iObject, ODocument iRecord) {
        if (iObject != null) {
            this.objects2Records.remove(System.identityHashCode(iObject));
        }
        if (iRecord != null) {
            this.records2Objects.remove(iRecord);
            ORID rid = iRecord.getIdentity();
            if (rid.isValid()) {
                this.rid2Records.remove(rid);
            }
        }
    }

    protected void clearNewEntriesFromCache() {
        Map.Entry<Comparable<OIdentifiable>, ODocument> entry;
        Iterator<Map.Entry<Comparable<OIdentifiable>, ODocument>> it = this.rid2Records.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!entry.getKey().isNew()) continue;
            it.remove();
        }
        it = this.objects2Records.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!entry.getValue().getIdentity().isNew()) continue;
            it.remove();
        }
        it = this.records2Objects.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!((ODocument)entry.getKey()).getIdentity().isNew()) continue;
            it.remove();
        }
    }

    protected void convertParameters(Object ... iArgs) {
        if (iArgs == null) {
            return;
        }
        for (int i = 0; i < iArgs.length; ++i) {
            iArgs[i] = this.convertParameter(iArgs[i]);
        }
    }

    protected Object convertParameter(Object iParameter) {
        if (iParameter != null) {
            ORID rid;
            if (iParameter instanceof Map) {
                Map map = (Map)iParameter;
                for (Map.Entry e : map.entrySet()) {
                    map.put(e.getKey(), this.convertParameter(e.getValue()));
                }
            } else if (iParameter != null && !OType.isSimpleType(iParameter) && (rid = this.getIdentity(iParameter)) != null && rid.isValid()) {
                return rid;
            }
        }
        return iParameter;
    }
}

