/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabasePoolAbstract<DB extends ODatabase>
implements OResourcePoolListener<String, DB> {
    private static final int DEF_WAIT_TIMEOUT = 5000;
    private final Map<String, OResourcePool<String, DB>> pools = new HashMap<String, OResourcePool<String, DB>>();
    private int maxSize;
    private int timeout = 5000;
    protected Object owner;

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize) {
        this(iOwner, iMinSize, iMaxSize, 5000);
    }

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize, int iTimeout) {
        this.maxSize = iMaxSize;
        this.timeout = iTimeout;
        this.owner = iOwner;
    }

    public DB acquire(String iURL, String iUserName, String iUserPassword) throws OLockException {
        return this.acquire(iURL, iUserName, iUserPassword, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DB acquire(String iURL, String iUserName, String iUserPassword, Map<String, Object> iOptionalParams) throws OLockException {
        int separatorPos = iURL.lastIndexOf(47);
        String name = separatorPos > -1 ? iURL.substring(separatorPos + 1) : ((separatorPos = iURL.lastIndexOf(58)) > -1 ? iURL.substring(separatorPos + 1) : iURL);
        String dbPooledName = iUserName + "@" + name;
        OResourcePool pool = this.pools.get(dbPooledName);
        if (pool == null) {
            Map<String, OResourcePool<String, DB>> map = this.pools;
            synchronized (map) {
                pool = this.pools.get(dbPooledName);
                if (pool == null) {
                    pool = new OResourcePool(this.maxSize, (OResourcePoolListener)this);
                    this.pools.put(dbPooledName, pool);
                }
            }
        }
        return (DB)((ODatabase)pool.getResource((Object)iURL, (long)this.timeout, new Object[]{iUserName, iUserPassword, iOptionalParams}));
    }

    public void release(DB iDatabase) {
        String dbPooledName = iDatabase instanceof ODatabaseComplex ? ((ODatabaseComplex)iDatabase).getUser().getName() + "@" + iDatabase.getName() : iDatabase.getName();
        OResourcePool<String, DB> pool = this.pools.get(dbPooledName);
        if (pool == null) {
            throw new OLockException("Can't release a database URL not acquired before. URL: " + iDatabase.getName());
        }
        pool.returnResource(iDatabase);
    }

    public DB reuseResource(String iKey, DB iValue) {
        return iValue;
    }

    public Map<String, OResourcePool<String, DB>> getPools() {
        return this.pools;
    }

    public void close() {
        for (Map.Entry<String, OResourcePool<String, DB>> pool : this.pools.entrySet()) {
            for (ODatabase db : pool.getValue().getResources()) {
                pool.getValue().close();
                try {
                    OLogManager.instance().debug((Object)this, "Closing pooled database '%s'...", new Object[]{db.getName()});
                    ((ODatabasePooled)((Object)db)).forceClose();
                    OLogManager.instance().debug((Object)this, "OK", new Object[]{db.getName()});
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Error: %d", new Object[]{e.toString()});
                }
            }
        }
    }

    public void remove(String iName, String iUser) {
        String dbPooledName = iUser + "@" + iName;
        OResourcePool<String, DB> pool = this.pools.get(dbPooledName);
        if (pool != null) {
            for (ODatabase db : pool.getResources()) {
                pool.close();
                try {
                    OLogManager.instance().debug((Object)this, "Closing pooled database '%s'...", new Object[]{db.getName()});
                    ((ODatabasePooled)((Object)db)).forceClose();
                    OLogManager.instance().debug((Object)this, "OK", new Object[]{db.getName()});
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Error: %d", new Object[]{e.toString()});
                }
            }
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }
}

