/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.document;

import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentPool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.raw.ODatabaseRaw;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.ODatabaseException;

public class ODatabaseDocumentTxPooled
extends ODatabaseDocumentTx
implements ODatabasePooled {
    private ODatabaseDocumentPool ownerPool;

    public ODatabaseDocumentTxPooled(ODatabaseDocumentPool iOwnerPool, String iURL, String iUserName, String iUserPassword) {
        super(iURL);
        this.ownerPool = iOwnerPool;
        super.open(iUserName, iUserPassword);
    }

    public void reuse(Object iOwner) {
        this.ownerPool = (ODatabaseDocumentPool)iOwner;
        this.getMetadata().reload();
    }

    public ODatabaseDocumentTxPooled open(String iUserName, String iUserPassword) {
        this.checkOpeness();
        if (!this.getUser().getName().equals(iUserName)) {
            throw new UnsupportedOperationException("Database instance was retrieved from a pool and has been used with the user '" + this.getUser().getName() + "'. Get another database instance fro mthe pool with the right username and password");
        }
        return this;
    }

    public ODatabaseDocumentTxPooled create() {
        throw new UnsupportedOperationException("Database instance was retrieved from a pool. You can't create the database in this way. Please use directly ODatabaseDocumentTx.create()");
    }

    public boolean isClosed() {
        return this.ownerPool == null || super.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.checkOpeness();
        this.rollback();
        this.getMetadata().close();
        ((ODatabaseRaw)((ODatabaseRecordTx)this.underlying).getUnderlying()).callOnCloseListeners();
        this.getLevel1Cache().clear();
        this.ownerPool.release(this);
        this.ownerPool = null;
    }

    public void forceClose() {
        super.close();
    }

    protected void checkOpeness() {
        if (this.ownerPool == null) {
            throw new ODatabaseException("Database instance has been released to the pool. Get another database instance from the pool with the right username and password");
        }
        super.checkOpeness();
    }
}

