/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.graph;

import com.orientechnologies.orient.core.db.graph.ODatabaseGraphTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecordListener;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.type.ODocumentWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OGraphElement
extends ODocumentWrapper
implements ORecordListener {
    protected ODatabaseGraphTx database;

    public OGraphElement(ODatabaseGraphTx iDatabase, ORID iRID) {
        this(iDatabase, new ODocument((ODatabaseRecord)iDatabase.getUnderlying(), iRID));
        this.document.setTrackingChanges(false);
    }

    public OGraphElement(ODatabaseGraphTx iDatabase, String iClassName) {
        this(iDatabase, new ODocument((ODatabaseRecord)iDatabase.getUnderlying(), iClassName));
        this.document.setTrackingChanges(false);
    }

    public OGraphElement(ODatabaseGraphTx iDatabase, ODocument iDocument) {
        super(iDocument);
        this.database = iDatabase;
        this.document.setTrackingChanges(false);
        this.init();
    }

    public abstract void reset();

    public abstract void delete();

    public ORID getId() {
        return this.document.getIdentity();
    }

    public <RET extends OGraphElement> RET setLabel(String iLabel) {
        this.document.field("label", iLabel);
        return (RET)this;
    }

    public String getLabel() {
        return (String)this.document.field("label");
    }

    public Object get(String iPropertyName) {
        return this.document.field(iPropertyName);
    }

    public <RET extends OGraphElement> RET set(String iPropertyName, Object iPropertyValue) {
        this.document.field(iPropertyName, iPropertyValue, null);
        return (RET)this;
    }

    public Object remove(String iPropertyName) {
        return this.document.removeField(iPropertyName);
    }

    public String[] propertyNames() {
        return this.document.fieldNames();
    }

    public OGraphElement setDocument(ODocument iDocument) {
        this.document = iDocument;
        return this;
    }

    public ODatabaseGraphTx getDatabase() {
        return this.database;
    }

    private void init() {
        this.document.setListener(this);
    }
}

