/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.object;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.object.OObjectNotDetachedException;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.dictionary.ODictionaryWrapper;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.iterator.OObjectIteratorCluster;
import com.orientechnologies.orient.core.iterator.OObjectIteratorMultiCluster;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.tx.OTransactionRecordEntry;
import java.util.ArrayList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODatabaseObjectTx
extends ODatabasePojoAbstract<Object>
implements ODatabaseObject,
OUserObject2RecordHandler {
    private ODictionary<Object> dictionary;
    private OEntityManager entityManager;
    private boolean saveOnlyDirty;

    public ODatabaseObjectTx(String iURL) {
        super(new ODatabaseDocumentTx(iURL));
        ((ODatabaseDocumentTx)this.underlying).setDatabaseOwner(this);
        this.entityManager = OEntityManager.getEntityManagerByDatabaseURL(this.getURL());
        this.saveOnlyDirty = OGlobalConfiguration.OBJECT_SAVE_ONLY_DIRTY.getValueAsBoolean();
    }

    @Override
    public <T> T newInstance(Class<T> iType) {
        return (T)this.newInstance(iType.getName());
    }

    @Override
    public <RET> RET newInstance(String iClassName) {
        this.checkSecurity("database.class", 1, (Object)iClassName);
        try {
            return (RET)this.entityManager.createPojo(iClassName);
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on creating object of class " + iClassName, (Throwable)e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    @Override
    public <RET> OObjectIteratorMultiCluster<RET> browseClass(Class<RET> iClusterClass) {
        return this.browseClass(iClusterClass, true);
    }

    public <RET> OObjectIteratorMultiCluster<RET> browseClass(Class<RET> iClusterClass, boolean iPolymorphic) {
        if (iClusterClass == null) {
            return null;
        }
        return this.browseClass(iClusterClass.getSimpleName(), iPolymorphic);
    }

    public <RET> OObjectIteratorMultiCluster<RET> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    public <RET> OObjectIteratorMultiCluster<RET> browseClass(String iClassName, boolean iPolymorphic) {
        this.checkOpeness();
        this.checkSecurity("database.class", 2, (Object)iClassName);
        return new OObjectIteratorMultiCluster(this, (ODatabaseRecordAbstract)this.getUnderlying().getUnderlying(), iClassName, iPolymorphic);
    }

    @Override
    public <RET> OObjectIteratorCluster<RET> browseCluster(String iClusterName) {
        this.checkOpeness();
        this.checkSecurity("database.cluster", 2, (Object)iClusterName);
        return new OObjectIteratorCluster(this, (ODatabaseRecordAbstract)this.getUnderlying().getUnderlying(), this.getClusterIdByName(iClusterName));
    }

    @Override
    public ODatabaseObjectTx load(Object iPojo) {
        return this.load(iPojo, (String)null);
    }

    public void reload(Object iPojo) {
        this.reload(iPojo, (String)null, true);
    }

    @Override
    public void reload(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iPojo == null) {
            return;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        ((ODatabaseDocumentTx)this.underlying).reload(record, iFetchPlan, iIgnoreCache);
        this.stream2pojo(record, iPojo, iFetchPlan);
    }

    @Override
    public ODatabaseObjectTx load(Object iPojo, String iFetchPlan) {
        return this.load(iPojo, iFetchPlan, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabaseObjectTx load(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iPojo == null) {
            return this;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(record, iFetchPlan, iIgnoreCache);
            this.stream2pojo(record, iPojo, iFetchPlan);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        record.setInternalStatus(ORecordElement.STATUS.LOADED);
        return this;
    }

    @Override
    public Object load(ORID iRecordId) {
        return this.load(iRecordId, (String)null);
    }

    @Override
    public Object load(ORID iRecordId, String iFetchPlan) {
        return this.load(iRecordId, iFetchPlan, false);
    }

    @Override
    public Object load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        this.checkOpeness();
        if (iRecordId == null) {
            return null;
        }
        ODocument record = (ODocument)this.rid2Records.get(iRecordId);
        if (record == null && (record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache)) == null) {
            return null;
        }
        Object result = this.records2Objects.get(record);
        if (result != null) {
            return result;
        }
        result = this.stream2pojo(record, this.newInstance(record.getClassName()), iFetchPlan);
        this.registerUserObject(result, record);
        return result;
    }

    public ODatabaseObject save(Object iContent) {
        return this.save(iContent, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODatabaseObject save(Object iPojo, String iClusterName) {
        this.checkOpeness();
        if (iPojo == null) {
            return this;
        }
        ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        ODocument record = this.getRecordByUserObject(iPojo, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
            if (!this.saveOnlyDirty || record.isDirty()) {
                this.pojo2Stream(iPojo, record);
                ((ODatabaseDocumentTx)this.underlying).save((ORecordInternal)record, iClusterName);
                this.registerUserObject(iPojo, record);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        record.setInternalStatus(ORecordElement.STATUS.LOADED);
        return this;
    }

    public ODatabaseObject delete(Object iPojo) {
        this.checkOpeness();
        if (iPojo == null) {
            return this;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            ORecordId rid = OObjectSerializerHelper.getObjectID(this, iPojo);
            if (rid == null) {
                throw new OObjectNotDetachedException("Can't retrieve the object's ID for '" + iPojo + "' because hasn't been detached");
            }
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(rid);
        }
        ((ODatabaseDocumentTx)this.underlying).delete(record);
        if (this.getTransaction() instanceof OTransactionNoTx) {
            this.unregisterPojo(iPojo, record);
        }
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClassName);
    }

    public long countClass(Class<?> iClass) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClass.getSimpleName());
    }

    @Override
    public ODictionary<Object> getDictionary() {
        this.checkOpeness();
        if (this.dictionary == null) {
            this.dictionary = new ODictionaryWrapper(this);
        }
        return this.dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabasePojoAbstract<Object> commit() {
        try {
            ((ODatabaseRecordTx)((ODatabaseDocumentTx)this.underlying).getUnderlying()).commit();
            if (this.getTransaction().getAllRecordEntries() != null) {
                Object pojo = null;
                for (OTransactionRecordEntry oTransactionRecordEntry : this.getTransaction().getAllRecordEntries()) {
                    pojo = this.records2Objects.get(oTransactionRecordEntry.getRecord());
                    if (pojo == null) continue;
                    switch (oTransactionRecordEntry.status) {
                        case 3: {
                            this.rid2Records.put(oTransactionRecordEntry.getRecord().getIdentity(), (ODocument)oTransactionRecordEntry.getRecord());
                            OObjectSerializerHelper.setObjectID(oTransactionRecordEntry.getRecord().getIdentity(), pojo);
                        }
                        case 1: {
                            OObjectSerializerHelper.setObjectVersion(oTransactionRecordEntry.getRecord().getVersion(), pojo);
                            break;
                        }
                        case 2: {
                            OObjectSerializerHelper.setObjectID(null, pojo);
                            OObjectSerializerHelper.setObjectVersion(null, pojo);
                            this.unregisterPojo(pojo, (ODocument)oTransactionRecordEntry.getRecord());
                        }
                    }
                }
            }
            Object var5_4 = null;
            this.getTransaction().close();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.getTransaction().close();
            throw throwable;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODatabasePojoAbstract<Object> rollback() {
        try {
            Object pojo;
            ArrayList<OTransactionRecordEntry> newEntries;
            if (this.getTransaction().getCurrentRecordEntries() != null) {
                newEntries = new ArrayList<OTransactionRecordEntry>();
                for (OTransactionRecordEntry oTransactionRecordEntry : this.getTransaction().getCurrentRecordEntries()) {
                    if (oTransactionRecordEntry.status != 3) continue;
                    newEntries.add(oTransactionRecordEntry);
                }
            } else {
                newEntries = null;
            }
            ((ODatabaseRecordTx)((ODatabaseDocumentTx)this.underlying).getUnderlying()).rollback();
            if (newEntries != null) {
                Object pojo2 = null;
                for (OTransactionRecordEntry entry : newEntries) {
                    pojo2 = this.records2Objects.get(entry.getRecord());
                    OObjectSerializerHelper.setObjectID(null, pojo2);
                    OObjectSerializerHelper.setObjectVersion(null, pojo2);
                }
            }
            if (this.getTransaction().getCurrentRecordEntries() != null) {
                for (OTransactionRecordEntry oTransactionRecordEntry : this.getTransaction().getCurrentRecordEntries()) {
                    this.rid2Records.remove(oTransactionRecordEntry.getRecord().getIdentity());
                    pojo = this.records2Objects.remove(oTransactionRecordEntry.getRecord());
                    if (pojo == null) continue;
                    this.objects2Records.remove(pojo);
                }
            }
            if (this.getTransaction().getAllRecordEntries() != null) {
                for (OTransactionRecordEntry oTransactionRecordEntry : this.getTransaction().getAllRecordEntries()) {
                    this.rid2Records.remove(oTransactionRecordEntry.getRecord().getIdentity());
                    pojo = this.records2Objects.remove(oTransactionRecordEntry.getRecord());
                    if (pojo == null) continue;
                    this.objects2Records.remove(pojo);
                }
            }
            Object var6_11 = null;
            this.getTransaction().close();
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            this.getTransaction().close();
            throw throwable;
        }
        return this;
    }

    @Override
    public OEntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public ODatabaseDocument getUnderlying() {
        return (ODatabaseDocument)this.underlying;
    }

    @Override
    public int getVersion(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getVersion();
        }
        return OObjectSerializerHelper.getObjectVersion(iPojo);
    }

    @Override
    public ORID getIdentity(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getIdentity();
        }
        return OObjectSerializerHelper.getObjectID(this, iPojo);
    }

    public boolean isSaveOnlyDirty() {
        return this.saveOnlyDirty;
    }

    public void setSaveOnlyDirty(boolean saveOnlyDirty) {
        this.saveOnlyDirty = saveOnlyDirty;
    }

    @Override
    public Object newInstance() {
        this.checkOpeness();
        return new ODocument((ODatabaseRecord)this.underlying);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, byte iOperation) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, int iOperation, Object iResourceSpecific) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourceSpecific);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(String iResource, int iOperation, Object ... iResourcesSpecific) {
        return ((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourcesSpecific);
    }

    @Override
    public ODocument pojo2Stream(Object iPojo, ODocument iRecord) {
        return OObjectSerializerHelper.toStream(iPojo, iRecord, this.getEntityManager(), this.getMetadata().getSchema().getClass(iPojo.getClass().getSimpleName()), this, this, this.saveOnlyDirty);
    }

    @Override
    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iRecord = (ODocument)iRecord.load();
        }
        return OObjectSerializerHelper.fromStream(iRecord, iPojo, this.getEntityManager(), this, iFetchPlan);
    }
}

