/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTrackedMap<T>
extends LinkedHashMap<Object, T>
implements ORecordElement {
    protected final ORecord<?> sourceRecord;
    private ORecordElement.STATUS status = ORecordElement.STATUS.NOT_LOADED;
    protected static final Object ENTRY_REMOVAL = new Object();

    public OTrackedMap(ORecord<?> iSourceRecord) {
        this.sourceRecord = iSourceRecord;
        if (iSourceRecord != null) {
            iSourceRecord.setDirty();
        }
    }

    @Override
    public T put(Object iKey, T iValue) {
        Object oldValue = super.get(iKey);
        if (oldValue != null && oldValue == iValue) {
            return (T)oldValue;
        }
        this.setDirty();
        return super.put(iKey, iValue);
    }

    @Override
    public T remove(Object iKey) {
        this.setDirty();
        return (T)super.remove(iKey);
    }

    @Override
    public void clear() {
        this.setDirty();
        super.clear();
    }

    @Override
    public void putAll(Map<? extends Object, ? extends T> m) {
        super.putAll(m);
    }

    public OTrackedMap<T> setDirty() {
        if (this.status != ORecordElement.STATUS.UNMARSHALLING && this.sourceRecord != null && !this.sourceRecord.isDirty()) {
            this.sourceRecord.setDirty();
        }
        return this;
    }

    @Override
    public void onBeforeIdentityChanged(ORID iRID) {
        this.remove(iRID);
    }

    @Override
    public void onAfterIdentityChanged(ORecord<?> iRecord) {
        super.put(iRecord.getIdentity(), iRecord);
    }

    @Override
    public boolean setDatabase(ODatabaseRecord iDatabase) {
        boolean changed = false;
        for (Map.Entry e : this.entrySet()) {
            if (e.getKey() instanceof ORecordElement && ((ORecordElement)e.getKey()).setDatabase(iDatabase)) {
                changed = true;
            }
            if (!(e.getValue() instanceof ORecordElement) || !((ORecordElement)e.getValue()).setDatabase(iDatabase)) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public ORecordElement.STATUS getInternalStatus() {
        return this.status;
    }

    @Override
    public void setInternalStatus(ORecordElement.STATUS iStatus) {
        this.status = iStatus;
    }
}

