/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OFetchHelper {
    private static final String ANY_FIELD = "*";

    public static Map<String, Integer> buildFetchPlan(String iFetchPlan) {
        HashMap<String, Integer> fetchPlan;
        if (iFetchPlan != null) {
            List<String> planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0]);
            if (planParts.size() > 0) {
                fetchPlan = new HashMap<String, Integer>();
                for (String planPart : planParts) {
                    List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                    fetchPlan.put(parts.get(0), Integer.parseInt(parts.get(1)));
                }
            } else {
                fetchPlan = null;
            }
        } else {
            fetchPlan = null;
        }
        return fetchPlan;
    }

    public static void fetch(ODocument iRootRecord, Object iUserObject, Map<String, Integer> iFetchPlan, String iCurrentField, int iCurrentLevel, int iMaxFetch, OFetchListener iListener) {
        if (iMaxFetch > -1 && iListener.size() >= iMaxFetch) {
            return;
        }
        Integer anyFieldDepthLevel = iFetchPlan != null && iFetchPlan.get(ANY_FIELD) != null ? iFetchPlan.get(ANY_FIELD) : Integer.valueOf(0);
        try {
            for (String fieldName : iRootRecord.fieldNames()) {
                Object userObject;
                Object linked;
                Object fieldValue = iRootRecord.field(fieldName);
                if (fieldValue == null || !(fieldValue instanceof ODocument) && (!(fieldValue instanceof Collection) || ((Collection)fieldValue).size() > 0 && !(((Collection)fieldValue).iterator().next() instanceof ODocument)) && (!(fieldValue instanceof Map) || ((Map)fieldValue).size() > 0 && !(((Map)fieldValue).values().iterator().next() instanceof ODocument))) continue;
                Integer depthLevel = OFetchHelper.getDepthLevel(iRootRecord, iFetchPlan, fieldName);
                if (depthLevel == null) {
                    depthLevel = anyFieldDepthLevel;
                }
                if (depthLevel == 0 || depthLevel > -1 && iCurrentLevel >= depthLevel) continue;
                if (fieldValue instanceof ODocument) {
                    linked = (ODocument)fieldValue;
                    try {
                        userObject = iListener.fetchLinked(iRootRecord, iUserObject, fieldName, linked);
                        if (userObject != null) {
                            OFetchHelper.fetch((ODocument)linked, userObject, iFetchPlan, fieldName, iCurrentLevel + 1, iMaxFetch, iListener);
                        }
                    }
                    catch (ORecordNotFoundException e) {
                        OLogManager.instance().error(null, "Linked record %s was not found", new Object[]{linked});
                    }
                } else if (fieldValue instanceof Collection) {
                    linked = (Collection)fieldValue;
                    userObject = iListener.fetchLinked(iRootRecord, iUserObject, fieldName, linked);
                    if (userObject != null) {
                        for (ODocument d : (Collection)userObject) {
                            if (d == null) continue;
                            OFetchHelper.fetch(d, d, iFetchPlan, fieldName, iCurrentLevel + 1, iMaxFetch, iListener);
                        }
                    }
                } else if (fieldValue instanceof Map && (userObject = iListener.fetchLinked(iRootRecord, iUserObject, fieldName, linked = (Map)fieldValue)) != null) {
                    for (ODocument d : ((Map)userObject).values()) {
                        if (d == null) continue;
                        OFetchHelper.fetch(d, d, iFetchPlan, fieldName, iCurrentLevel + 1, iMaxFetch, iListener);
                    }
                }
                if (iMaxFetch <= -1 || iListener.size() < iMaxFetch) continue;
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            OLogManager.instance().error(null, "Fetching error on record %s", (Throwable)e, new Object[]{iRootRecord.getIdentity()});
        }
    }

    public static void checkFetchPlanValid(String iFetchPlan) {
        if (iFetchPlan != null && iFetchPlan.length() > 0) {
            List<String> planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0]);
            if (planParts.size() > 0) {
                for (String planPart : planParts) {
                    List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                    if (parts.size() == 2) continue;
                    throw new IllegalArgumentException("Fetch plan '" + iFetchPlan + "' is invalid");
                }
            } else {
                throw new IllegalArgumentException("Fetch plan '" + iFetchPlan + "' is invalid");
            }
        }
    }

    public static boolean isFetchPlanValid(String iFetchPlan) {
        if (iFetchPlan != null && iFetchPlan.length() > 0) {
            List<String> planParts = OStringSerializerHelper.split(iFetchPlan, ' ', new char[0]);
            if (planParts.size() > 0) {
                for (String planPart : planParts) {
                    List<String> parts = OStringSerializerHelper.split(planPart, ':', new char[0]);
                    if (parts.size() == 2) continue;
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static Integer getDepthLevel(ODocument doc, Map<String, Integer> iFetchPlan, String iFieldName) {
        Integer depthLevel;
        if (iFetchPlan != null) {
            depthLevel = iFetchPlan.get(iFieldName);
            if (depthLevel == null) {
                OClass cls = doc.getSchemaClass();
                while (cls != null && depthLevel == null) {
                    depthLevel = iFetchPlan.get(cls.getName() + "." + iFieldName);
                    if (depthLevel != null) continue;
                    cls = cls.getSuperClass();
                }
            }
        } else {
            depthLevel = -1;
        }
        return depthLevel;
    }
}

