/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.hook;

import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODocumentHookAbstract
implements ORecordHook {
    public boolean onRecordBeforeCreate(ODocument iDocument) {
        return false;
    }

    public boolean onRecordAfterCreate(ODocument iDocument) {
        return false;
    }

    public boolean onRecordBeforeRead(ODocument iDocument) {
        return false;
    }

    public boolean onRecordAfterRead(ODocument iDocument) {
        return false;
    }

    public boolean onRecordBeforeUpdate(ODocument iDocument) {
        return false;
    }

    public boolean onRecordAfterUpdate(ODocument iDocument) {
        return false;
    }

    public boolean onRecordBeforeDelete(ODocument iDocument) {
        return false;
    }

    public boolean onRecordAfterDelete(ODocument iDocument) {
        return false;
    }

    @Override
    public boolean onTrigger(ORecordHook.TYPE iType, ORecord<?> iRecord) {
        if (iRecord.getDatabase() != null && iRecord.getDatabase().getStatus() != ODatabase.STATUS.OPEN) {
            return false;
        }
        if (!(iRecord instanceof ODocument)) {
            return false;
        }
        ODocument document = (ODocument)iRecord;
        switch (iType) {
            case BEFORE_CREATE: {
                return this.onRecordBeforeCreate(document);
            }
            case AFTER_CREATE: {
                return this.onRecordAfterCreate(document);
            }
            case BEFORE_READ: {
                return this.onRecordBeforeRead(document);
            }
            case AFTER_READ: {
                return this.onRecordAfterRead(document);
            }
            case BEFORE_UPDATE: {
                return this.onRecordBeforeUpdate(document);
            }
            case AFTER_UPDATE: {
                return this.onRecordAfterUpdate(document);
            }
            case BEFORE_DELETE: {
                return this.onRecordBeforeDelete(document);
            }
            case AFTER_DELETE: {
                return this.onRecordAfterDelete(document);
            }
        }
        return false;
    }
}

