/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordTrackedSet;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexCallback;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.index.OIndexMultiValues;
import com.orientechnologies.orient.core.index.OIndexRemoteMultiValue;
import com.orientechnologies.orient.core.index.OIndexRemoteOneValue;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexManagerRemote
extends OIndexManagerAbstract {
    private static final String QUERY_CREATE = "create index %s %s %s";
    private static final String QUERY_DROP = "drop index %s";

    public OIndexManagerRemote(ODatabaseRecord iDatabase) {
        super(iDatabase);
    }

    @Override
    protected synchronized OIndex<?> getIndexInstance(OIndex<?> iIndex) {
        if (iIndex instanceof OIndexMultiValues) {
            return new OIndexRemoteMultiValue(iIndex.getName(), iIndex.getType(), iIndex.getIdentity());
        }
        return new OIndexRemoteOneValue(iIndex.getName(), iIndex.getType(), iIndex.getIdentity());
    }

    @Override
    public synchronized OIndex<?> createIndex(String iName, String iType, OType iKeyType, int[] iClusterIdsToIndex, OIndexCallback iCallback, OProgressListener iProgressListener, boolean iAutomatic) {
        String text = String.format(QUERY_CREATE, new Object[]{iName, iType, iKeyType});
        this.getDatabase().command(new OCommandSQL(text)).execute(new Object[0]);
        this.document.setIdentity(new ORecordId(this.document.getDatabase().getStorage().getConfiguration().indexMgrRecordId));
        this.reload();
        return (OIndex)this.indexes.get(iName.toLowerCase());
    }

    @Override
    public synchronized OIndexManager dropIndex(String iIndexName) {
        String text = String.format(QUERY_DROP, iIndexName);
        this.getDatabase().command(new OCommandSQL(text)).execute(new Object[0]);
        this.indexes.remove(iIndexName.toLowerCase());
        return this;
    }

    public OIndexManager dropClassIndexes(String iIndexName) {
        return null;
    }

    @Override
    protected synchronized void fromStream() {
        Collection idxs = (Collection)this.document.field("indexes");
        if (idxs != null) {
            for (ODocument d : idxs) {
                Object index = OIndexFactory.instance().newInstance(this.getDatabase(), (String)d.field("type"));
                d.setDatabase(this.getDatabase());
                index.loadFromConfiguration(d);
                this.indexes.put(index.getName().toLowerCase(), index);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            ORecordTrackedSet idxs = new ORecordTrackedSet(this.document);
            for (OIndexInternal i : this.indexes.values()) {
                idxs.add(i.updateConfiguration());
            }
            this.document.field("indexes", idxs, OType.EMBEDDEDSET);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
            throw throwable;
        }
        this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        this.document.setDirty();
        return this.document;
    }
}

